package de.lunqual.rzpro.items.zutatenverzeichnis;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rechnen.RechenZeile;

public class ZutatenverzeichnisListe extends java.util.ArrayList {

RzPro rz;

	double staerke=0.0;
	RechenItem ri;
	double Alkohol=0.0;
	double Wasser=0.0;
	String	bezeichnung;
	ZutatenverzeichnisKurzListe zvk;
	String text;
	String titel;

	public ZutatenverzeichnisListe(RzPro rz) {
		super();
		this.rz = rz;
	}

	public ZutatenverzeichnisItem getItem(int i) {
		return (ZutatenverzeichnisItem)this.get(i);
	}

	public void addItem(ZutatenverzeichnisItem zi,int pos) {
		this.add(pos,zi);
	}

	public void moveUp(int i) {

	}

	public void  moveDown(int i) {

	}

	public void moveTop(int i) {

	}

	public void  moveBottom(int i) {

	}

	public double getStaerke() {
		return staerke;
	}

	public void setStaerke(double staerke) {
		this.staerke = staerke;
	}

	public double getAlkohol() {
		return staerke;
	}

	public void reIndex() {
		for (int i = 0;i < this.size();i++) {
			this.getItem(i).setPriority(i);
		}
	}

	public RechenItem getRi() {
		return ri;
	}

	public void setRi(RechenItem ri) {
		this.ri = ri;
		this.bezeichnung=ri.getBezeichnung();
		rechnen();
	}

	public double getWasser() {
		return Wasser;
	}

	public void setWasser(double wasser) {
		Wasser = wasser;
	}

	public void setAlkohol(double alkohol) {
		Alkohol = alkohol;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}



	public ZutatenverzeichnisKurzListe getZvk() {
		return zvk;
	}

	public void setZvk(ZutatenverzeichnisKurzListe zvk) {
		this.zvk = zvk;
	}



	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String getTitel() {
		return titel;
	}

	public void setTitel(String titel) {
		this.titel = titel;
	}

	public void rechnen() {
		ZutatenverzeichnisItem zi ;
		Wasser = 0;
		//erst alle Zutaten über Stichworte summieren
		for (int i =0;i < this.size();i++) {
			zi = this.getItem(i);
			zi.start();
			for (int r = 0; r < ri.getZeilenListe().size();r++) {
				final RechenZeile zeile = ri.getZeilenListe().getItem(r);
				if(zeile.isRechnen()) {
					if(!zeile.isMarked()) {
						if(zeile.getRezeptur().getStichwortListe().isInList(zi.getStichwort().getID())) {
							zeile.setMarked(true);
							double v=0.0;
							switch (zi.getEinheit()) {
								case RzPro.EINHEIT_LITER:
									v=zi.getWert() * zeile.getLiter();
									if(!rz.isZero(v-1.0)) {
										Wasser -= v - zeile.getLiter();
									}
									zi.add( v);
									break;
								case RzPro.EINHEIT_LA:
									v=zi.getWert() * zeile.getLa();
									if(!rz.isZero(v-1.0)) {
										Wasser -= v - zeile.getLa();
									}
									zi.add( v);
									break;
								case RzPro.EINHEIT_KG:
									v=zi.getWert() * zeile.getKg();
									if(!rz.isZero(v-1.0)) {
										Wasser -= v - zeile.getKg();
									}
									zi.add( v);
									break;
							}
						}
					}
				}
			}
		}
		//und jetzt der Rest, der nicht über Stichworte erfasst wird
		for (int r = 0; r < ri.getZeilenListe().size();r++) {
			final RechenZeile zeile = ri.getZeilenListe().getItem(r);
			if(zeile.isRechnen()) {
				if(!zeile.isMarked()) {
					zeile.setMarked(true);
					int einheit = RzPro.EINHEIT_LITER;
					if(!rz.isZero(zeile.getStaerke())){
						einheit = RzPro.EINHEIT_LA;
					} else {
						einheit = RzPro.EINHEIT_LITER;
					}
					zi = new ZutatenverzeichnisItem(rz,0, 0,null , einheit, 1.0, zeile.getRezeptur().getTitel());
					switch (zi.getEinheit()) {
						case RzPro.EINHEIT_LITER:zi.add(zeile.getLiter());
							break;
						case RzPro.EINHEIT_LA: zi.add(zeile.getLiter());
							break;
					}
					this.addItem(zi,0);
				}
			}
		}

		// jetzt der Alkohol dazu
		Alkohol = ri.getStaerke();
		zi = new ZutatenverzeichnisItem(rz,0, 0,null , RzPro.EINHEIT_LA, 1.0, rz.getLocale().getString("zutatenverzeichnis.alkohol"));;
		zi.add(Alkohol);
		this.addItem(zi,0);
		//Wasser
		Wasser  += ri.getWasserP();
		zi = new ZutatenverzeichnisItem(rz,0, 0,null , RzPro.EINHEIT_LA, 1.0, rz.getLocale().getString("zutatenverzeichnis.wasser"));;
		zi.add(Wasser);
		this.addItem(zi,0);
		//Die endgültige Liste zusammenstellen
		this.zvk = new ZutatenverzeichnisKurzListe();
		for(int i=0;i< this.size();i++) {
			if(!rz.isZero(this.getItem(i).getSumme())) {
				zvk.addItem(this.getItem(i).getBezeichnung(),this.getItem(i).getSumme());
			}
		}
		zvk.sortItems();
	}
}
