package de.lunqual.rzpro.items.zutatenverzeichnis;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;


public class ZutatenverzeichnisKurzListe extends ArrayList {

	 private final Collator        		coll;
	 private final Comparator      	comp;
	 public ZutatenverzeichnisKurzListe() {
		super();
		coll = Collator.getInstance(Locale.getDefault());
		 comp=new Comparator() {
	            public int compare(Object o1,Object o2){
	            	final ZutatenverzeichnisKurzItem b1 = (ZutatenverzeichnisKurzItem)o1;
	            	final ZutatenverzeichnisKurzItem b2 = (ZutatenverzeichnisKurzItem)o2;
	            	int r=0;
	                if (b1.getValue() > b2.getValue() ) {
	                	r=-1;
	                }else {
	                	if (b1.getValue() < b2.getValue() ) {
	                		r=1;
	                	}
	                }
	                return r;
	            }
	        };
	}

	public ZutatenverzeichnisKurzItem getItem(int i) {
		return (ZutatenverzeichnisKurzItem)this.get(i);
	}

	public void addItem(String bezeichnung,double value) {
		final int l = isInList(bezeichnung);
		if (l == -1)
		{
			this.add(new ZutatenverzeichnisKurzItem(bezeichnung.trim(),value));
		}else {
			this.getItem(l).add(value);
		}
	}

	private int isInList(String bezeichnung) {
		for(int i =0;i < this.size();i++) {
			if(bezeichnung.equals(this.getItem(i).getBezeichnung())) {
				return i;
			}
		}
		return -1;
	}

    public void sortItems(){
        Collections.sort(this,comp);
    }
}
