package de.lunqual.rzpro.items.zutatenverzeichnis;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.stichworte.StichwortItem;

public class ZutatenverzeichnisItem {
	int id;
	int priority;
	StichwortItem stichwort;
	int einheit;
	double wert;
	String bezeichnung;
	RzPro rz;
	double summe;

	public ZutatenverzeichnisItem(RzPro rz,int id, int priority,StichwortItem stichwort , int einheit, double wert, String bezeichnung) {
		this.rz=rz;
		this.id = id;
		this.priority = priority;
		this.stichwort=stichwort;
		this.einheit = einheit;
		this.wert = wert;
		this.bezeichnung = bezeichnung;
		summe=0.0;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getPriority() {
		return priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}

	public void setStichwort(StichwortItem stichwort) {
		this.stichwort = stichwort;
	}

	public StichwortItem getStichwort() {
		return stichwort;
	}



	public int getEinheit() {
		return einheit;
	}

	public void setEinheit(int einheit) {
		this.einheit = einheit;
	}

	public double getWert() {
		return wert;
	}

	public void setWert(double wert) {
		this.wert = wert;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public ZutatenverzeichnisItem copyItem() {
		return new ZutatenverzeichnisItem(this.rz,
				this.id,
				this.priority,
				this.stichwort != null ?this.stichwort.copyItem():null,
				this.einheit,
				this.wert,
				this.bezeichnung);
	}

	public void start() {
		summe=0.0;
	}

	public double getSumme() {
		return summe;
	}

	public void add (double value) {
		this.summe +=value;
	}


}
