package de.lunqual.rzpro.items.verbrauch;

import java.util.ArrayList;

public class VerbrauchsListe {

	int rezeptur;
	String bezeichnung;
	ArrayList zugangsListe;
	ArrayList abgangsListe;
	ArrayList rezepturListe;

	public VerbrauchsListe() {
		zugangsListe = new ArrayList();
		abgangsListe = new ArrayList();
		rezepturListe = new ArrayList();
	}

	public ArrayList getZugangsListe() {
		return zugangsListe;
	}

	public ArrayList getAbgangsListe() {
		return abgangsListe;
	}

	public int getRezeptur() {
		return rezeptur;
	}

	public void setRezeptur(int rezeptur) {
		this.rezeptur=rezeptur;
	}

	public void addZugang(VerbrauchsItem vi) {
		this.zugangsListe.add(0,vi);
	}

	public void addAbgang(VerbrauchsItem vi) {
		this.abgangsListe.add(0,vi);
	}

	public VerbrauchsItem getZugang(int i) {
		return (VerbrauchsItem)this.zugangsListe.get(i);
	}
	public VerbrauchsItem getAbgang(int i) {
		return (VerbrauchsItem)this.abgangsListe.get(i);
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public ArrayList getRezepturListe() {
		return rezepturListe;
	}

	public void rechnen() {
		double liter=0.0;
		double kg=0.0;
		double la=0.0;
		int i;
		for(i=0;i< zugangsListe.size();i++) {
			final VerbrauchsItem vi = (VerbrauchsItem)zugangsListe.get(i);
			liter += vi.getLiter();
			kg += vi.getKg();
			la += vi.getLa();
		}
		zugangsListe.add(new VerbrauchsItem(0,liter,kg,la));
		liter=0.0;
		kg=0.0;
		la=0.0;
		for(i=0;i< abgangsListe.size();i++) {
			final VerbrauchsItem vi = (VerbrauchsItem)abgangsListe.get(i);
			liter += vi.getLiter();
			kg += vi.getKg();
			la += vi.getLa();
		}
		abgangsListe.add(new VerbrauchsItem(0,liter,kg,la));

	}
}
