package de.lunqual.rzpro.items.trace;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsListe;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.dm.DMItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.options.OptionFactory;

public class TraceItem {

	public static final int TRACE_RECURSION_MAX=6;

	RzPro 				rz;
	SimpleDateFormat		df;
	SimpleDateFormat 	dfMHD;
	TraceTextItem		text;
	int					recursion_max;
	int					recursion;
	String 				titel;
	HerstellungsItem 	hi;

	
	public TraceItem(RzPro rz,int id) {
		this.rz = rz;
		recursion_max = rz.getOptionFactory().getOption("trace.recursion.max", TRACE_RECURSION_MAX);
		recursion=0;
		dfMHD = new SimpleDateFormat("MMMM yyyy");
		hi = rz.getDatabase().getBuchungen().getEinzelHerstellung(id);
		if(hi != null) {
			titel = 	rz.getLocale().getString("traceitem.label.titel")
					.replaceAll("%t", hi.getBezeichnung())
					.replaceAll("%l", hi.getLosnummer())
				;
		
			df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
			text = new TraceTextItem(rz);
			
			getHeader(hi,0);
		}
	}

	public void reload() {
		if(hi != null) {
			text = new TraceTextItem(rz);
			getHeader(hi,0);
		}
	}
	
	public String getTitel() {
		return rz.getLocale().getString("trace.titel");
	}
	
	public TraceTextItem getText() {
		return text;
	}
	
	public String getLabelTitel() {
		return titel;
	}
	
	public int getRezeptur() {
		return  hi == null?0:hi.getRezeptur();
	}

	private void getHeader(HerstellungsItem hi,int l) {
		recursion++;
		BuchungsListe buchungen = rz.getDatabase().getBuchungen().getLosnummerHistory("^"+hi.getLosnummer().replaceAll("\\s", ".")+"$","","");
		BuchungsItem bZugang = null;
		if(buchungen.size()>0) {
			bZugang = buchungen.getItem(0);
		}
		RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(hi.getRezeptur(), true);
		if(ri != null) {
			text.addZeile(TraceTextItem.TRACE_H1, l+0, rz.getLocale().getString("trace.header.header.1")
					.replaceAll("%d", hi.getLosnummer())
					.replaceAll("%n", hi.getBezeichnung())
					.replaceAll("%i", ri.getTitel())
					);
			text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.bezeichnung.1")
					.replaceAll("%d", hi.getBezeichnung())
					.replaceAll("%i", ri.getTitel())
					);
		} else {
			text.addZeile(TraceTextItem.TRACE_H1, l+0, rz.getLocale().getString("trace.header.header").replaceAll("%d", hi.getLosnummer()).replaceAll("%n", hi.getBezeichnung()));
			text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.bezeichnung").replaceAll("%d", hi.getBezeichnung()));
		}
	
		text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.charge").replaceAll("%d", hi.getLosnummer()));
		text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.hergestellt").replaceAll("%d",df.format(hi.getDatum())));
		text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.header.bemerkungen").replaceAll("%d", bZugang.getComment()));
		text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.header.user").replaceAll("%d", hi.getUser()));
		text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.header.menge")
				.replaceAll("%l",rz.getLocale().formatNumber(hi.getLiter(),OptionFactory.NF_ONE))
				.replaceAll("%k",rz.getLocale().formatNumber(hi.getKg(),OptionFactory.NF_ONE))
				.replaceAll("%a",rz.getLocale().formatNumber(hi.getLa(),OptionFactory.NF_ONE))
				);
		if(bZugang.isRest()) {
			text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.header.restmenge")
					.replaceAll("%l",rz.getLocale().formatNumber(bZugang.getRest_liter(),OptionFactory.NF_ONE))
					.replaceAll("%k",rz.getLocale().formatNumber(bZugang.getRest_kg(),OptionFactory.NF_ONE))
					.replaceAll("%a",rz.getLocale().formatNumber(bZugang.getRest_la(),OptionFactory.NF_ONE))
					);
		} else {
			text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.header.kein_rest"));
		}
		text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.probe").replaceAll("%d", rz.getDatabase().getProben().getProbenListeLosnummer(hi.getLosnummer())));
		BewertungsItem bew = rz.getDatabase().getBewertungen().getBewertung(hi.getLosnummer(),hi.getBezeichnung());
		if(bew != null && bew.getId()!= 0) {
			text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.bewertung.2").replaceAll("%d", bew.getText()));
		} else {
			text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.header.keine_bewertung"));	
		}
		 String documents = rz.getDatabase().getDocuments().getDocumentListeText(hi.getRezeptur(),false);
		 if(!documents.equals("")) {
			 text.addZeile(TraceTextItem.TRACE_TEXT, l+1, rz.getLocale().getString("trace.dokument") +"<a href=\"doc:" +hi.getRezeptur() +"\">" + documents + "</a>");
		 }
		 if(rz.getDatabase().getDM().isConnected()) {
         	ArrayList<DMItem> dmliste = rz.getDatabase().getDM().getMessung(hi.getLosnummer());
		    	if(dmliste != null && !dmliste.isEmpty()) {
		    		String[] messungen = rz.getDatabase().getDM().getDMListeTrace(dmliste).split("#");
		    		for(String s:messungen) {
		    			if(!s.trim().equals(""))text.addZeile(TraceTextItem.TRACE_TEXT, l+1,s.replaceAll("#", ""));
		    		}
		    	}
		 }
		getAbgangsBuchungen(hi,buchungen,l);
	}
	
	private void getAbgangsBuchungen(HerstellungsItem hi,BuchungsListe buchungen,int l) {
		SimpleDateFormat df0 = new SimpleDateFormat("EEEE, dd.MM.yyyy HH:mm / D");
		SimpleDateFormat df1 = new SimpleDateFormat("D");
		SimpleDateFormat df2 = new SimpleDateFormat("yyyy");
		text.addZeile(TraceTextItem.TRACE_H1, l+0, rz.getLocale().getString("trace.buchungen.header").replaceAll("%d", hi.getLosnummer()));
		for(int i=0;i<buchungen.size();i++) {
			BuchungsItem bi = buchungen.getItem(i);
			if(bi != null) {
				String art="";
				if(bi.getTyp() == DBBuchung.TYP_ABGANG) {
					if (bi.getHerstellung_losnummer() != null && !bi.getHerstellung_losnummer().equals("")) {
						art = rz.getLocale().getString("trace.buchungen.zeile.abgang.herstellung");
					} else {
						art =  rz.getLocale().getString("trace.buchungen.zeile.abgang");
					}
				} else {
					art =  rz.getLocale().getString("trace.buchungen.zeile.zugang");
				}
				text.addZeile(TraceTextItem.TRACE_TEXT, l+1, art
						.replaceAll("%d", 
								df0.format(bi.getDatum()) + " ("+ rz.getDatabase().getKalender().getYear20(Integer.valueOf(df2.format(bi.getDatum()))) + rz.getDatabase().getKalender().getDate20(Integer.valueOf(df1.format(bi.getDatum())))+")"
								)
						.replaceAll("%u", bi.getUser())
						.replaceAll("%l", rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_ONE))
						.replaceAll("%h", bi.getHerstellung_losnummer())
						.replaceAll("%b", String.valueOf(bi.getId()))
				);
				if(!bi.getComment().trim().equals("")) {
					text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.buchungen.bemerkungen").replaceAll("%d", bi.getComment()));
				}
				if(bi.getMhd() != null) {
					text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.buchungen.mhd").replaceAll("%d", dfMHD.format(bi.getMhd())));	
				}
			}
		}
		getZutaten(hi,l);
	}
	
	private void getZutaten(HerstellungsItem hi,int l) {
		text.addZeile(TraceTextItem.TRACE_H1, l+0, rz.getLocale().getString("trace.zutaten.header").replaceAll("%d", hi.getLosnummer()).replaceAll("%n", hi.getBezeichnung()));
		BuchungsListe buchungen = rz.getDatabase().getBuchungen().getHerstellung(hi.getId());
		for(int i=1;i < buchungen.size();i++) {
			BuchungsItem bi = buchungen.getItem(i);
			if(bi != null && (bi.getTyp() == DBBuchung.TYP_ABGANG)) {
				RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(bi.getRezeptur_id(), true);
				if(ri != null) {
					BuchungsListe los = rz.getDatabase().getBuchungen().getLosnummerHistory("^"+bi.getLosnummer().replaceAll(" ",".")+"$", "", "");
					BuchungsItem bi1 = los.getItem(0);
					if(!bi.getBezeichnung().trim().equals(""))text.addZeile(TraceTextItem.TRACE_H2, l+1, rz.getLocale().getString("trace.zutaten.bezeichnung")
							.replaceAll("%d", bi.getBezeichnung())
							.replaceAll("%i", ri.getTitel())
							.replaceAll("%l",hi.getLosnummer())
							);
					if(!ri.getArtikelnummer().trim().equals(""))text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.zutaten.artikelnummer").replaceAll("%d",ri.getArtikelnummer()));
					if(!ri.getAdressListe().isEmpty())text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.zutaten.firma")
							.replaceAll("%d",ri.getAdressListe().toVerboseString())
							.replaceAll("%i", Matcher.quoteReplacement(ri.getAdressListe().toVerbosePatternString()))
						);
					
					 String documents = rz.getDatabase().getDocuments().getDocumentListeText(bi.getRezeptur_id(),false);
					 if(!documents.equals("")) {
						 text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.dokument") +"<a href=\"doc:" +bi.getRezeptur_id() +"\">" + documents + "</a>");
					 }
					if(bi1.getMischung() != 0) {
						text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.zutaten.losnummer.mischung")
								.replaceAll("%d",bi.getLosnummer())
								.replaceAll("%m", String.valueOf(bi.getMischung()))
								);
					}else {
						text.addZeile(TraceTextItem.TRACE_TEXT, l+2, rz.getLocale().getString("trace.zutaten.losnummer").replaceAll("%i",Matcher.quoteReplacement(bi.getLosnummer().replaceAll(" ", "."))).replaceAll("%d",bi.getLosnummer()));
					}
					if(bi1 != null) {
						text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.zutaten.los.eingang")
								.replaceAll("%d",df.format(bi1.getDatum()))
								.replaceAll("%u", bi1.getUser()));
						text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.zutaten.los.menge")
								.replaceAll("%l",rz.getLocale().formatNumber(bi1.getLiter(),OptionFactory.NF_ONE))
								.replaceAll("%k",rz.getLocale().formatNumber(bi1.getKg(),OptionFactory.NF_ONE))
								.replaceAll("%a",rz.getLocale().formatNumber(bi1.getLa(),OptionFactory.NF_ONE))
								);
						if(!bi1.getComment().trim().equals(""))text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.zutaten.los.bemerkungen").replaceAll("%d",bi1.getComment()));
						if(bi1.getMhd() != null )text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.zutaten.los.mhd").replaceAll("%d",dfMHD.format(bi1.getMhd())));
						text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.zutaten.los.letzte").replaceAll("%d",df.format(los.getLetzteAbgangsBuchung().getDatum())));
						if(bi1.isRest()) {
							text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.zutaten.los.restmenge")
									.replaceAll("%l",rz.getLocale().formatNumber(bi1.getRest_liter(),OptionFactory.NF_ONE))
									.replaceAll("%k",rz.getLocale().formatNumber(bi1.getRest_kg(),OptionFactory.NF_ONE))
									.replaceAll("%a",rz.getLocale().formatNumber(bi1.getRest_la(),OptionFactory.NF_ONE))
									);
						}else {
							text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getLocale().getString("trace.header.kein_rest"));
						}
						HerstellungsItem hii = rz.getDatabase().getBuchungen().getHerstellungFromLosnummer("^"+bi1.getLosnummer()+"$");
						if(hii != null && recursion <= recursion_max) {
							getHeader(hii,recursion);
						}
						 if(rz.getDatabase().getDM().isConnected()) {
					         	ArrayList<DMItem> dmliste = rz.getDatabase().getDM().getMessung(bi1.getLosnummer());
							    	if(dmliste != null && !dmliste.isEmpty()) {
							    		text.addZeile(TraceTextItem.TRACE_TEXT, l+3, rz.getDatabase().getDM().getDMListeTrace(dmliste).replaceAll("#", ""));	
							    	}
							 }
						if(bi1.getMischung() != 0) {
							MischungsItem mi = rz.getDatabase().getMischungen().getMischung(bi1.getMischung());
							text.addZeile(TraceTextItem.TRACE_H3, l+3, rz.getLocale().getString("trace.zutaten.los.mischung")
									.replaceAll("%d", String.valueOf(bi1.getMischung()))
									.replaceAll("%n", mi.getHeader().getBezeichnung()) + "&nbsp;" + "<a href=\"CH:" + bi1.getMischung()+ "\">" +  rz.getAusgabeFactory().insertGfx("tracefenster.icon_chart.png")+"</a>"); ;
							
							
							text.addZeile(TraceTextItem.TRACE_TEXT, l+4, rz.getLocale().getString("trace.zutaten.los.mischung.erstellt")
									.replaceAll("%d",mi.getHeader().getErstelltToString())
									.replaceAll("%u", mi.getHeader().getErstellt_user())
									.replaceAll("%t", mi.getHeader().getTank())
									);
							for(TicketItem ti:mi.getAllTickets()) {
								if(mi.getNegativeTicket(mi.getAllTickets(),ti) >= rz.getOptionFactory().getDouble("tracefenster.limit")) {
								switch(ti.getTyp()) {
									case TicketItem.TYP_WARE :
										text.addZeile(TraceTextItem.TRACE_TEXT, l+4, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket")
												.replaceAll("%d", ti.getNummer())
												.replaceAll("%u", ti.getErstellt_user())
												);
										text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.bezeichnung").replaceAll("%d", ti.getBezeichnung()));
										if(!ti.getAdresse().equals("")) {
											AdressItem ai = rz.getDatabase().getAdressen().dbGetAdresse(ti.getAdresse_id(), true);
											if(ai != null) {
												text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.firma")
													.replaceAll("%d", ti.getAdresse())
													.replaceAll("%i", Matcher.quoteReplacement("^"+ai.getFirma().replaceAll(" ", ".")+"$"))
													);
											}
										}
										if(!ti.getBemerkungen().trim().equals(""))text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.bemerkungen").replaceAll("%d", ti.getBemerkungen()));		
										if(!ti.getLosnummer().trim().equals(""))text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.losnummer").replaceAll("%d", ti.getLosnummer()));
										TicketItem tim = rz.getDatabase().getMischungen().getEinzelTicket(ti.getNummer());
										if(tim != null) {
											text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.original_datum")
													.replaceAll("%d",df.format(tim.getErstellt()))
													.replaceAll("%u", tim.getErstellt_user())		
													);
											text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.menge")
													.replaceAll("%d", rz.getLocale().formatNumber(tim.getLa(),OptionFactory.NF_ONE))
													.replaceAll("%p", rz.getLocale().formatNumber(tim.getStaerke(),OptionFactory.NF_STAERKE))
													);
										}
										text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.zugang_menge")
												.replaceAll("%d", rz.getLocale().formatNumber(ti.getLa(),OptionFactory.NF_ONE))
												.replaceAll("%p", rz.getLocale().formatNumber(ti.getStaerke(),OptionFactory.NF_STAERKE))
												.replaceAll("%i",rz.getLocale().formatNumber(mi.getNegativeTicket(mi.getAllTickets(),ti),OptionFactory.NF_NORMAL))
												);
										if(!ti.getLosnummer_original().trim().equals("")) {
										BuchungsListe bl = rz.getDatabase().getBuchungen().getLosnummerHistory(ti.getLosnummer_original().replaceAll(" ","."), "", "");
											if(bl != null && bl.size()>0) {
												text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.original_losnummer.link").replaceAll("%d", ti.getLosnummer_original()));
												BuchungsListe original = rz.getDatabase().getBuchungen().getLosnummerHistory("^"+ti.getLosnummer_original().replaceAll(" ", ".")+"$", "", "");
												if(original != null && original.size()>0) {
													BuchungsItem bio = original.getItem(0);
													text.addZeile(TraceTextItem.TRACE_TEXT, l+6, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.original_datum")
															.replaceAll("%d",df.format(bio.getDatum()))
															.replaceAll("%u", bio.getUser())		
															);
													text.addZeile(TraceTextItem.TRACE_TEXT, l+6, rz.getLocale().getString("trace.zutaten.los.menge")
															.replaceAll("%l",rz.getLocale().formatNumber(bio.getLiter(),OptionFactory.NF_ONE))
															.replaceAll("%k",rz.getLocale().formatNumber(bio.getKg(),OptionFactory.NF_ONE))
															.replaceAll("%a",rz.getLocale().formatNumber(bio.getLa(),OptionFactory.NF_ONE))
															);
												}
											} else {
												text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.original_losnummer").replaceAll("%d", ti.getLosnummer_original()));
											}
										}
										if(ti.getProbe() != 0)text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.probe").replaceAll("%d",String.valueOf(ti.getProbe())));
										if(ti.getBewertung() != 0) {
											text.addZeile(TraceTextItem.TRACE_TEXT, l+5, rz.getLocale().getString("trace.zutaten.los.mischung.warenticket.bewertung")
													.replaceAll("%d",String.valueOf(ti.getBewertung()))
													.replaceAll("%i",rz.getLocale().formatNumber(ti.getBewertungValue(), OptionFactory.NF_STAERKE))
													);
										}
										 if(rz.getDatabase().getDM().isConnected()) {
											 	String s = rz.getLocale().getString("dbdm.ticketmuster").replaceAll("%t", ti.getNummer()).replaceAll("%m", String.valueOf(ti.getMischung()));
									         	ArrayList<DMItem> dmliste = rz.getDatabase().getDM().getMessung(s);
											    	if(dmliste != null && !dmliste.isEmpty()) {
											    		String[] messungen = rz.getDatabase().getDM().getDMListeTrace(dmliste).split("#");
											    		for(String st:messungen) {
											    			if(!st.trim().equals(""))text.addZeile(TraceTextItem.TRACE_TEXT, l+1,st.replaceAll("#", ""));
											    		}
											    	}
											 }										
										break;
									case TicketItem.TYP_ABSCHLUSS:
										
										break;
								}
								}
							}
						}
					}
				}
			}
		}
	}

}
