package de.lunqual.rzpro.items.tank;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class tankItem {
	RzPro				rz;
	int					id;
	String 				nummer;
	String				comment;
	double 				liter;
	int					px;
	int					py;
	int					pr;
	int					ort;
	String				ortBezeichnung;
	String				ortComment;
	String 				inhaltIDs;
	int					inhaltID;
	boolean				meldebestand;
	tankInhaltsListe 	inhalt;
	boolean				mischung;
	
	
	public tankItem(RzPro rz,int id, String nummer, String comment, double liter,
			int px, int py, int pr, int ort, String ortBezeichnung,
			String ortComment,boolean mischung) {
		super();
		this.rz=rz;
		this.id = id;
		this.nummer = nummer;
		this.comment = comment;
		this.liter = liter;
		this.px = px;
		this.py = py;
		this.pr = pr;
		this.ort = ort;
		this.ortBezeichnung = ortBezeichnung;
		this.ortComment = ortComment;
		this.inhaltID=0;
		this.inhaltIDs = "";
		this.meldebestand = false;
		inhalt = new tankInhaltsListe(rz);
		this.mischung = mischung;
	}
	
	public tankItem(RzPro rz,String nummer) {
		super();
		this.rz=rz;
		this.id = 0;
		this.nummer = nummer;
		this.comment = "";
		this.liter = 0;
		this.px = 0;
		this.py = 0;
		this.pr = 50;
		this.ort = 0;
		this.ortBezeichnung = "";
		this.ortComment = "";		
		this.inhaltID=0;
		this.inhaltIDs = "";
		this.meldebestand = false;
		this.mischung=false;
		inhalt = new tankInhaltsListe(rz);
	}
	
	public boolean isMischung() {
		return inhalt == null?false:inhalt.isMischung();
	}

	public void setLocked(boolean mischung) {
		this.mischung = mischung;
	}

	public boolean isStellplatz() {
		return rz.isZero(liter)?true:false;
	}
	
	public void setStellplatz() {
		liter = 0;
	}
	
	public tankInhaltsListe getInhaltsListe() {
		return inhalt;
	}
	public boolean isEmpty() {
		return inhalt.isEmpty();
	}
	
	public boolean isMeldebestand() {
		return meldebestand;
	}

	public void setMeldebestand(boolean meldebestand) {
		this.meldebestand = meldebestand;
	}

	public int getPercentFull() {
		int ret = 0;
		if(inhalt.getRestLiter() > 0 && liter > 0) {
			try {
				ret = (int)(inhalt.getRestLiter() * 100/liter);
			}catch (Exception e) {}
		}
		ret =  ret > 100?100:ret;
		if(ret == 0 && !rz.isZero(inhalt.getRestLiter())) {
			ret = 1;
		}
		return ret;
	}
	
	
	public void setInhaltIDs(String inhaltIDs) {
		this.inhaltIDs = inhaltIDs;
	}

	public double getRestLiter() {
		return inhalt.getRestLiter();
	}

	public double getRestKg() {
		return inhalt.getRestKg();
	}
	
	public int getInhaltID() {
		for(tankInhaltsItem tii:inhalt) {
			if(tii.getRezeptur_id() != 0) {
				return tii.getRezeptur_id();
			}
		}
		return 0;
	}

	public void setInhaltID(int inhaltID) {
		this.inhaltID = inhaltID;
	}

	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getNummer() {
		return nummer;
	}
	public void setNummer(String nummer) {
		this.nummer = nummer;
	}
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	public double getLiter() {
		return liter;
	}
	public void setLiter(double liter) {
		this.liter = liter;
	}
	public int getPx() {
		return px;
	}
	public void setPx(int px) {
		this.px = px;
	}
	public int getPy() {
		return py;
	}
	public void setPy(int py) {
		this.py = py;
	}
	public int getPr() {
		return pr;
	}
	public void setPr(int pr) {
		this.pr = pr;
	}
	public int getOrt() {
		return ort;
	}
	public void setOrt(int ort) {
		this.ort = ort;
	}
	public String getOrtBezeichnung() {
		return ortBezeichnung;
	}
	public void setOrtBezeichnung(String ortBezeichnung) {
		this.ortBezeichnung = ortBezeichnung;
	}
	public String getOrtComment() {
		return ortComment;
	}
	public void setOrtComment(String ortComment) {
		this.ortComment = ortComment;
	}
	
	public tankItem clones() {
		tankItem ti = new tankItem(rz,id, nummer,comment,liter,
				px, py, pr, ort, ortBezeichnung,
				ortComment,mischung);
		for(tankInhaltsItem tai:inhalt) {
			ti.addInhalt(tai.clones());
		}
		return ti;
	}
	public String toString() {
		return rz.getLocale().getString("tankitem.tostring")
				.replaceAll("%o",ortBezeichnung)
				.replaceAll("%n", nummer)
				.replaceAll("%l",rz.getLocale().formatNumber(liter,OptionFactory.NF_ONE)
		);
	}
	
	public void addInhalt(tankInhaltsItem tii) {
		inhalt.addItem(tii);
	}
}
