package de.lunqual.rzpro.items.tank;

import java.util.HashMap;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class tankInhaltsListe extends java.util.ArrayList<tankInhaltsItem>{

	RzPro rz;
	
	public tankInhaltsListe(RzPro rz) {
		super();
		this.rz = rz;
	}

	public void addItem(tankInhaltsItem tii) {
		this.add(tii);
	}
	
	public tankInhaltsItem getItem(int i) {
		return this.get(i);
	}
	
	public double getRestKg() {
		double ret = 0.0;
		for(tankInhaltsItem tii:this) {
			ret += tii.getRestKg();
		}
		return ret;
	}
	
	public double getRestLiter() {
		double ret = 0.0;
		for(tankInhaltsItem tii:this) {
			ret += tii.getRestliter();
		}
		return ret;
	}
	
	public boolean isEmpty() {
		return rz.isZero(getRestLiter());
	}
	
	public boolean isMischung() {
		for(tankInhaltsItem tii:this) {
			if(tii.isMischung()) {
				return true;
			}
		}
		return false;
	}
	
	public int getMischungsNummer() {
		int ret = 0;
		if(isMischung()) {
			try {
				ret = Integer.valueOf(get(0).getLosnummer());
			} catch(Exception e) {}
		}
		return ret;
	}
	
	public String getInhaltBezeichnungMitMenge(boolean lager) {
		String ret = "";
		for(tankInhaltsItem tii:this) {
			if(tii.isStellplatz()) {
				ret += tii.getBezeichnung() + " (" + 
						rz.getLocale().formatNumber(tii.getRestliter(),OptionFactory.NF_ONE) + " " +rz.getLocale().getString("string_liter") + ", "+
						rz.getLocale().formatNumber(tii.getRestKg(),OptionFactory.NF_ONE) + " " +rz.getLocale().getString("string_kg") +
						" :" + tii.getLosnummer() + ")" +(lager?" "+rz.getLocale().getString("tankbelegungdrucken.lager")+ tii.getLager():"")+ "\n";
			} else if(tii.isMischung()) {
				ret +=  rz.getLocale().getString("tankinhaltsliste.mischung") + tii.getLosnummer() + " :"+tii.getBezeichnung()  + ((tii.getLager() != null && !tii.getLager().equals(""))?" "+rz.getLocale().getString("tankbelegungdrucken.lager")+ tii.getLager():"") +"\n"; 
			} else {
				ret += tii.getBezeichnung() + " (" + 
					rz.getLocale().formatNumber(tii.getRestliter(),OptionFactory.NF_ONE) + " " +rz.getLocale().getString("string_liter") +
					" :" + tii.getLosnummer() + ")" +(lager?" "+rz.getLocale().getString("tankbelegungdrucken.lager")+ tii.getLager():"")+"\n";
			}
		}
		if(ret.endsWith("\n"))ret = ret.substring(0, ret.length()-1);
		return ret;
	}
	
	public String getInhaltBezeichnung() {
		String ret = "";
		for(tankInhaltsItem tii:this) {
			if(tii.isMischung()) {
				ret += tii.getLosnummer() + ": " + tii.getBezeichnung() + "\n";
			} else {
				ret += tii.getBezeichnung() + " (" + tii.getLosnummer() + ") " +"\n";
			}
		}
		if(ret.endsWith("\n"))ret = ret.substring(0, ret.length()-1);
		return ret;
	}
	
	public String getInhaltLager() {
		String ret = "";
		for(tankInhaltsItem tii:this) {
			if(!tii.isMischung()) {
				ret += "<font color=\"" + tii.getLager_vg()+"\" bgcolor=\"" + tii.getLager_hg() +"\"> " +tii.getLager()+"</font><br>";
			} else {
				if(tii.getLager_hg() != null && tii.getLager_vg() != null &&  tii.getLager() != null ) {
					ret += "<font color=\"" + tii.getLager_vg()+"\" bgcolor=\"" + tii.getLager_hg() +"\"> " +tii.getLager()+"</font><br>";
				}
			}
		}
		if(ret.endsWith("<br>"))ret = ret.substring(0, ret.length()-4);
		return ret;
	}
	
	public HashMap<String,tankLagerItem> getTankLagerListe(){
		HashMap<String,tankLagerItem> map = new HashMap<String,tankLagerItem>(); 
		for(tankInhaltsItem tii:this) {
			if(!map.containsKey(tii.getLager())) {
				map.put(tii.getLager(), new tankLagerItem(tii.getLager(),tii.getLager_hg(),tii.getLager_vg()));
			}
		}
		return map;
	}
	
	public String getInhaltBezeichnungMischungsNummer() {
		String ret = "";
		for(tankInhaltsItem tii:this) {
			if(tii.isMischung()) {
				ret += tii.getLosnummer() + "\n";
			}
		}
		if(ret.endsWith("\n"))ret = ret.substring(0, ret.length()-1);
		return ret;
	}
	
	public String getIDs() {
		String ret = "";
		for(tankInhaltsItem tii:this) {
			ret += String.valueOf(tii.getRezeptur_id()) + ",";
		}
		if(ret.endsWith(","))ret = ret.substring(0, ret.length()-1);
		return ret;
	}
	
}
