/*
 * Created on 04.10.2004
 *
 */
package de.lunqual.rzpro.items.tafel;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class TafelItem {

    public static final int 	RECHNEN_PROZENTVOL		= 1;
    public static final int 	RECHNEN_PROZENTMAS		= 2;
    public static final int	RECHNEN_TEMP					= 3;
    public static final int 	RECHNEN_LITER					= 4;
    public static final int 	RECHNEN_KG						= 5;
    public static final int	RECHNEN_LA						= 6;

    RzPro			rz;
    double			prozentVol;
    double			liter;
    double			kg;
    double			la;
    double			prozentMas;
    double			temp;
    double			tafel2;
    double			tafel3;
    double			tafel6;
    double			litergewicht;
    double 		volumen;
    double			liter20;

    public TafelItem(RzPro rz,double staerke,double liter) {
        this.rz=rz;
        this.prozentVol=staerke;
        this.liter=liter;
        this.temp =20;
        this.liter20=liter;
        rechnen(RECHNEN_PROZENTVOL);
    }

    public double getKg() {
        return kg;
    }
    public void setKg(double kg) {
        this.kg = kg;
    }
    public double getLa() {
        return la;
    }
    public void setLa(double la) {
        this.la = la;
    }
    public double getLiter() {
        return liter;
    }
    public void setLiter(double liter) {
        this.liter = liter;
    }
    public double getProzentMas() {
        return prozentMas;
    }
    public void setProzentMas(double prozentMas) {
        this.prozentMas = prozentMas;
    }
    public double getProzentVol() {
        return prozentVol;
    }
    public void setProzentVol(double prozentVol) {
        this.prozentVol = prozentVol;
    }

    public double getLitergewicht() {
        return litergewicht;
    }
    public void setLitergewicht(double litergewicht) {
        this.litergewicht = litergewicht;
    }
    public double getTafel2() {
        return tafel2;
    }
    public void setTafel2(double tafel2) {
        this.tafel2 = tafel2;
    }
    public double getTafel3() {
        return tafel3;
    }
    public void setTafel3(double tafel3) {
        this.tafel3 = tafel3;
    }
    public double getTafel6() {
        return tafel6;
    }
    public void setTafel6(double tafel6) {
        this.tafel6 = tafel6;
    }
    public double getTemp() {
        return temp;
    }
    public void setTemp(double temp) {
        this.temp = temp;
    }

    public double getLiter20() {
        return liter20;
    }
    public void setLiter20(double liter20) {
        this.liter20 = liter20;
    }
    public double getVolumen() {
        return volumen;
    }
    public void setVolumen(double volumen) {
        this.volumen = volumen;
    }
    public void rechnen(int mode) {
        switch(mode) {
        	case RECHNEN_PROZENTVOL:
                prozentMas = rz.getTafelFactory().VolProz2MasProz(prozentVol);
        		break;
        	case RECHNEN_PROZENTMAS:
        	    prozentVol = rz.getTafelFactory().MasProz2VolProz(prozentMas);
        	    break;
        	 default:
                 prozentMas = rz.getTafelFactory().VolProz2MasProz(prozentVol);
        	     break;
        }
        tafel2 = rz.getTafelFactory().Tafel2Tafel(prozentVol);
        tafel3= rz.getTafelFactory().Tafel3Tafel(prozentVol,temp);
        tafel6 = rz.getTafelFactory().Dichte(prozentVol, temp);
        litergewicht = rz.getTafelFactory().LitergewichtTafel(prozentVol,temp);
        volumen = 1/litergewicht;
        switch(mode) {
	    	case RECHNEN_KG:
	    	    liter = kg * (1/litergewicht);
	    	    break;
	    	case RECHNEN_LA :
	    	    if(!rz.isZero(la)) {
	    	        liter20 = (la * 100)/prozentVol;
	    	        liter = liter20 * (  1/( (rz.getTafelFactory().Tafel3Tafel(prozentVol,temp) / 1000) * (100 / prozentVol)));
	    	    } else {
	    	        la = 0;
	    	    }
	    	    break;
		    default :
        }
	    kg = liter * litergewicht;
        if(mode != RECHNEN_LA) {
            if(Math.abs(temp-20) < 0.1) {
                liter20 = liter;
            } else {
                liter20= liter * (rz.getTafelFactory().Tafel3Tafel(prozentVol,temp) / 1000) * (100 / prozentVol);
            }
        }
        if(!rz.isZero(prozentVol)){
	        //la = liter20 * (prozentVol/100);
	        la = liter * (tafel3/1000);
	    } else {
	        la = 0;
	    }
    }
}
