/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.stichworte;
//eigene Pakete


import java.io.Serializable;
//java-pakete
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
/**
 *
 * @author  administrator
 *
 */
public class StichwortListe extends ArrayList implements Serializable{

    private final Collator        		coll;
    private final Comparator      	compInt;
    private final Comparator      	compString;

    /** Creates a new instance of StichwortListe */
    public StichwortListe() {
        super();
        coll = Collator.getInstance(Locale.getDefault());
        compInt = new Comparator(){
            public int compare(Object o1,Object o2){
                return (((StichwortItem)o1).getID() - ((StichwortItem)o2).getID()  );
            }
        };
        compString = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((StichwortItem)o1).getName();
                final String s2 = ((StichwortItem)o2).getName();
                return coll.compare(s1,s2);
            }
        };
    }



    /*---------------------------------------------------------
     * die Liste aufsteigend nach ID sortieren
     *---------------------------------------------------------
     */
    public void sortItems(){
        Collections.sort(this,compInt);
    }

    /*---------------------------------------------------------
     * die Liste aufsteigend nach Namen sortieren
     *---------------------------------------------------------
     */
    public void sortItemsAlpha(){
        Collections.sort(this,compString);
    }

    /*---------------------------------------------------------
     * den Index zu einem Item finden
     *---------------------------------------------------------
     */
    private int getItemIndex(StichwortItem stw){
        for(int i = 0;i < this.size();i++){
            if (((StichwortItem)get(i)).getID() == stw.getID() ){
                return i;
            }
        }
        return -1;
    }
    private int getItemIndex(int aKey){
        for(int i = 0;i < this.size();i++){
            if (((StichwortItem)get(i)).getID() == aKey ){
                return i;
            }
        }
        return -1;
    }
    /*---------------------------------------------------------
     * testen ob ein Item vorhanden ist
     *---------------------------------------------------------
     */
    public boolean isInList(int aKey){
        for(int i = 0; i < this.size();i++){
            if (aKey == ((StichwortItem)this.get(i)).getID()) {
            	return true;
            }
        }
        return false;
    }
    /*---------------------------------------------------------
     * ein Item hinzufügen
     *---------------------------------------------------------
     */
    public void addItem(StichwortItem i){
        this.add(i);
        sortItemsAlpha();
    }
    /*---------------------------------------------------------
     * ein Item entfernen
     *---------------------------------------------------------
     */
    public void removeItem(StichwortItem stw){
        final int i = getItemIndex(stw);
        if (i != -1){
            this.remove(i);
            sortItemsAlpha();
        }
    }
    public void removeItem(int aKey){
        final int i = getItemIndex(aKey);
        if (i != -1){
            this.remove(i);
            sortItemsAlpha();
        }
    }
    /*---------------------------------------------------------
     * liste kopieren
     *---------------------------------------------------------
     */
    public StichwortListe copyList(){
        final StichwortListe ret = new StichwortListe();
        for(int i = 0;i < this.size();i++) {
			ret.addItem((StichwortItem)this.get(i));
		}
        return ret;
    }

    /**
     * toSQLAndString() liefert den suchstring f�r eine UND-Verkn�pfung der
     * Stichworte,
     * z.B. "<1>.*<29>.*<132>"
     */
    public String toSQLAndString(){
        String ret = "";
        sortItems();
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "<" + ((StichwortItem)get(i)).getID() + ">.*";
            }
        }
        sortItemsAlpha();
        return ret.replaceAll("\\.\\*$","");
    }
    /**
     * toVerboseString() liefert alle Stichworte in einem String, durch
     * Kommata getrennt
     */
    public String toVerboseString(){
        sortItemsAlpha();
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += ((StichwortItem)get(i)).getName() + ", ";
            }
        }
        return ret.replaceAll(",.$","");
    }
    /**
     * toVerboseString() liefert alle Stichworte in einem String, durch
     * Kommata getrennt mit Anfang-Ende-Regex
     */
    public String toVerboseSearchString(){
        sortItemsAlpha();
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "^" + ((StichwortItem)get(i)).getName() + "$|";
            }
        }
        if(ret.endsWith("|")) {
        	ret = ret.substring(0,ret.length()-1);
        }
        return ret.replaceAll(",.$","");
    }

    
    /**
     * toHTMLStarString() liefert jedes Stichwort als farbfläche, durch
     * Kommata getrennt, mit den zugeordneten HTML-Farben
     */
    public String toHTMLBarString(){
        sortItemsAlpha();
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
            	if(!((StichwortItem)get(i)).getHg().equals("ffffff")) {
            		ret += "&nbsp;<span style=\"background-color:#" +  ((StichwortItem)get(i)).getHg()+"; \">"  + "&nbsp;&nbsp;&nbsp;"+ "</span>";
            	}
            }
        }
        return ret.replaceAll(",.$","");
    }

    /**
     * toHTMLString() liefert alle Stichworte in einem String, durch
     * Kommata getrennt, mit den zugeordneten HTML-Farben
     */
    public String toHTMLString(){
        sortItemsAlpha();
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "<span style=\"color:#"   +  ((StichwortItem)get(i)).getVg()  +";background-color:#" +  ((StichwortItem)get(i)).getHg() +"; \">" ;
                ret += ((StichwortItem)get(i)).getName() + "</span>, ";
            }
        }
        return ret.replaceAll(",.$","");
    }

    /**
     * toHTMLShortString() liefert alle Stichworte in einem String, durch
     * Kommata getrennt, mit den zugeordneten HTML-Farben, aber nur einen
     * Anfangsbuchstaben je Eintrag
     */
    public String toHTMLShortString(int len){
        sortItemsAlpha();
        String str="";
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
            	try {
            		str= ((StichwortItem)get(i)).getName().substring(0,len);
            	}catch (final Exception e) {
            		try {
            			str= ((StichwortItem)get(i)).getName().substring(0,1);
            		} catch (java.lang.StringIndexOutOfBoundsException s) {
            			str="";
            		}
            	}
                ret += "<span style=\"color:#"   +  ((StichwortItem)get(i)).getVg()  +";background-color:#" +  ((StichwortItem)get(i)).getHg() +"; \">" ;
                ret +=  str + "</span>";
            }
        }
        return ret.replaceAll(",.$","");
    }

    /**
     * toVerboseString() liefert alle Stichworte in einem String, durch
     * Kommata getrennt, aufbereitet als Suchpattern
     */
    public String toVerbosePatternString(){
        sortItemsAlpha();
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "^" + ((StichwortItem)get(i)).getName() + "$|";
            }
        }
        if(ret.endsWith("|")) {
			ret = ret.substring(0,ret.length()-1);
		}
        return ret.replaceAll("\\s+",".*");
    }
    /**
     * toSQLAndString() liefert den suchstring f�r eine ODER-Verkn�pfung der
     * Stichworte,
     * z.B. "(<1>|<29>|<132>)"
     */
    public String toSQLOrString(){
        String ret = "(";
        sortItems();
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "<" + ((StichwortItem)get(i)).getID() + ">|";
            }
        }
        sortItemsAlpha();
        return ret.replaceAll("\\|$","") + ")";
    }

    /**
     * toString() liefert den String, der in die Datenbank geschrieben wird
     * z.B. "<1><29><132>"
     */
    @Override
	public String toString(){
        String ret = "";
        sortItems();
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "<" + ((StichwortItem)get(i)).getID() + ">";
            }
        }
        sortItemsAlpha();
        return ret;
    }

}
