/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.rezeptur;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  administrator
 */
public class RezepturItem implements Serializable{

	RzPro           rz;

	int             	id;
	int 				typ;
	String          	titel;
	int				verweis;
	String          	comment;   // der sichtbare text
	String          	comment_1; // raw-Text
	StichwortListe  adressen;
	StichwortListe stichworte;
	DeklarationsListe deklarationen;
	DeklarationsListe deklarationenAlle;
	double          	staerke;
	boolean         extraktfrei;
	double          extrakt;
	double          litergewicht;
	int             	basiseinheit;
	double          basismenge;
	double          bestand;
	double          meldebestand;
	double		vorschlagsbestand;
	int             	bestandseinheit;
	String          	artikelnummer;
	String          	losnummer;
	BigDecimal    preis;
	double          preismenge;
	int             	preiseinheit;
	int            	waehrung;
	int             	lager;
	double          schwundsatz;
	Date            	erstellt;
	Date            	geaendert;
	String          	user_1;
	String          	user_2;
	String			hinweis;
	String		    hinweis_user;
	Date				hinweis_datum;
	double			brennwert_af;
	double 			brennwert;
	double			acid;
	String				tank;
	String				spezifikation;
	boolean		r_probe;
	int				tempVon;
	int				tempBis;
	Date				konformDatum;
	String			konformComment;
	boolean		konform;
	String			spezifikation_text;
	boolean 		bewertung;
	String			ean;
	String		steuerArtikel;
	int			sorte;
	int			steuerLager;
	boolean		auto_anfrage;
	int			proben_anzahl;
	
	/** Creates a new instance of notizItem */
	public RezepturItem(
			RzPro           r,
			int             aId,
			int			 aTyp,
			String          aTitel,
			int			  aVerweis,
			String          aComment,
			StichwortListe  aAdressListe,
			StichwortListe  aStichwortListe,
			DeklarationsListe aDeklarationen,
			DeklarationsListe aDeklarationenAlle,
			double          aStaerke,
			boolean         aExtraktfrei,
			double          aExtrakt,
			double          aLitergewicht,
			int             aBasiseinheit,
			double          aBasismenge,
			double          aBestand,
			double          aMeldebestand,
			double		  aVorschlagsbestand,
			int             aBestandseinheit,
			String          aArtikelnummer,
			String          aLosnummer,
			BigDecimal      aPreis,
			double          aPreismenge,
			int             aPreiseinheit,
			int             aWaehrung,
			int             aLager,
			double          aSchwundsatz,
			Date            aErstellt,
			Date            aGeaendert,
			String          aUser_1,
			String          aUser_2,
			String		   aHinweis,
			String			aHinweis_user,
			Date		   aHinweis_datum,
			double		aBrennwert,
			double		aBrennwert_af,
			double 		acid,
			String 		tank,
			String 		spezifikation,
			boolean 	r_probe,
			int			tempVon,
			int			tempBis,
			Date			konformDatum,
			String		konformComment,
			boolean konform,
			String		spezifikation_text,
			boolean 	bewertung,
			String		ean,
			String		steuerArtikel,
			int			sorte,
			int			steuerLager,
			boolean		auto_anfrage,
			int 		proben_anzahl
		
			
	) {
		rz = r;
		id = aId;
		typ=aTyp;
		titel = aTitel;
		verweis = aVerweis;
		comment_1 = aComment;
		adressen = aAdressListe;
		stichworte = aStichwortListe;
		deklarationen = aDeklarationen;
		deklarationenAlle = aDeklarationenAlle;
		staerke = aStaerke;
		extraktfrei = aExtraktfrei;
		extrakt = aExtrakt;
		litergewicht = aLitergewicht;
		basismenge = aBasismenge;
		basiseinheit = aBasiseinheit;
		bestand = aBestand;
		meldebestand = aMeldebestand;
		vorschlagsbestand=aVorschlagsbestand;
		bestandseinheit = aBestandseinheit;
		artikelnummer = aArtikelnummer;
		losnummer = aLosnummer;
		preis = aPreis;
		preismenge = aPreismenge;
		preiseinheit = aPreiseinheit;
		waehrung = aWaehrung;
		lager = aLager;
		schwundsatz = aSchwundsatz;
		erstellt = aErstellt;
		geaendert = aGeaendert;
		user_1 = aUser_1;
		user_2 = aUser_2;
		hinweis = aHinweis;
		hinweis_user = aHinweis_user;
		hinweis_datum = aHinweis_datum;
		brennwert_af = aBrennwert_af;
		brennwert = aBrennwert;
		this.acid=acid;
		this.tank=tank;
		this.spezifikation=spezifikation;
		this.r_probe=r_probe;
		this.tempVon=tempVon;
		this.tempBis=tempBis;
		this.konformDatum=konformDatum;
		this.konformComment=konformComment;
		this.konform=konform;
		this.spezifikation_text = spezifikation_text;
		this.bewertung = bewertung;
		this.ean = ean;
		this.steuerArtikel = steuerArtikel;
		this.sorte = sorte;
		this.steuerLager = steuerLager;
		this.auto_anfrage =auto_anfrage;
		this.proben_anzahl = proben_anzahl;
		preis = preis.setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);

		comment = rawToComment(comment_1);
	}
	
	
	public boolean isAuto_anfrage() {
		return auto_anfrage;
	}


	public void setAuto_anfrage(boolean auto_anfrage) {
		this.auto_anfrage = auto_anfrage;
	}


	public String getEan() {
		return ean;
	}


	public void setEan(String ean) {
		this.ean = ean;
	}


	public boolean isBewertung() {
		return bewertung;
	}

	public void setBewertung(boolean bewertung) {
		this.bewertung = bewertung;
	}

	public String getSpezifikation_text() {
		return spezifikation_text;
	}




	public void setSpezifikation_text(String spezifikation_text) {
		this.spezifikation_text = spezifikation_text;
	}




	public boolean isKonform() {
		return konform;
	}




	public void setKonform(boolean konform) {
		this.konform = konform;
	}




	public Date getKonformDatum() {
		return konformDatum;
	}




	public void setKonformDatum(Date konformDatum) {
		this.konformDatum = konformDatum;
	}




	public String getKonformComment() {
		return konformComment;
	}




	public void setKonformComment(String konformComment) {
		this.konformComment = konformComment;
	}




	public void setRProbe(boolean p) {
		this.r_probe=p;
	}
	
	public boolean isRProbe() {
		return r_probe;
	}
	
	public void setProbenAnzahl(int i ) {
		this.proben_anzahl=i;
	}
	
	public int getTemperaturDurchschnitt() {
		return (tempVon+tempBis)/2;
	}
	
	public int getTempVon() {
		return tempVon;
	}

	public void setTempVon(int tempVon) {
		this.tempVon = tempVon;
	}

	public int getTempBis() {
		return tempBis;
	}

	public void setTempBis(int tempBis) {
		this.tempBis = tempBis;
	}

	/** boolean isRechenzeile(String) prüft ob die vorliegende Zeile eine
	 * Rechen/Sternzeile ist oder nicht
	 * Es wird _nicht_ geprüft, ob eine angegebene Zutat in der
	 * Datenbank existiert !!!
	 */
	public boolean isRechenzeile(String aString){
		boolean ret = false;
		if (!aString.equals("")){
			final String tokens[] = aString.split(" ");
			switch (tokens.length){
				case 0:
				case 1:
				case 2: // Zeilen mit 0,1 oder 2 Elementen können keine
					// Rechenzeilen sein...
					ret = false;
					break;
				default:// Zeilen mit 3 oder mehr Elementen _können_
					// Rechenzeilen sein
					if(rz.getLocale().isNumber(tokens[0].trim())){
						if(rz.getDatabase().getEinheiten().isEinheit(tokens[1].trim())){
							ret = true;
						}
					}
			}
		}
		return ret;
	}

	/** raw-comment in sichtbaren umwandeln..
	 */
	public String rawToComment(String aRaw){
		String ret = "";
		String zeilen[] = {};
		String items[] = {};
		String menge;
		int einheit = 0;
		int dbKey = 0;
		int i;
		String exString = "";
		if(!aRaw.trim().equals("")){
			zeilen = aRaw.split("\\n");
			for(i = 0;i < zeilen.length;i++){
				items = zeilen[i].split(" ");
				exString = "";
				if (items[0].equals(RzPro.TYP_COMMENT)){
					try{
						ret += zeilen[i].substring(2) + "\n";
					}catch (final IndexOutOfBoundsException e){
						ret += "\n";
					}
				}
				else {
					try {
						menge = (items[1].equals("*")) ? "*" : rz.getLocale().formatNumber(items[1],OptionFactory.NF_NORMAL);
						einheit = Integer.parseInt(items[2]);
						dbKey = Integer.parseInt(items[3].substring(2,items[3].indexOf("]]")));
						try {
							dbKey = Integer.parseInt(items[4].substring(2,items[4].indexOf("]]")));
							exString = " [[" + dbKey + "]]";
						}
						catch (final IndexOutOfBoundsException e){}
						try {
							ret += menge + " " + rz.getDatabase().getEinheiten().getEinheit(String.valueOf(einheit)).getName() + " " + rz.getDatabase().getRezeptur().dbGetRezepturName(dbKey) + exString + "\n";
						} catch(final ItemNotFoundException e1) {}
					} catch(Exception e) {}
				}
			}
		}
		if (ret.equals("\n")) {
			ret = "";
		}
		return ret;
	}
	/** sichtbaren comment in Raw umwandeln
	 * gibt den String zurück, der in die Datenbank gesichert wird
	 * raw = Datenbankfeld-Inhalt
	 * comment = Textfeld-Inhalt
	 * @param aComment der KommentarString
	 */
	public boolean CommentToRaw(String aComment){
		String raw = "";
		String raw_2;
		String zeilen[];
		String items[];
		int dbKey;
		int i;
		int anfang,ende;
		boolean exclusive;
		zeilen = aComment.split("\n");
		for (i=0;i < zeilen.length;i++){
			//Zeile für zeile die Art der zeile identifizieren
			if(isRechenzeile(zeilen[i].trim())){
				// Rechenzeile
				zeilen[i] = zeilen[i].trim();
				raw_2 = zeilen[i].replaceAll("\\\\s+", " ");
				raw += RzPro.TYP_CALC + " ";
				items = raw_2.trim().split(" ");
				if(rz.getLocale().isNumber(items[0].trim())){
					// doppelt hält besser !
					raw += items[0].trim() + " ";
				} else {raw += "0 ";}
				if(rz.getDatabase().getEinheiten().isEinheit(items[1].trim())){
					raw += rz.getDatabase().getEinheiten().getEinheit(items[1].trim()).getID() + " ";
				}else {raw += "0 ";}
				ende = -1;
				anfang = zeilen[i].indexOf(items[2]);
				try {
					ende = zeilen[i].substring(anfang).indexOf("[[");
				}catch (final Exception e){}
				if(ende != -1){
					dbKey = Integer.parseInt(zeilen[i].substring(anfang+ende+2,zeilen[i].indexOf("]]",anfang+ende)));
					exclusive = false;
				}
				else {
					dbKey = rz.getDatabase().getRezeptur().dbGetRezepturID(zeilen[i].substring(anfang,zeilen[i].length()).trim());
					exclusive = true;
				}
				if (dbKey != 0){
					raw += "[[" + String.valueOf(dbKey) + "]] ";
					if (!exclusive) {
						raw += "[[" + dbKey + "]] ";
					}
				}
				else{
					raw =rz.getLocale().getString("rezepturitem.not_found").replaceAll("%s",  zeilen[i].substring(anfang,zeilen[i].length()));
					//raw += "[[1]]\n0 >>"+zeilen[i].substring(anfang,zeilen[i].length()) + "<<";
					final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
					dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
					dlgItem.setCaption(rz.getLocale().getString("rezepturitem.save"));
					dlgItem.setTitel(rz.getLocale().getString("rezepturitem.save"));
					dlgItem.setMessage(raw);
					dlgItem.setIcon("warnung.png");
					dlgItem.setOk(rz.getLocale().getString("string_ok"));
					rz.getDialogFactory().getDialog(dlgItem);
					return false;
				}
				raw += "\n";
			}
			else {
				// Kommentar
				raw += RzPro.TYP_COMMENT + " " + zeilen[i].trim() + "\n";
			}
		}
		comment_1 = raw;
		if(comment_1.equals("\n")) {
			comment_1 = "";
		}
		return true;
	}

	//get....
	public StichwortListe getStichwortListe(){return stichworte;}
	public StichwortListe getAdressListe(){return adressen;}
	public DeklarationsListe getDeklarationenListe(){return deklarationen;}
	public int getID(){return id;}
	public String getTitel(){return titel;}
	public String getComment(){return comment;}
	public String getRaw() {
		return comment_1;
	}
	public void setRaw(String r) {
		comment_1 = r;
	}
	public double getStaerke(){return staerke;}
	public boolean getExtraktfrei(){return extraktfrei;}
	public double getExtrakt(){return extrakt;}
	public double getLitergewicht(){
		return (extraktfrei) ? rz.getTafelFactory().Litergewicht(staerke)  : litergewicht;
	}
	public double getLitergewicht(double aStaerke){
		return (extraktfrei) ? rz.getTafelFactory().Litergewicht(aStaerke)  : litergewicht;
	}
	public double getBasismenge(){return basismenge;}
	public int getBasiseinheit(){return basiseinheit;}
	public double getBestand(){return bestand;}
	public double getMeldebestand(){return meldebestand;}
	public int    getBestandseinheit(){return bestandseinheit;}
	public String getArtikelnummer(){return artikelnummer;}
	public String getLosnummer(){return losnummer;}
	public int    getWaehrung(){return waehrung;}
	public BigDecimal getPreis(){return preis;}
	public double getPreisMenge(){return preismenge;}
	public int    getPreisEinheit() {return preiseinheit;}
	public int getLager(){return lager;}
	public double getSchwundsatz(){return schwundsatz;}
	public Date getErstellt(){return erstellt;}
	public String getErstelltToString(){
		final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
		return df.format(erstellt);
	}
	public Date getGeaendert(){return geaendert;}
	public String getGeaendertToString(){
		final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
		return df.format(geaendert);
	}
	public String getUser1(){return user_1;}
	public String getUser2(){return user_2;}


	//set....
	public void setID(int aID){id = aID;}
	public void setTitel(String aTitel){titel = aTitel;}
	public void setComment(String aComment){comment = aComment;}
	public void setStaerke(double aStaerke){staerke = ((aStaerke < 0) || (aStaerke > 100)) ? 0 : aStaerke;}
	public void setLitergewicht(double aLitergewicht){litergewicht = aLitergewicht;}
	public void setExtraktfrei(boolean aExtraktfrei){extraktfrei = aExtraktfrei;}
	public void setExtrakt(double aExtrakt){extrakt = aExtrakt;}
	public void setBasismenge(double aBasismenge){basismenge = aBasismenge;}
	public void setBasiseinheit(int aBasiseinheit){basiseinheit = aBasiseinheit;}
	public void setBestand(double aBestand){bestand = aBestand;}
	public void setMeldebestand(double aMeldebestand){meldebestand = aMeldebestand;}
	public void setBestandseinheit(int aBestandseinheit){bestandseinheit = aBestandseinheit;}
	public void setArtikelnummer(String aArtikelnummer){artikelnummer = aArtikelnummer;}
	public void setLosnummer(String aLosnummer){losnummer = aLosnummer;}
	public void setWaehrung(int aWaehrung){waehrung = aWaehrung;}
	public void setPreis(String aPreis){
		double n;
		try {
			final NumberFormat nf = rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL);
			n = (nf.parse(aPreis)).doubleValue();
		} catch (final ParseException e) {n=0;}
		preis = new BigDecimal( n).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
	}
	public void setPreis(BigDecimal aPreis){preis = aPreis;}
	public void setPreisMenge(double aPreismenge){preismenge = aPreismenge;}
	public void setPreisEinheit(int aPreiseinheit){preiseinheit = aPreiseinheit;}
	public void setAdressListe(StichwortListe sl){adressen = sl;}
	public void setStichwortListe(StichwortListe sl){ stichworte = sl; }
	public void setDeklarationenListe(DeklarationsListe sl) {deklarationen=sl;}
	public void setLager(int aLager){lager = aLager;}
	public void setSchwundsatz(double aSchwundsatz){schwundsatz = aSchwundsatz;}
	public void setBrennwert(double aBrennwert) {brennwert = aBrennwert;}
	public void setBrennwertAF(double aBrennwert_af) {brennwert_af = aBrennwert_af;}

	/**
	 * @return Returns the verweis.
	 */
	public int getVerweis() {
		return verweis;
	}
	/**
	 * @param verweis The verweis to set.
	 */
	public void setVerweis(int verweis) {
		this.verweis = verweis;
	}
	/**
	 * @param erstellt The erstellt to set.
	 */
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	/**
	 * @param geaendert The geaendert to set.
	 */
	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}
	/**
	 * @param user_1 The user_1 to set.
	 */
	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}
	/**
	 * @param user_2 The user_2 to set.
	 */
	public void setUser_2(String user_2) {
		this.user_2 = user_2;
	}

	public String getHinweis() {
		return hinweis;
	}
	public void setHinweis(String hinweis) {
		this.hinweis = hinweis;
	}
	public Date getHinweis_datum() {
		return hinweis_datum;
	}
	public void setHinweis_datum(Date hinweis_datum) {
		this.hinweis_datum = hinweis_datum;
	}
	public String getHinweis_user() {
		return hinweis_user;
	}
	public void setHinweis_user(String hinweis_user) {
		this.hinweis_user = hinweis_user;
	}

	public double getBrennwert() {
		return brennwert;
	}
	public double getBrennwertAF() {
		return brennwert_af;
	}

	@Override
	public String toString() {
		return titel;
	}
	public int getTyp() {
		return typ;
	}

	public double getAlkoholGramm() {
		double ret = 0.0;
		if(staerke != 0) {
			final double literPerKg = 1/ this.getLitergewicht();
			final double menge = literPerKg * (staerke/100);
			ret = menge * rz.getTafelFactory().Litergewicht(100) * 1000;
		} else {
			ret = 0.0;
		}
		return ret;
	}

	public void setAcid(double acid) {
		this.acid=acid;
	}

	public double getAcid() {
		return acid;
	}
	public DeklarationsListe getDeklarationenAlle() {
		return deklarationenAlle;
	}
	public void setDeklarationenAlle(DeklarationsListe deklarationenAlle) {
		this.deklarationenAlle = deklarationenAlle;
	}
	public double getVorschlagsbestand() {
		return vorschlagsbestand;
	}
	public void setVorschlagsbestand(double vorschlagsbestand) {
		this.vorschlagsbestand = vorschlagsbestand;
	}
	public String getTank() {
		return tank;
	}
	
	public String getTTTHtml() {
		String ret = "";
    	String nummern[] = tank.split("\\s|,|;|:|-");
    	for(String n:nummern) {
    		try {
    			if(rz.getDatabase().getTank().tankExists(n)) {
    				ret +="<a href=\"ttt:" +  n + "\">" + n + "</a>&nbsp;&nbsp;";
    			} else {
    				ret += " " + n + " ";
    			}
    		}catch(Exception e) {}
    	}
		return ret;
	}
	public void setTank(String tank) {
		this.tank = tank;
	}
	public String getSpezifikation() {
		return spezifikation;
	}
	public void setSpezifikation(String spezifikation) {
		this.spezifikation = spezifikation;
	}


	public String getSteuerArtikel() {
		return steuerArtikel;
	}


	public void setSteuerArtikel(String steuerArtikel) {
		this.steuerArtikel = steuerArtikel;
	}


	public int getSorte() {
		return sorte;
	}


	public void setSorte(int sorte) {
		this.sorte = sorte;
	}


	public int getSteuerLager() {
		return steuerLager;
	}


	public void setSteuerLager(int steuerLager) {
		this.steuerLager = steuerLager;
	}

	public int getProbenAnzahl() {
		return proben_anzahl;
	}
}