package de.lunqual.rzpro.items.rezeptur;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.stichworte.StichwortListe;

public class RezepturHeaderItem implements Serializable{
    int             id;
    String          titel;
    Date            erstellt;
    Date            geaendert;
    String          user_1;
    String          user_2;
    double			staerke;
    String			artikelnummer;

    StichwortListe  adressListe;
    StichwortListe  stichwortListe;

    public RezepturHeaderItem(int aId, String aTitel,Date aErstellt,Date aGeaendert,String aUser_1,String aUser_2,double staerke,String artikelnummer) {
        id = aId;
        titel = aTitel;
        erstellt = aErstellt;
        geaendert = aGeaendert;
        user_1 = aUser_1;
        user_2 = aUser_2;
        this.staerke = staerke;
        this.artikelnummer=artikelnummer;
    }
    
    public double getStaerke() {
		return staerke;
	}
    public String getArtikelnummer() {
    	return artikelnummer;
    }
	public int getID(){return id;}
    public String getTitel(){return titel;}
    public Date getErstellt(){return erstellt;}
    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public Date getGeaendert(){return geaendert;}
    public String getGeaendertToString(){
    	final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
    	return df.format(geaendert);
    }
    public String getUser1() {
    	return user_1;
    }
    public String getUser2() {
    	return user_2;
    }
    
}
