package de.lunqual.rzpro.items.rezeptur;

import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.stichworte.StichwortListe;

public class ChangesItem {
	
	RzPro			rz;
	int				id;
	int				rezeptur_id;
	String			bezeichnung;
	String			alt;
	String			neu;
	Date				erstellt;
	String			user;
	String			rezeptur;
	StichwortListe stw;
	boolean		relevant;
	
	public ChangesItem(RzPro rz,int id, int rezeptur_id, String bezeichnung, String alt,	String neu, Date erstellt, String user,boolean relevant) {
		super();
		this.rz = rz;
		this.id = id;
		this.rezeptur_id = rezeptur_id;
		this.bezeichnung = bezeichnung;
		this.alt = alt;
		this.neu = neu;
		this.erstellt = erstellt;
		this.user = user;
		this.rezeptur=null;
		this.relevant=relevant;
		stw=new StichwortListe();
	}
	
	public ChangesItem(RzPro rz,int id, int rezeptur_id, String bezeichnung, String alt,	String neu, Date erstellt, String user,String rezeptur,StichwortListe stichworte,boolean relevant) {
		super();
		this.rz = rz;
		this.id = id;
		this.rezeptur_id = rezeptur_id;
		this.bezeichnung = bezeichnung;
		this.alt = alt;
		this.neu = neu;
		this.erstellt = erstellt;
		this.user = user;
		this.rezeptur=rezeptur;
		this.stw=stichworte;
		this.relevant=relevant;
	}
	
	
	/**
	 * @return the relevant
	 */
	public boolean isRelevant() {
		return relevant;
	}

	public StichwortListe getStichworte() {
		return stw;
	}
	
	public String getRezeptur() {
		return rezeptur;
	}
	
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public int getRezeptur_id() {
		return rezeptur_id;
	}
	public void setRezeptur_id(int rezeptur_id) {
		this.rezeptur_id = rezeptur_id;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public String getAlt() {
		return alt;
	}
	public void setAlt(String alt) {
		this.alt = alt;
	}
	public String getNeu() {
		return neu;
	}
	public void setNeu(String neu) {
		this.neu = neu;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public String getUser() {
		return user;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public String getNeuHTML() {
		String ret = "";
		if(neu.codePoints().filter(ch -> ch =='\n').count()>0)
		{
			ret = getMarkupNeu();
			ret = ret.replaceAll("\\n", "<br>") + "<br>&nbsp;";
		} else {
			ret = neu.replaceAll("\\n", "<br>");
		}
		return ret;
	}
	
	public String getAltHTML() {
		String ret = "";
		if(alt.codePoints().filter(ch -> ch =='\n').count()>0)
		{
			ret = getMarkupAlt();
			ret = ret.replaceAll("\\n", "<br>") + "<br>&nbsp;";
		} else {
			ret = alt.replaceAll("\\n", "<br>");
		}
		return ret;
	}

	private String getMarkupAlt() {
		String textColor = rz.getOptionFactory().getOption("changes.markup.alt.color_text");
		String backgroundColor = rz.getOptionFactory().getOption("changes.markup.alt.color_background");
		String[] alteStrings = alt.split("\\n");
		String[] neuStrings = neu.split("\\n");
		String ret = "";
		for(String zeile:alteStrings) {
			boolean mark=true;
			if(!zeile.trim().isEmpty()) {
				for(String neueZeile:neuStrings) {
					if(zeile.trim().equals(neueZeile.trim())) {
						mark = false;
						break;
					}
				}
				if(mark) {
					ret += "</font><div style=\"color:" + textColor +";background-color:"+backgroundColor +"\">" + zeile + "</div>" + "<font color=\"red\">" +"\n";
				} else {
					ret += zeile + "\n";
				}
			}
		}
		return ret;
	}
	private String getMarkupNeu() {
		String textColor = rz.getOptionFactory().getOption("changes.markup.color_text");
		String backgroundColor = rz.getOptionFactory().getOption("changes.markup.color_background");
		String[] alteStrings = alt.split("\\n");
		String[] neuStrings = neu.split("\\n");
		String ret = "";
		for(String zeile:neuStrings) {
			boolean mark=true;
			if(!zeile.trim().isEmpty()) {
				for(String alteZeile:alteStrings) {
					if(zeile.trim().equals(alteZeile.trim())) {
						mark = false;
						break;
					}
				}
				if(mark) {
					ret += "</font><div style=\"color:" + textColor +";background-color:"+backgroundColor +"\">" + zeile + "</div>" + "<font color=\"green\">" +  "\n";
				} else {
					ret += zeile + "\n";
				}
			}
		}
		return ret;
	}
	
}
