/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.rezeptur;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rechnen.RechenItem;

public class BestandswarnungsItem {
	RzPro		rz;
	int			id;
	int			rezeptur;
	double	staerke;
	int			einheit;
	double 	diff;
	String 		bezeichnung;
	String 		strEinheit;
	boolean	bestellt;
	boolean  leer;
	ArrayList  zutatenListe;
	boolean checkBestand;
	int			letzteBuchung;
	
	
	public BestandswarnungsItem(RzPro rz,int rezeptur,double staerke,int einheit,String strEinheit,double diff,String bezeichnung,boolean leer,boolean checkBestand,int id) {
		this.rz=rz;
		this.rezeptur=rezeptur;
		this.staerke=staerke;
		this.einheit=einheit;
		this.diff=diff;
		this.leer = leer;
		this.strEinheit=strEinheit;
		this.bezeichnung=bezeichnung;
		this.bestellt=false;
		this.checkBestand=checkBestand;
		double r = 0.0;
		this.zutatenListe=new ArrayList();
		this.letzteBuchung=Integer.MIN_VALUE;
		
		if (einheit ==RzPro.EINHEIT_LA) {
			try {
				r=(staerke == 0)?diff:(diff*100)/staerke ;
			}catch (final Exception e) {
				r =diff;
			}
		}else {
			r = diff;
		}
		this.diff=r<=0.0?0.0:r;
		if(!rz.isZero(diff) && (this.checkBestand == true)) {
			rechnen();
		}
		this.id=id;
	}

	public int getID() {
		return id;
	}
	private void rechnen() {
		if(this.rezeptur != 0) {
        	final RechenItem ri = new RechenItem(rz,rezeptur,null);
	    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
	    	ri.rechnen(this.diff,RechenItem.RECHNEN_LITER);
	    	for(int i = 0;i < ri.getZeilenListe().size();i++) {
	    		if(ri.getZeilenListe().getItem(i).isBestandWarnung()) {
	    			this.zutatenListe.add(ri.getZeilenListe().getItem(i).getBezeichnung());
	    		}
	    	}
		}
	}
	public boolean isBestellt() {
		return bestellt;
	}


	public void setBestellt(boolean bestellt) {
		this.bestellt = bestellt;
	}


	public int getRezeptur() {
		return rezeptur;
	}
	public void setRezeptur(int rezeptur) {
		this.rezeptur = rezeptur;
	}
	public int getEinheit() {
		return einheit;
	}
	public void setEinheit(int einheit) {
		this.einheit = einheit;
	}
	public double getDiff() {
		return diff;
	}
	public void setDiff(double diff) {
		this.diff = diff;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public String getStrEinheit() {
		return strEinheit;
	}
	public void setStrEinheit(String strEinheit) {
		this.strEinheit = strEinheit;
	}
	public double getStaerke() {
		return staerke;
	}
	public void setStaerke(double staerke) {
		this.staerke = staerke;
	}
 

	public boolean isLeer() {
		return leer;
	}


	public void setLeer(boolean leer) {
		this.leer = leer;
	}


	public ArrayList getZutatenListe() {
		return zutatenListe;
	}


	public void setZutatenListe(ArrayList zutatenListe) {
		this.zutatenListe = zutatenListe;
	}

	public String getLetzteBuchung() {
		if(letzteBuchung >= rz.getOptionFactory().getOption("bestandswarnung.status_0",de.lunqual.rzpro.options.OptionFactory.BESTANDSWARNUNG_STATUS_0)) {
			return rz.getOptionFactory().getOption("bestandswarnung.status_color_0");
		} else if(letzteBuchung >= rz.getOptionFactory().getOption("bestandswarnung.status_1",de.lunqual.rzpro.options.OptionFactory.BESTANDSWARNUNG_STATUS_1)) {
			return rz.getOptionFactory().getOption("bestandswarnung.status_color_1");
		} else if(letzteBuchung >= rz.getOptionFactory().getOption("bestandswarnung.status_2",de.lunqual.rzpro.options.OptionFactory.BESTANDSWARNUNG_STATUS_2)) {
			return rz.getOptionFactory().getOption("bestandswarnung.status_color_2");
		} else {
			return rz.getOptionFactory().getOption("bestandswarnung.status_color_3");
		}
	}

	public void setLetzteBuchung(int letzteBuchung) {
		this.letzteBuchung = letzteBuchung;
	}


}
