/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.rezeptur;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  administrator
 */
public class AusstattungsItem implements Serializable {
	RzPro           		 rz;
	int            		 id;
	int			 		typ;
	String          		titel;
	String				comment;
	String          		comment_1;
	StichwortListe  	adressListe;
	StichwortListe  	stichwortListe;
	double         	gebindeGewicht;
	double         	gebindeGroesse;
	String            	artikelnummer;
	BigDecimal    	preis;
	int             		waehrung;
	boolean			liste;
	Date            		erstellt;
	Date            		geaendert;
	String          		user_1;
	String          		user_2;
	AusstattungsZeilenListe asZeilen;
	BigDecimal		gesamtPreis;
	Double				gesamtGewicht;

	Double				chargenGewicht;
	BigDecimal		chargenPreis;
	int					chargenMenge;

	/** Creates a new instance of notizItem */
	public AusstattungsItem(
			RzPro           	 	rz,
			int            		id,
			String          		titel,
			String          		comment_1,
			StichwortListe  	adressListe,
			StichwortListe  	stichwortListe,
			double         	gewicht,
			double         	gebindegroesse,
			String            	artikelnummer,
			BigDecimal    	preis,
			int             		waehrung,
			boolean			liste,
			Date             	erstellt,
			Date             	geaendert,
			String           	user_1,
			String          		user_2
	) {
		this.rz = rz;
		this.id=id;
		this.typ=RzPro.TYP_ID_AUSSTATTUNG;
		this.titel = titel;
		this.comment_1 = comment_1;
		this.comment = rawToComment(comment_1);
		this.adressListe = adressListe;
		this.stichwortListe=stichwortListe;
		this.gebindeGewicht = gewicht;
		this.gebindeGroesse = gebindegroesse;
		this.artikelnummer = artikelnummer;
		this.preis = preis;
		this.waehrung = waehrung;
		this.liste=liste;
		this.erstellt = erstellt;
		this.geaendert = geaendert;
		this.user_1 =user_1;
		this.user_2= user_2;
		asZeilen=new AusstattungsZeilenListe();
		this.preis = preis.setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
		gesamtPreis = new BigDecimal(0.0);
		chargenPreis = new BigDecimal(0.0);
	}
	/** boolean isRechenzeile(String) prüft ob die vorliegende Zeile eine
	 * Ausstattungszeile
	 */
	public boolean isAusstattungsZeile(String aString){
		boolean ret = false;
		if (!aString.equals("")){
			final String tokens[] = aString.split(" ");
			switch (tokens.length){
				case 0:
				case 1:
				case 2: // Zeilen mit 0,1,2  können keine
					// Ausstattungszeilen sein...
					ret = false;
					break;
				default:// Zeilen mit 3 oder mehr Elementen _können_
					// AusstattungsZeilen sein
					if(tokens[0].startsWith(RzPro.TYP_AUSSTATTUNG_EINFACH) || tokens[0].startsWith(RzPro.TYP_AUSSTATTUNG_MULTI)){
						ret = true;
					}
			}
		}
		return ret;
	}

	/** raw-comment in sichtbaren umwandeln..
	 */
		public String rawToComment(String aRaw){
			String ret = "";
			String zeilen[] = {};
			String items[] = {};
			String factor="1";
			int dbKey = 0;
			String exString = "";
			int i;
			if(!aRaw.trim().equals("")){
				zeilen = aRaw.split("\\n");
				for(i = 0;i < zeilen.length;i++){
					items = zeilen[i].split(" ");
					if (items[0].startsWith(RzPro.TYP_AUSSTATTUNG_EINFACH) || items[0].startsWith(RzPro.TYP_AUSSTATTUNG_MULTI)){
						dbKey = 0;
						ret += items[0] + " ";
						try {
							factor = rz.getLocale().formatNumber(items[1],OptionFactory.NF_NORMAL);
						} catch (final NumberFormatException e) {factor="1";}
						try {
							dbKey = Integer.parseInt(items[2].substring(2,items[2].indexOf("]]")));
						} catch (final IndexOutOfBoundsException e2) {}
						try {
							dbKey = Integer.parseInt(items[3].substring(2,items[3].indexOf("]]")));
							exString = " [[" + dbKey + "]]";
						}
						catch (final IndexOutOfBoundsException e){}
						try {
							ret += factor + " " ;
							if(dbKey > 0) {
								ret += rz.getDatabase().getRezeptur().dbGetRezepturName(dbKey) + " " + exString;
							}
							ret +=  "\n";
						} catch (final ItemNotFoundException e1) {}
					} else {
						ret += zeilen[i] + "\n";
					}
				}
			}
			if (ret.equals("\n")) {
				ret = "";
			}
			return ret;
	}
	/** sichtbaren comment in Raw umwandeln
	 * gibt den String zurück, der in die Datenbank gesichert wird
	 */
	public boolean CommentToRaw(){
		String raw = "";
		String zeilen[];
		String items[];
		int dbKey;
		int i;
		int anfang,ende;
		boolean exclusive;
		zeilen = comment.split("\n");
		for (i=0;i < zeilen.length;i++){
			//Zeile für zeile die Art der zeile identifizieren
			if(isAusstattungsZeile(zeilen[i].trim())){
				items=zeilen[i].split(" ");
				if(items[0].startsWith(RzPro.TYP_AUSSTATTUNG_EINFACH)) {
					raw += "+ " + items[1] + " ";
				} else if (zeilen[i].startsWith(RzPro.TYP_AUSSTATTUNG_MULTI)) {
					raw += "* " + items[1] + " ";
				}
				ende = -1;
				anfang = zeilen[i].indexOf(items[2]);
				try {
					ende = zeilen[i].substring(anfang).indexOf("[[");
				}catch (final Exception e){e.printStackTrace();}
				if(ende != -1){
					dbKey = Integer.parseInt(zeilen[i].substring(anfang+ende+2,zeilen[i].indexOf("]]",anfang+ende)));
					exclusive = false;
				}
				else {
					dbKey = rz.getDatabase().getRezeptur().dbGetRezepturID(zeilen[i].substring(anfang,zeilen[i].length()).trim());
					exclusive = true;
				}
				if (dbKey != 0){
					raw += "[[" + String.valueOf(dbKey) + "]] ";
					if (!exclusive) {
						raw += "[[" + dbKey + "]] ";
					}
				}
				else{
					raw =rz.getLocale().getString("rezepturitem.not_found").replaceAll("%s",  zeilen[i].substring(anfang,zeilen[i].length()));
					final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
					dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
					dlgItem.setCaption(rz.getLocale().getString("rezepturitem.save"));
					dlgItem.setTitel(rz.getLocale().getString("rezepturitem.save"));
					dlgItem.setMessage(raw);
					dlgItem.setIcon("warnung.png");
					dlgItem.setOk(rz.getLocale().getString("string_ok"));
					rz.getDialogFactory().getDialog(dlgItem);
					return false;
				}
				raw += "\n";
			}
			else {
				// Kommentar
				raw += zeilen[i].trim() + "\n";
			}
		}
		comment_1 = raw;
		if(comment_1.equals("\n")) {
			comment_1 = "";
		}
		return true;
	}

	/**
	 * Berechnen
	 * @return
	 */
	public BigDecimal rechnen(double liter,CurrencyItem wZiel) {
		gesamtPreis = new BigDecimal(0.0);
		chargenPreis = new BigDecimal(0.0);
		gesamtGewicht = 0.0;
		AusstattungsItem as=null;
		int mode=AusstattungsZeile.MODE_PLUS;
		int anfang,ende;
		int dbKey=0;
		double factor;
		asZeilen.clear();
		final String zeilen[] = getRaw().split("\n");
		for (final String element : zeilen) {
			if(element.indexOf("[[") != -1) {
				// was zum rechnen
				final String items[] = element.split(" ");
				if(items[0].equals(RzPro.TYP_AUSSTATTUNG_EINFACH)) {
					mode = AusstattungsZeile.MODE_PLUS;
				} else if(items[0].equals(RzPro.TYP_AUSSTATTUNG_MULTI)) {
					mode = AusstattungsZeile.MODE_MAL;
				}
				try {
					factor = rz.getLocale().getNumber(items[1],OptionFactory.NF_NORMAL);
				} catch (final NumberFormatException e) {factor=1;}
				ende = -1;
				anfang = element.indexOf(items[2]);
				try {
					ende = element.substring(anfang).indexOf("[[");
				}catch (final Exception e){}
				if(ende != -1){
					dbKey = Integer.parseInt(element.substring(anfang+ende+2,element.indexOf("]]",anfang+ende)));
				}
				else {
					dbKey = rz.getDatabase().getRezeptur().dbGetRezepturID(element.substring(anfang,element.length()).trim());
				}
				if (dbKey != 0){
					as = rz.getDatabase().getAusstattung().getAusstattung(dbKey);
					if(as != null) {
						final AusstattungsZeile az = new AusstattungsZeile(
								rz,
								mode,
								factor,
								as.getTitel(),
								as.getPreis(),
								as.getGebindeGewicht(),
								rz.getDatabase().getCurrency().dbGetCurrency(as.getWaehrung(),true),
								wZiel
						);
						asZeilen.addItem(az);
						gesamtPreis = gesamtPreis.add( az.getZeilenPreis());
						gesamtGewicht += az.getZeilenGewicht();
					}
				}
			}
		}
		if (rz.isZero(gesamtPreis.doubleValue())){
			gesamtPreis = preis;
		}
		chargenMenge = (int)(liter / gebindeGroesse);
		chargenGewicht = gesamtGewicht * chargenMenge;
		chargenPreis = gesamtPreis.multiply(new BigDecimal(chargenMenge)).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
		return gesamtPreis;
	}

	//get....
	public StichwortListe getStichwortListe(){return stichwortListe;}
	public StichwortListe getAdressListe(){return adressListe;}
	public int getID(){return id;}
	public String getTitel(){return titel;}
	public String getComment(){return comment;}
	public Double getGebindegroesse() {return this.gebindeGroesse;}
	public String getArtikelnummer() {return artikelnummer;}
	public String getRaw() {CommentToRaw();return comment_1;}

	public int    getWaehrung(){return waehrung;}
	public BigDecimal getPreis(){return preis;}
	public double getGebindeGewicht() {return gebindeGewicht;}
	public double getGesamtGewicht() {return rz.isZero(gesamtGewicht)?gebindeGewicht:gesamtGewicht;}

	public Date getErstellt(){return erstellt;}
	public String getErstelltToString(){
		final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
		return df.format(erstellt);
	}
	public Date getGeaendert(){return geaendert;}
	public String getGeaendertToString(){
		final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
		return df.format(geaendert);
	}
	public String getUser1(){return user_1;}
	public String getUser2(){return user_2;}
	public boolean getListe() {return liste;}
	public AusstattungsZeilenListe getZeilenListe() {return asZeilen;}
	public BigDecimal getGesamtPreis() {
		return gesamtPreis;
	}

	//set....
	public void setComment(String c) {comment=c;}
	public void setArtikelnummer(String s) {artikelnummer=s;}
	public void setGebindeGroesse(double x) {gebindeGroesse = x;}
	public void setGebindeGewicht(double x) {gebindeGewicht = x;}
	public void setAdressListe(StichwortListe sl){adressListe = sl;}
	public void setStichwortListe(StichwortListe sl){ stichwortListe = sl; }
	public void setID(int aID){id = aID;}
	public void setTitel(String aTitel){titel = aTitel;}
	public void setWaehrung(int aWaehrung){waehrung = aWaehrung;}
	public void setPreis(String aPreis){
		double n;
		try {
			final NumberFormat nf = rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL);
			n = (nf.parse(aPreis)).doubleValue();
		} catch (final ParseException e) {n=0;}
		preis = new BigDecimal( n).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
	}
	public void setPreis(BigDecimal aPreis){preis = aPreis;}
	public void setGeaendert(Date geaendert) {
		this.geaendert=geaendert;
	}

	public void setListe(boolean liste) {
		this.liste=liste;
	}
	public void setUser_1(String user) {
		user_1 = user;
	}
	public void setUser_2(String user) {
		user_2 = user;
	}
	public Double getChargenGewicht() {
		return chargenGewicht;
	}
	public int getChargenMenge() {
		return chargenMenge;
	}
	public BigDecimal getChargenPreis() {
		return chargenPreis;
	}
	@Override
	public String toString(){
		return titel + (!artikelnummer.equals("")?" ("+artikelnummer+")":"");
	}

}