/*
 * Created on 18.08.2004
 *
 */
package de.lunqual.rzpro.items.rechnen;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.rechenfenster.Rechenfenster;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.mischungen.MischungenTankItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * repräsentiert eine Zeile einer Berechnung
 * @author labor
 *
 */
public class RechenZeile implements Serializable {

    RzPro							rz;
    String							zeile;
    boolean						stern = false;
    boolean						rechnen = false;
    boolean						comment = false;
    RezepturItem				rezeptur;
    int								typ= Rechenfenster.ZEILE_LEER;

    Color							farbe;
    // Zeilendaten

	double						originalMenge;
	String							originalBezeichnung;
	double						menge;
	EinheitsItem					einheit;
	String							bezeichnung;
	double						staerke;
	double 						litergewicht;
	boolean						extraktfrei;
	double						extrakt;
	double 						trockenmasse;
	double						liter;
	double						kg;
	double						la;
	BigDecimal					preis;
	double						preisMenge;
	EinheitsItem					preisEinheit;
	CurrencyItem				waehrung;
	BigDecimal					kalkulationBetrag;
	String							grundPreis;

	CurrencyItem				euro;
    double						extraktfreiLiter;
    double						extraktfreiStaerke;
    double						extraktfreiLitergewicht;
    double						extraktfreiKg;

    String 							losNummer;

    double						brennwert_alkohol;
    double						brennwert_af_faktor;
    double						brennwert_af;
    double 						brennwert;

    double						acid;
    double						acidContent;

    boolean						bestandWarnung;

    int								reihenfolge;
    boolean						marked=false;
    String							tank;
    int								zeilennummer;
    ArrayList<MischungenTankItem>	mischungen;
    
	/**
	 * @param r RzPro-Struktur
	 * @param aZeile , die Zeile, die berechnet werden soll
	 */
    public RechenZeile(RzPro r,String aZeile,int zeilennummer) {
    	    rz = r;
    	    this.zeilennummer = zeilennummer;
    	    zeile = aZeile;
    	    euro = rz.getDatabase().getCurrency().dbGetCurrency(1,true);//Euro !
    	    final String items[] = zeile.split(" ");
    	    switch(items[0].charAt(0)){
    	        case '0' : // kommentar
    	        	comment = true;
    	            typ = Rechenfenster.ZEILE_KOMMENTAR;
        	    	rechnen = false;
    	            originalMenge = -1;
    	            einheit = null;
    	            rezeptur = null;
    	            bezeichnung = zeile.substring(2);
    	            originalBezeichnung = bezeichnung;
    	            staerke=0;
    	            preisMenge = 0;
    	            preisEinheit = null;
    	            preis = new BigDecimal(0.0);
    	            waehrung =null;
    	            losNummer=null;
    	            reihenfolge = DBBuchung.REIHE_FIFO;
    	            break;
    	        case '1' : // rechnen
    	        	comment = false;
    	            typ = Rechenfenster.ZEILE_RECHNEN;
    	            rechnen = true;
    	            if(items[1].equals("*")) {
    	                originalMenge=0;
    	                stern = true;
    	            } else {
    	                stern = false;
    	                originalMenge = rz.getLocale().getNumber(items[1].trim(), OptionFactory.NF_NORMAL);
    	            }
    	            einheit = rz.getDatabase().getEinheiten().getEinheit(items[2]);
    	            rezeptur = rz.getDatabase().getRezeptur().dbGetRezeptur(Integer.valueOf(items[3].substring(2,items[3].indexOf("]]"))).intValue(),true);
    	            bezeichnung=rezeptur.getTitel();
    	            staerke=rezeptur.getStaerke();
    	            extraktfrei = rezeptur.getExtraktfrei();
    	            extrakt = rezeptur.getExtrakt();
    	            litergewicht = rezeptur.getLitergewicht();
    	            staerke = rezeptur.getStaerke();
    	            brennwert_af_faktor = rezeptur.getBrennwertAF();
    	            acid = rezeptur.getAcid();
    	            losNummer = rezeptur.getLosnummer();
    	            tank=rezeptur.getTank();
    	            if(rezeptur.getID() == 0) {
    	                // das ist Verschnittwasser
    	            	preisEinheit = rz.getDatabase().getEinheiten().getGrundeinheit(	rz.getOptionFactory().getOption("kalkulation.wasserpreis_einheit"));
    	            	waehrung = rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.wasserpreis_waehrung",-1 ),true);
    	            	preisMenge = rz.getOptionFactory().getDouble("kalkulation.wasserpreis_menge");
    	            	preis = new BigDecimal(rz.getOptionFactory().getDouble("kalkulation.wasserpreis_preis"));
    	            } else {
    	                preisMenge = rezeptur.getPreisMenge();
    	                preisEinheit =  rz.getDatabase().getEinheiten().getGrundeinheit(String.valueOf(rezeptur.getPreisEinheit()));
    	                waehrung = rz.getDatabase().getCurrency().dbGetCurrency(rezeptur.getWaehrung(),true);
        	            preis = rezeptur.getPreis();
    	            }
    	            break;
    	        case '3' :
    	            typ = Rechenfenster.ZEILE_LEER;
    	        	break;
    	        case '4' :
    	            typ = Rechenfenster.ZEILE_SUMME;
    	            break;

    	    }
    	    try {
    	    	this.mischungen = rz.getDatabase().getMischungen().getMischungenTanksFromRezeptur(rezeptur.getID());
    	    }catch(Exception e) {}
    }
    
    
    public int getZeilennummer() {
		return zeilennummer;
	}

    public ArrayList<MischungenTankItem> getMischungen(){
    	return mischungen;
    }
    public String getMischungenLA() {
    	String ret = "";
    	double la=0.0;
    	if(mischungen != null && !mischungen.isEmpty()) {
    		for(MischungenTankItem t:mischungen) {
    			la += t.getLa();
    		}
    		if(!rz.isZero(la)) {
    			ret = rz.getLocale().formatNumber(la, OptionFactory.NF_ONE) +  " " +rz.getLocale().getString("string_la");
    		}
    	}
    	return ret;
    }

    public double getMischungenLAAmount() {
    	double la=0.0;
    	if(mischungen != null && !mischungen.isEmpty()) {
    		for(MischungenTankItem t:mischungen) {
    			la += t.getLa();
    		}
    	}
    	return la;
    }

    public double getMischungenLAAmountGesamt() {
    	double la=0.0;
    	if(mischungen != null && !mischungen.isEmpty()) {
    		for(MischungenTankItem t:mischungen) {
    			la += t.getLa();
    		}
    	}
    	SaldenItem s=rz.getDatabase().getRezeptur().forceBestand(this.getRezeptur().getID());
    	return la + s.getLa();
    }
    
    public boolean hasMischung() {
    	return !mischungen.isEmpty();
    }
    
	public void setZeilennummer(int zeilennummer) {
		this.zeilennummer = zeilennummer;
	}


	/** rechnet eine einzelne Zeile aus, d.H. die Mengen werden mit dem Faktor
     *  multipliziert
     * @param aFaktor Faktor zur Multiplikation
     */
    public void rechnen(double aFaktor,CurrencyItem calcDest) {
    	// 1. alles auf Anfang
    	liter =0;kg=0;la=0;menge=0;
    	brennwert_alkohol=0;brennwert_af=0;brennwert = 0;acidContent=0;
        menge = originalMenge * aFaktor;
        liter = rz.getDatabase().getEinheiten().toLiter(menge, staerke ,getLitergewicht(),einheit);
        kg = rz.getDatabase().getEinheiten().toKg(menge, staerke ,getLitergewicht(),einheit);
        la = rz.getDatabase().getEinheiten().toLa(menge, staerke ,getLitergewicht(),einheit);


        // Farbe....
        bestandWarnung = false;
        if(rezeptur.getID() != 0) {
    		final double mbs = rezeptur.getMeldebestand();
            final double bs = rezeptur.getBestand();
            double v=0;
        	final EinheitsItem bi = rz.getDatabase().getEinheiten().getGrundeinheit( String.valueOf(rezeptur.getBestandseinheit()));
        	switch(bi.getID()) { // id wegen ist Grundeinheit !!
        		case RzPro.EINHEIT_LITER : v=liter;break;
        		case RzPro.EINHEIT_KG: v=kg;break;
        		case RzPro.EINHEIT_LA: v = la;
        			break;
        	}
        	if (bs <= 0) {
        	    farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
        	} else if(rz.isZero(mbs)) {
        	    // meldebestand ist 0 !
        	    if(v <= bs) {
        	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN);
        	    } else {
        	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
        	    }
        	}else {
        	    // meldebestand != 0;
        	    if(bs <= mbs) {
        	        // bestand ist selber < meldebestand
        	        if(v <= bs) {
            	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB);
        	        } else {
            	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
        	        }
        	    } else {
        	        // bestand ist > meldebestand
        	        if((bs-v)>=mbs) {
            	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN);
        	        } else if (((bs-v) >= 0) && ((bs - v) < mbs)){
            	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB);
        	        } else if((bs-v) <0) {
            	        farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
        	        }
        	    }
        	}
	        if((rezeptur.getID() != 0) && ( farbe ==  rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT))){
	            bestandWarnung = true;
	        }
        } else {
            farbe = rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WASSER);
        }
    	if(menge < 0) {
    	    farbe = Color.RED;
    	}
    	//Kontraktion
    	// 1. Trockensubtanz in %mas ermitteln
    	double trockensubstanz;
    	double gewichtFluessig;
    	double massenProzentFluessig;
    	double gewichtAlkohol;
	    trockensubstanz = getRezeptur().getExtrakt();
    	if((getRezeptur().getExtraktfrei()) || (rz.isZero(trockensubstanz))) {
    	    trockensubstanz = 0;
    	    gewichtFluessig = kg;
    	    extraktfreiStaerke = staerke;
    	    extraktfreiLitergewicht = getLitergewicht();
    	    extraktfreiLiter = liter;
    	    extraktfreiKg = kg;
    	    trockenmasse = 0;
    	} else {
        	trockenmasse = kg* (trockensubstanz/100);
        	gewichtFluessig = kg - trockenmasse;
        	if(staerke != 0) {
	        	gewichtAlkohol = la * rz.getTafelFactory().Litergewicht(100);
	        	massenProzentFluessig= (gewichtAlkohol * 100)/gewichtFluessig;
	        	extraktfreiStaerke = rz.getTafelFactory().MasProz2VolProz(massenProzentFluessig);
	        	extraktfreiLitergewicht = rz.getTafelFactory().Litergewicht(extraktfreiStaerke);
        	} else {
        	  extraktfreiStaerke = 0;
        	  extraktfreiLitergewicht= rz.getTafelFactory().Litergewicht(0);
        	}
        	extraktfreiLiter = gewichtFluessig * (1/extraktfreiLitergewicht);
        	extraktfreiKg = extraktfreiLiter * extraktfreiLitergewicht;
    	}
    	//Kalkulation
    	// Grundpreis darstellen
    	double pMenge;
    	double pFaktor;
    	double betrag;
   	    grundPreis = rz.getLocale().formatNumber(preisMenge,OptionFactory.NF_NORMAL) + " " +
			preisEinheit.getName() + "=" +
			rz.getLocale().formatNumber(preis,OptionFactory.NF_NORMAL) + " " + waehrung.getShortName();
    	//Preis in angegebener Währung ausrechnen ausrechnen

    	switch(preisEinheit.getID()) {
    		case RzPro.EINHEIT_KG:
    		    pMenge = kg;
    		    break;
    		case RzPro.EINHEIT_LITER:
    		    pMenge = liter;
    		break;
    		case RzPro.EINHEIT_LA:
    		    pMenge = la;
    		    break;
    		default: pMenge=0;
    	}
    	if(pMenge != 0) {
    	    pFaktor = pMenge / preisMenge;
    	} else {
    	    pFaktor=0;
    	}
    	betrag = Double.parseDouble(preis.toString()) * pFaktor;
    	/* ist das in der gewünschten Währung ?
    	 * wenn nicht, umrechnen in Euro
    	 */
    	if(calcDest.getID() != waehrung.getID()) {
    	    // wenn die Währung nicht Euro ist in Euro umrechnen
    	    if(euro.getID() != waehrung.getID()) {
    	        betrag = betrag *(1/waehrung.getRate());
    	    }
        	// betrag ist jetzt in euro
    	    if(calcDest.getID() != euro.getID()) {
    	        // ziel nicht in euro, umrechnen
    	        betrag = betrag * calcDest.getRate();
    	    }
    	}try {
        kalkulationBetrag = new BigDecimal(betrag).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
    	} catch(final NumberFormatException n) {
    	    kalkulationBetrag = new BigDecimal(0.0).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
    	}

    	//Brennwert berechnen
    	// erst Alkohol-brennwert
    	if(staerke != 0) {
    		brennwert_alkohol = (liter*10)*rz.getTafelFactory().Brennwert(staerke);
    	}
    	// dann rest-Brennwert
    	if(brennwert_af_faktor != 0) {
    		brennwert_af = brennwert_af_faktor * liter * 10;
    	}
    	//zusammen
    	brennwert = brennwert_alkohol + brennwert_af;

    	// Säuregehalt
    	acidContent = acid * liter;
	    }


    /*---------------------------------------------------------------------
     * Getter/Setter
     * ---------------------------------------------------------------------
     */

    @Override
	public String toString() {
        return this.bezeichnung + " (" + rz.getLocale().formatNumber(this.getExtrakt(), OptionFactory.NF_NORMAL)
        	+ rz.getLocale().getString("string_prozentmas") + ")";
    }
    public EinheitsItem getEinheit() {
        return einheit;
    }
    public void setEinheit(EinheitsItem einheit) {
        this.einheit = einheit;
    }
    public double getKg() {
        return kg;
    }
    public void setKg(double kg) {
        this.kg = kg;
    }
    public double getLa() {
        return la;
    }
    public void setLa(double la) {
        this.la = la;
    }
    public double getLiter() {
        return liter;
    }
    public void setLiter(double liter) {
        this.liter = liter;
    }


	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public double getExtrakt() {
		return extrakt;
	}
	public void setExtrakt(double extrakt) {
		this.extrakt = extrakt;
	}
	public boolean isExtraktfrei() {
		return extraktfrei;
	}
	public void setExtraktfrei(boolean extraktfrei) {
		this.extraktfrei = extraktfrei;
	}
	public double getOriginalMenge() {
		return originalMenge;
	}
	public void setOriginalMenge(double originalMenge) {
		this.originalMenge = originalMenge;
	}
	public void setRezeptur(RezepturItem rezeptur) {
		this.rezeptur = rezeptur;
	}
    public double getMenge() {
        return menge;
    }
    public void setMenge(double menge) {
        this.menge = menge;
    }
    public RezepturItem getRezeptur() {
        return rezeptur;
    }

    public boolean isStern() {
        return stern;
    }
    public void setStern(boolean stern) {
        this.stern = stern;
    }

    public boolean isRechnen() {
        return rechnen;
    }
    public void setRechnen(boolean rechnen) {
        this.rechnen = rechnen;
    }

    public double getStaerke() {
        return staerke;
    }
    public void setStaerke(double staerke) {
        this.staerke = staerke;
    }

    public double getLitergewicht() {
        return  rezeptur.getExtraktfrei() ? rz.getTafelFactory().Litergewicht(staerke)  :litergewicht;
    }
    public void setLitergewicht(double litergewicht) {
        this.litergewicht = litergewicht;
    }

    public int getTyp() {
        return typ;
    }
    public void setTyp(int typ) {
        this.typ = typ;
    }


	public Color getFarbe() {
		return farbe;
	}
	public void setFarbe(Color farbe) {
		this.farbe = farbe;
	}

    public double getExtraktfreiKg() {
        return extraktfreiKg;
    }
    public void setExtraktfreiKg(double extraktfreiKg) {
        this.extraktfreiKg = extraktfreiKg;
    }
    public double getExtraktfreiLiter() {
        return extraktfreiLiter;
    }
    public void setExtraktfreiLiter(double extraktfreiLiter) {
        this.extraktfreiLiter = extraktfreiLiter;
    }
    public double getExtraktfreiLitergewicht() {
        return extraktfreiLitergewicht;
    }
    public void setExtraktfreiLitergewicht(double extraktfreiLitergewicht) {
        this.extraktfreiLitergewicht = extraktfreiLitergewicht;
    }
    public double getExtraktfreiStaerke() {
        return extraktfreiStaerke;
    }
    public void setExtraktfreiStaerke(double extraktfreiStaerke) {
        this.extraktfreiStaerke = extraktfreiStaerke;
    }
    public BigDecimal getKalkulationsWaehrung() {
        return kalkulationBetrag;
    }
    public void setKalkulationsWaehrung(BigDecimal kalkulationsWaehrung) {
        this.kalkulationBetrag = kalkulationsWaehrung;
    }
    public BigDecimal getPreis() {
        return preis;
    }
    public void setPreis(BigDecimal preis) {
        this.preis = preis;
    }
    public EinheitsItem getPreisEinheit() {
        return preisEinheit;
    }
    public void setPreisEinheit(EinheitsItem preisEinheit) {
        this.preisEinheit = preisEinheit;
    }
    public double getPreisMenge() {
        return preisMenge;
    }
    public void setPreisMenge(double preisMenge) {
        this.preisMenge = preisMenge;
    }
    public CurrencyItem getWaehrung() {
        return waehrung;
    }
    public void setWaehrung(CurrencyItem waehrung) {
        this.waehrung = waehrung;
    }

    public double getTrockenmasse() {
        return trockenmasse;
    }
    public void setTrockenmasse(double trockenmasse) {
        this.trockenmasse = trockenmasse;
    }

    public String getGrundPreis() {
        return grundPreis;
    }

    public BigDecimal getKalkulationBetrag() {
        return kalkulationBetrag;
    }

	public String getOriginalBezeichnung() {
		return originalBezeichnung;
	}
	public void setOriginalBezeichnung(String originalBezeichnung) {
		this.originalBezeichnung = originalBezeichnung;
	}

	public boolean isComment() {
		return comment;
	}
	public void setComment(boolean comment) {
		this.comment = comment;
	}

	public String getLosNummer() {
		return losNummer;
	}
	public void setLosNummer(String losNummer) {
		this.losNummer = losNummer;
	}

    public boolean isBestandWarnung() {
        return bestandWarnung;
    }

    /**
     *
     * @return brennwert
     */
    public double getBrennwert() {
    	return brennwert;
    }

    public double getBrennwertAlkohol() {
    	return brennwert_alkohol;
    }

    public double getBrennwertAlkoholfrei() {
    	return brennwert_af;
    }
	public double getAcid() {
		return acid;
	}
	public void setAcid(double acid) {
		this.acid = acid;
	}
	public double getAcidContent() {
		return acidContent;
	}
	public void setAcidContent(double acidContent) {
		this.acidContent = acidContent;
	}
	public int getReihenfolge() {
		return reihenfolge;
	}
	public void setReihenfolge(int reihenfolge) {
		this.reihenfolge = reihenfolge;
	}

	public String getTank() {
		return tank == null?"":tank.trim();
	}
	
	public void setTank(String tank) {
		this.tank=tank.trim();
	}
	
    public String getLosnummerReiheString() {
    	if (reihenfolge==DBBuchung.REIHE_FIFO) {
    		return rz.getLocale().getString("rechnen.table_reihe_fifo");
    	} else {
    		return rz.getLocale().getString("rechnen.table_reihe_lifo");
    	}
    }
	public boolean isMarked() {
		return marked;
	}
	public void setMarked(boolean marked) {
		this.marked = marked;
	}

}
