/*
 * Created on 18.08.2004
 */
package de.lunqual.rzpro.items.rechnen;



import java.io.Serializable;
import java.math.BigDecimal;

import javax.swing.table.AbstractTableModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBRezeptur;
import de.lunqual.rzpro.items.acid.AcidItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class RechenItem implements Serializable{

    public static final int		RECHNEN_LITER = 1;
    public static final int		RECHNEN_KG = 2;
    public static final int  		RECHNEN_LA = 3;

    /** erzeugt eine neue Berechnung
     * @param r   RzPro-Struktur
     * @param aID die ID der Rezeptur;
     *
     */
    RzPro						rz;
    RezepturItem			rezeptur;
    RechenZeilenListe  	zeilenListe;
    AbstractTableModel tblModel;
    int						sternZeile; // die Zeile mit dem Stern, wenn vorhanden
    
    // Zwischensummen
	double 					eSummeLiter;
	double 					eSummeLA;
	double 					eSummeKg;

    double 					wantedLiter;
	double 					wantedLA;
	double					wantedKg;
    double					menge;
	EinheitsItem				einheit;
	String						bezeichnung;
	double					staerke;
	double 					litergewicht;
	boolean					extraktfrei;
	double					extrakt;
	double					summeLiter;
	double					summeKg;
	double					summeLA;
    double					summeExtraktfreiLiter;
    double					summeExtraktfreiKg;
    double					summeTrockenMasse;
    double					wasserT;
    double					wasserP;
    double					kontraktion;
	double					gesamtLiter;
	double					gesamtKg;
	double					gesamtLA;
    double					gesamtExtraktfreiLiter;
    double					gesamtExtraktfreiKg;
    double					gesamtLitergewicht;
    double					gesamtTrockenmasse;
    double					gesamtExtrakt; //Extrakt in gr/100ml
    double					extraktMassenProzent;
    double					faktor;

    double					summeBrennwert;
    double 					summeBrennwertAF;
    double					summeBrennwertA;
    
    double					summeAcid;
    double					gesamtAcid; //Säure in gr/Liter

    double					acidOther;
    AcidItem					acidDest;
    AcidItem					acidBasis;

    double 					alkoholGramm;

    //in der Rezeptur gespeichertes original-Litergewicht/extrakt/säure
    double					originalLitergewicht;
    double					originalExtrakt;
    double					originalAcid;

    CurrencyItem 			waehrung;
	CurrencyItem			euro;
	String						wasserGrundpreis;
	String						steuerGrundpreis;
    BigDecimal				summeKalkulation;
    BigDecimal				verschnittwasserPreis;
    BigDecimal				steuer;
    BigDecimal				summeMitSteuer;
    BigDecimal				summeOhneSteuer;
    BigDecimal				literMitSteuer;
    BigDecimal				literOhneSteuer;
    BigDecimal				kgMitSteuer;
    BigDecimal				kgOhneSteuer;
    BigDecimal				laMitSteuer;
    BigDecimal				laOhneSteuer;

    boolean					preisWarnung; // sind alle Preise angegeben ?
    												  // wenn true, warnung, dass  nicht alle preise vorhanden sind
    boolean					buchungsWarnung; // wenn irgendein Bestand unter 0 fällt ,darf nicht
    														// verbucht werden

    DeklarationsListe 	deklarationenOriginal;
    DeklarationsListe		deklarationenAlle;

    AusstattungsItem		ausstattung;
    
    boolean					spezifikationTextDrucken = true;
    boolean					duplex=false;
    
    boolean					eigenRezeptur = false;
    
    /** erzeugt ein RechenItem aus der ID der Rezeptur
     *
     * @param r RzPro
     * @param aID ID der Rezeptur
     */
    public RechenItem(RzPro r,int aID,AbstractTableModel aModel) {
        rz = r;
        tblModel = aModel;
        initItem(aID,null);
    }
    /** erzeugt ein RechenItem aus der ID der Rezpetur und
     *  berechnet es gleich nach der Menge
     * @param r RzPro
     * @param aID ID derRezeptur
     * @param aMenge Mengenangabe
     * @param aID Berechnungsmodus
     */
    public RechenItem(RzPro r,int aID,double aMenge,int aMode,AbstractTableModel aModel) {
        rz = r;
        tblModel = aModel;
        initItem(aID,null);
        if(rezeptur != null) {
	        staerke = rezeptur.getStaerke();
	        faktor = 1;
	        rechnen(aMenge,aMode);
        }
    }

    /**
     * liefert alle rezepturIDs
     */
    public int[] getRezepturIDS() {
    	int[] ret = null;
    	int len = getZeilenListe().size();
    	ret = new int[len+1];
    	ret[0] = this.getRezeptur().getID();
    	for(int i =1;i<(len+1);i++) {
    		if(getZeilenListe().getItem(i-1).isRechnen() ) {
    			ret[i] = getZeilenListe().getItem(i-1).getRezeptur().getID();
    		}else {
    			ret[i] = 0;
    		}
    	}
    	return ret;
    }
    
    /**
     * stellt fest ob eine bestimmte Rezeptur in der Zeilenliste vorhanden ist
     * und holt den aktuellen Bestand neu.
     * @param rezeptur
     * @param neu
     * @return true, wenn der Bestand upgedated wurde, false, wenn die Rezeptur nicht in der Liste ist
     */
    public boolean updateBestand(int rezeptur) {
    	boolean ret=false;
    	for (int i =0; i < this.getZeilenListe().size();i++) {
    		final RechenZeile rzl = this.getZeilenListe().getItem(i);
    		if(rzl.isRechnen()) {
    			if(rzl.getRezeptur().getID() == rezeptur) {
    				rzl.getRezeptur().setBestand(rz.getDatabase().getRezeptur().getBestand(rezeptur));
    				neuBerechnen(faktor,faktor);//alles so wie vorher nochmal neu berechnen
    				ret = true;
    				break;
    			}
    		}
    	}
    	return ret;
    }

    public boolean updateBestaende(int[] rezepturen) {
    	boolean ret=false;
    	for (int i =0; i < this.getZeilenListe().size();i++) {
    		final RechenZeile rzl = this.getZeilenListe().getItem(i);
    		if(rzl.isRechnen()) {
    			for(int j=0;j < rezepturen.length;j++) {
	    			if(rzl.getRezeptur().getID() == rezepturen[j]) {
	    				rzl.getRezeptur().setBestand(rz.getDatabase().getRezeptur().getBestand(rezepturen[j]));
	    				ret = true;
	    				break;
	    			}
    			}
    		}
    	}
    	if(ret) {
			neuBerechnen(faktor,faktor);//alles so wie vorher nochmal neu berechnen
    	}
    	return ret;
    }

    
    private void getWanted(double aMenge,int aMode) {
        switch(aMode) {
        	case RzPro.EINHEIT_LITER:
        		wantedLiter = aMenge;
    			wantedKg = wantedLiter * rezeptur.getLitergewicht(staerke);
        		if(staerke != 0) {
        			wantedLA = wantedLiter * (staerke/100);
        		}
        		break;
        	case RzPro.EINHEIT_KG:
        		wantedKg = aMenge;
        		wantedLiter = wantedKg * (1/rezeptur.getLitergewicht(staerke));
        		if(staerke != 0) {
        			wantedLA = wantedLiter * (staerke/100);
        		}
        		break;
        	case RzPro.EINHEIT_LA:
        		if(staerke != 0) {
        			wantedLA = aMenge;
        			wantedLiter = (wantedLA * 100) /staerke;
        			wantedKg = wantedLiter * rezeptur.getLitergewicht(staerke);
        			wantedLA = aMenge;
        		} else {
        			wantedLiter = 0;
        			wantedKg = 0;
        			wantedLA = 0;
        		}
        		break;
        }
    }

    public void neuBerechnen(double alt,double neu) {
        if(sternZeile != -1) {
    		gesamtLiter = gesamtLiter * (neu/alt);
    		gesamtLA = gesamtLA * (neu/alt);
        }
        this.faktor = faktor * (neu/alt);
        rechnen_2();
    	//anzeigen
    	if(tblModel != null) {
    	    tblModel.fireTableDataChanged();
    	}
    }

	 public void getSumme() {
    	rechnen_2();
    	if(ausstattung != null) {
    		ausstattung.rechnen(this.getGesamtLiter(),this.getWaehrung());
    	}
    	//anzeigen
    	if(tblModel != null) {
    	    tblModel.fireTableDataChanged();
    	}
	 }

    public void rechnen(double aMenge,int aMode) {
    	//1. Die Basismenge in Liter feststellen
    	preisWarnung = false;
    	buchungsWarnung = false;
    	double f;
    	try {
    	    if(sternZeile != -1) {
	    		getWanted(aMenge,aMode);
        		gesamtLiter = wantedLiter;
        		gesamtLA = wantedLA;
	        	switch(rezeptur.getBasiseinheit()) {
		    		case RzPro.EINHEIT_LITER :
		    			faktor = wantedLiter / rezeptur.getBasismenge();
		    			break;
		    		case RzPro.EINHEIT_KG :
		    			faktor =wantedKg /rezeptur.getBasismenge() ;
		    			break;
		    		case RzPro.EINHEIT_LA:
		    			faktor = wantedLA / rezeptur.getBasismenge() ;
		    			break;
		    	}
    	    } else {
    	         f = faktor;
    		    faktor = 1;
    		    pass_1();
    		    getSummeOhneStern();
    		    staerke  = rz.getTafelFactory().Staerke(summeLiter,summeLA);
    		    switch(aMode) {
    		    	case RzPro.EINHEIT_LITER:
    		    	    f = aMenge/summeLiter ;
    		    	    break;
    		    	case RzPro.EINHEIT_KG:
    	   	    	if(rz.isZero(summeTrockenMasse) ) {
    	   	    	    summeKg = summeLiter * rz.getTafelFactory().Litergewicht(staerke);
    	   	    	}
    		    	   f = aMenge/summeKg;
    		    	    break;
    		    	case RzPro.EINHEIT_LA:
    		    	    f=aMenge/summeLA;
    		    	    break;
    		    }
    		    faktor = f;
    	    }
    	} catch (final Exception e) {
    		rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"RechenItem.rechnen:",e.getLocalizedMessage());
    		faktor = 1;
    	}

    	getSumme();

    }

    /** ;den Multiplikationsfaktor neu setzen
     * zieht eine Neuberechnung nach sich
     * @param aFaktor
     */
    private void rechnen_2() {
    		// wenns einen Stern gibt, folgt pass 2;
    		if(sternZeile != -1) {
            	pass_1();
            	getSummeOhneStern();
    		    pass_2();
    		    getSummeMitStern();
        		getGesamtKontraktion();
        		gesamtSummeRezeptur();
    		} else {
    		    pass_1();
    		    getSummeOhneStern();
    		    wasserT=0;
    		    wasserP=0;
     	    	final double ueberLiter = (summeExtraktfreiLiter) * rz.getTafelFactory().Litergewicht(rz.getTafelFactory().Staerke(summeExtraktfreiLiter ,summeLA) );
    	    	final double ueberExtraktfrei = summeExtraktfreiKg ;
    	    	final double kontraktionKg = Math.abs(ueberLiter - ueberExtraktfrei);
    	    	kontraktion = kontraktionKg * (1/rz.getTafelFactory().Litergewicht(0));
    	    	try {
	      	    	    zeilenListe.getItem(zeilenListe.size()-3).setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.wasserpreis_waehrung",-1),true));
	     	    	    zeilenListe.getItem(zeilenListe.size()-3).setPreis(new BigDecimal(rz.getOptionFactory().getDouble("kalkulation.wasserpreis_preis")).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP));
	    	    	    zeilenListe.getItem(zeilenListe.size()-3).setPreisMenge(rz.getOptionFactory().getDouble("kalkulation.wasserpreis_menge"));

	      	    	    zeilenListe.getItem(zeilenListe.size()-3).setOriginalMenge(kontraktion);
	    	    	    zeilenListe.getItem(zeilenListe.size()-3).rechnen(1,waehrung);
	      	    	    zeilenListe.getItem(zeilenListe.size()-3).setOriginalMenge(0);
    	    	}catch(final Exception e) {
    	    	    e.printStackTrace();
    	    	}
    	    	getSummeOhneStern();
    		    wasserT=0;wasserP=kontraktion;
    		    gesamtLiter = summeLiter-kontraktion;
    		    gesamtLA = summeLA;
    		    staerke  = rz.getTafelFactory().Staerke(gesamtLiter,gesamtLA);
    		    gesamtSummeRezeptur();

    		}
    }

    /** pass_1 berechnet alle Zeilen ausser der Sternzeile
     */
    private void pass_1() {
    	RechenZeile z=null;
    	for(int i = 0;i < zeilenListe.size();i++) {
    		z = zeilenListe.getItem(i);
    		if(z.isRechnen() && !z.isStern()) {
    		    if (z.getRezeptur().getID() != DBRezeptur.REZEPTURWASSER) {
					z.rechnen(faktor,waehrung);
				}
    		}
    	}
    }


    /** pass_2 berechnet die fehlende Menge der Sternzeile
     */
    private void pass_2() {
    	/* feststellen wieviel LA noch fehlen, die Menge
    	 * in die Sternzeile eintragen und berechnen
    	 */
    	final RechenZeile stern = zeilenListe.getItem(sternZeile);
    	final double wantedLA = (gesamtLiter * (staerke/100)) - summeLA;
    	stern.setOriginalMenge(wantedLA);
    	stern.rechnen(1,waehrung);
    }

    /** die Summen feststellen
     */
    public void getSummeOhneStern() {
    	//1. alles auf Anfang
    	RechenZeile z = null;
    	summeBrennwert = 0;
    	summeBrennwertA = 0;
    	summeBrennwertAF = 0;
    	summeAcid=0;
    	eSummeLiter =0;eSummeKg =0;eSummeLA=0;
    	summeLiter =0;summeKg =0;summeLA=0;
    	summeExtraktfreiLiter = 0; summeExtraktfreiKg=0;
    	summeTrockenMasse=0;
    	summeKalkulation = new BigDecimal(0.0).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	// aufaddieren
    	for(int i = 0;i < zeilenListe.size();i++) {
    		z = zeilenListe.getItem(i);
    		if(z.isRechnen() && !z.isStern()) {
    			summeBrennwert += z.getBrennwert();
    			summeBrennwertAF += z.getBrennwertAlkoholfrei();
    			summeBrennwertA += z.getBrennwertAlkohol();
    			summeAcid += z.getAcidContent();
    			summeLiter += z.getLiter();eSummeLiter += z.getLiter();
    			summeKg += z.getKg();eSummeKg += z.getKg();
    			summeLA += z.getLa();eSummeLA += z.getLa();
    			summeExtraktfreiLiter += z.getExtraktfreiLiter();
    			summeExtraktfreiKg += z.getExtraktfreiKg();
    			summeTrockenMasse += z.getTrockenmasse();
    			//try {
    				summeKalkulation = summeKalkulation.add(z.getKalkulationBetrag()).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    			//} catch (NullPointerException e) {}
    		} else {
    			if(z.isComment()) {
					z.setBezeichnung(commentText(z.getOriginalBezeichnung(),z.getZeilennummer()));
				}
			}
    	}
    }
    private void getSummeMitStern() {
    	//1. alles auf Anfang
    	RechenZeile z = null;
    	eSummeLiter =0;eSummeKg =0;eSummeLA=0;
    	summeLiter =0;summeKg =0;summeLA=0;
    	summeExtraktfreiLiter = 0; summeExtraktfreiKg=0;
    	summeTrockenMasse = 0;
    	summeBrennwert = 0;
    	summeBrennwertA = 0;
    	summeBrennwertAF = 0;
    	summeAcid=0;
    	summeKalkulation = new BigDecimal(0.0);
    	summeKalkulation = summeKalkulation.setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	// aufaddieren
    	for(int i = 0;i < zeilenListe.size();i++) {
    		z = zeilenListe.getItem(i);
    		if(z.isRechnen()) {
    			summeBrennwert += z.getBrennwert();
    			summeBrennwertAF += z.getBrennwertAlkoholfrei();
    			summeBrennwertA += z.getBrennwertAlkohol();
    			summeAcid += z.getAcidContent();
    			summeLiter += z.getLiter();eSummeLiter += z.getLiter();
    			summeKg += z.getKg();eSummeKg += z.getKg();
    			summeLA += z.getLa();eSummeLA += z.getLa();
    			summeExtraktfreiLiter += z.getExtraktfreiLiter();
    			summeExtraktfreiKg += z.getExtraktfreiKg();
    			summeTrockenMasse += z.getTrockenmasse();
    			summeKalkulation = summeKalkulation.add(z.getKalkulationBetrag());
    		} else {
    			if(z.isComment()) {
					z.setBezeichnung(commentText(z.getOriginalBezeichnung(),z.getZeilennummer()));
				}
    			}
   		}
    }

    private String commentText(String in,int zeilennummer) {
    	String out = in;
    	if(out.indexOf("$estart") != -1) {
    		out = out.replaceAll("\\$estart",rz.getLocale().getString("rechnen.zwischensumme_start"));
        	eSummeLiter =0;eSummeKg =0;eSummeLA=0;
    	}
    	final double ueberLiter = (summeExtraktfreiLiter) * rz.getTafelFactory().Litergewicht(rz.getTafelFactory().Staerke(summeExtraktfreiLiter ,summeLA) );
    	final double ueberExtraktfrei = summeExtraktfreiKg ;
    	
    	final double kontraktionKg = Math.abs(ueberLiter - ueberExtraktfrei);
    	final double k = kontraktionKg * (1/rz.getTafelFactory().Litergewicht(0));
    	out = out.replaceAll("\\$zliter",rz.getLocale().formatNumber(summeLiter-k,OptionFactory.NF_NORMAL ));
    	out = out.replaceAll("\\$eliter",rz.getLocale().formatNumber(eSummeLiter,OptionFactory.NF_NORMAL ));
    	out = out.replaceAll("\\$zla",rz.getLocale().formatNumber(summeLA,OptionFactory.NF_NORMAL ));
    	out = out.replaceAll("\\$zkg",rz.getLocale().formatNumber(summeKg,OptionFactory.NF_NORMAL ));
    	out = out.replaceAll("\\$z\\%",rz.getLocale().formatNumber(rz.getTafelFactory().Staerke(summeLiter-k,summeLA),OptionFactory.NF_STAERKE ));

    	out = out.replaceAll("\\$ela",rz.getLocale().formatNumber(eSummeLA,OptionFactory.NF_NORMAL ));
    	out = out.replaceAll("\\$ekg",rz.getLocale().formatNumber(eSummeKg,OptionFactory.NF_NORMAL ));
    	out = out.replaceAll("\\$e\\%",rz.getLocale().formatNumber(rz.getTafelFactory().Staerke(eSummeLiter ,eSummeLA),OptionFactory.NF_STAERKE ));

    	if(out.indexOf("@") != -1) {
    		String r = out;
    		r = r.replaceAll("@", "").replaceAll("\\s", " ").trim();
    		String werte[] = r.split(" ");
    		if(werte.length==3) {
    			try {
    				werte[0] = werte[0].replaceAll(",", ".");
    				double value = Double.parseDouble(werte[0]);
    				EinheitsItem einheit = rz.getDatabase().getEinheiten().getEinheit(werte[1]);
    				int v1 = 0;
    				double rest = 0.0;
    				double rest2 = 0.0;
    				EinheitsItem einheit2 = null;
    				RechenZeile zeile = getLastItem(zeilennummer);
    				if(zeile != null) {
    					if(einheit != null) {
    						if(einheit.getFaktor()==1) {
		    					switch(einheit.getTyp()) {
		    						case RzPro.EINHEIT_LITER:
		    							v1 =(int)(zeile.getLiter() / value);
		    							rest = zeile.getLiter() -  (v1 * value);
		    							einheit2 = rz.getDatabase().getEinheiten().getEinheit("kg");
		    							rest2 = rest * zeile.litergewicht;
		    							break;
		    						case RzPro.EINHEIT_KG:
		    							v1 =(int)(zeile.getKg() / value);
		    							rest = zeile.getKg() -  (v1 * value);
		    							einheit2 = rz.getDatabase().getEinheiten().getEinheit("liter");
		    							rest2 = rest * (1/zeile.litergewicht);
		    							break;
		    					}
		   						out = String.valueOf(v1) + " * " + werte[0] + " " + werte[1] + " " + werte[2]+
		   								" + " +rz.getLocale().formatNumber(rest,OptionFactory.NF_NORMAL) + " " + werte[1] + 
		   								(einheit2 != null ?" (" + rz.getLocale().formatNumber(rest2,OptionFactory.NF_NORMAL) + " " + einheit2.getName()+")":"");
    						}
    					}
    				}
    			}catch(Exception e) {}
    		}
       	}
		return out;
    }

    RechenZeile getLastItem(int zeilennummer) {
		if(zeilennummer >= 0) {
			for(int j = zeilennummer;j>=0;j--) {
				if(zeilenListe.getItem(j).isRechnen() || zeilenListe.getItem(j).isStern()) {
					return zeilenListe.getItem(j);
				}
			}
		}
    	return null;
    }
    
    /** ermittlet die Endsummen für eine normale Rezeptur
     *
     */
    public void gesamtSummeRezeptur() {
    	// gesamtsummen ermitteln
    	//Trockenmasse
    	gesamtTrockenmasse = summeTrockenMasse;

    	if(rz.isZero(gesamtTrockenmasse)) {
    	    gesamtKg = gesamtLiter * rz.getTafelFactory().Litergewicht(staerke);
    	    gesamtLitergewicht = rz.getTafelFactory().Litergewicht(staerke);
    	} else {
    	    gesamtKg = summeKg + wasserP * rz.getTafelFactory().Litergewicht(0);
        	gesamtLitergewicht = gesamtKg/gesamtLiter;
    	}


    	//gr/100ml
    	/* einheiten 100ml und gramm nicht mehr wörtlich nehmen
    	 */

    	final EinheitsItem ei100ml = rz.getDatabase().getEinheiten().getEinheit("100ml");
    	final EinheitsItem eiGramm = rz.getDatabase().getEinheiten().getEinheit("gramm");

    	gesamtExtrakt = (gesamtTrockenmasse * (1/eiGramm.getFaktor()))/ (gesamtLiter *(1/ei100ml.getFaktor()));

    	extraktMassenProzent = (100 * gesamtTrockenmasse)/gesamtKg;

    	//Säure
    	gesamtAcid = summeAcid/gesamtLiter;

    	//Kalkulation
    	//Preis der Zutaten == summeKalkulation
    	//Steuerpreis
    	// Steuergrundpreis per LA ausrechnen
    	final EinheitsItem steuerEinheit = rz.getDatabase().getEinheiten().getGrundeinheit(	rz.getOptionFactory().getOption("kalkulation.steuer_einheit"));
    	final CurrencyItem steuerWaehrung = rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.steuer_waehrung",-1 ),true);
    	double steuerMenge = rz.getOptionFactory().getDouble("kalkulation.steuer_menge");
    	double steuerPerLA = 0.0;

    	steuerGrundpreis=steuerMenge + " " +
			steuerEinheit.getName() + "=" +
			rz.getOptionFactory().getDouble("kalkulation.steuer_preis") + " " +
			steuerWaehrung.getShortName();

    	if(!rz.isZero(steuerMenge)) {
	    	if(steuerEinheit.getTyp() == RzPro.EINHEIT_KG) {
	    	    steuerMenge = (1/rz.getTafelFactory().Litergewicht(100)) * steuerMenge;
	    	}
	    	steuerPerLA = rz.getOptionFactory().getDouble("kalkulation.steuer_preis") / steuerMenge;
	    	//in zielwährung umrechnen
		   	 // wenn die Währung nicht Euro ist in Euro umrechnen
			if(euro.getID() != steuerWaehrung.getID()) {
			    steuerPerLA= steuerPerLA *(1/steuerWaehrung.getRate());
			}
		   	// betrag ist jetzt in euro
			if(waehrung.getID() != euro.getID()) {
			    // ziel nicht in euro, umrechnen
			    steuerPerLA  = steuerPerLA * waehrung.getRate();
			 }
    	}
    	try {
	   	 steuer = new BigDecimal(summeLA * steuerPerLA).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	} catch (final Exception e) {
    		steuer = new BigDecimal(0.0);
    	}
    	//Verschnittwasserpreis
    	//Wassergrundpreis per Liter ausrechnen
    	final EinheitsItem verschnittwasserEinheit = rz.getDatabase().getEinheiten().getGrundeinheit(	rz.getOptionFactory().getOption("kalkulation.wasserpreis_einheit"));
    	final CurrencyItem verschnittwasserWaehrung = rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.wasserpreis_waehrung",-1 ),true);
    	double verschnittwasserMenge = rz.getOptionFactory().getDouble("kalkulation.wasserpreis_menge");
    	double wasserPerLiter = 0.0;

    	wasserGrundpreis=verschnittwasserMenge + " " +
			verschnittwasserEinheit.getName() + "=" +
			rz.getOptionFactory().getDouble("kalkulation.wasserpreis_preis") + " " +
			verschnittwasserWaehrung.getShortName();

    	if(!rz.isZero(verschnittwasserMenge)) {
	    	if(verschnittwasserEinheit.getTyp() == RzPro.EINHEIT_KG) {
	    	    verschnittwasserMenge = (1/rz.getTafelFactory().Litergewicht(0)) * verschnittwasserMenge;
	    	}
	    	wasserPerLiter = rz.getOptionFactory().getDouble("kalkulation.wasserpreis_preis") / verschnittwasserMenge;
	    	//in zielwährung umrechnen
	    	 // wenn die Währung nicht Euro ist in Euro umrechnen
		    if(euro.getID() != verschnittwasserWaehrung.getID()) {
		        wasserPerLiter= wasserPerLiter *(1/verschnittwasserWaehrung.getRate());
		    }
	    	// betrag ist jetzt in euro
		    if(waehrung.getID() != euro.getID()) {
		        // ziel nicht in euro, umrechnen
		        wasserPerLiter = wasserPerLiter * waehrung.getRate();
		    }
    	}
    	try {
    	    verschnittwasserPreis = new BigDecimal(wasserP * wasserPerLiter).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	}  catch(final NumberFormatException n) {
    	    verschnittwasserPreis = new BigDecimal(0.0).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	}
    	summeOhneSteuer=summeKalkulation.add( verschnittwasserPreis).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	summeMitSteuer = summeOhneSteuer.add(steuer).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);

    	if(!rz.isZero(gesamtLiter)) {
    		literOhneSteuer = summeOhneSteuer.divide(new BigDecimal(gesamtLiter),RzPro.CURRENCY_DEFAULT_SCALE).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    		literMitSteuer = summeMitSteuer.divide(new BigDecimal(gesamtLiter),RzPro.CURRENCY_DEFAULT_SCALE).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	} else {
    		literOhneSteuer = new BigDecimal(0.0);
    		literMitSteuer = new BigDecimal(0.0);
    	}
    	if(!rz.isZero(gesamtLA)) {
    		laOhneSteuer = summeOhneSteuer.divide(new BigDecimal(gesamtLA),RzPro.CURRENCY_DEFAULT_SCALE).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    		laMitSteuer = summeMitSteuer.divide(new BigDecimal(gesamtLA),RzPro.CURRENCY_DEFAULT_SCALE).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	} else {
    		laOhneSteuer = new BigDecimal(0.0);
    		laMitSteuer = new BigDecimal(0.0);
    	}
    	if(!rz.isZero(gesamtKg)) {
    		kgOhneSteuer = summeOhneSteuer.divide(new BigDecimal(gesamtKg),RzPro.CURRENCY_DEFAULT_SCALE).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    		kgMitSteuer = summeMitSteuer.divide(new BigDecimal(gesamtKg),RzPro.CURRENCY_DEFAULT_SCALE).setScale(RzPro.CURRENCY_DEFAULT_SCALE,BigDecimal.ROUND_HALF_UP);
    	}else {
    		kgOhneSteuer = new BigDecimal(0.0);
    		kgMitSteuer = new BigDecimal(0.0);
    	}
    	//ermitteltes Litergewicht speichern...
    	if(!rz.isZero(summeTrockenMasse)) {
    		rezeptur.setLitergewicht(gesamtLitergewicht);
    	}
    	preisWarnung= false;
    	buchungsWarnung=false;
    	for(int i = 0;i < zeilenListe.size();i++) {
    		if(zeilenListe.getItem(i).isRechnen() || zeilenListe.getItem(i).isStern()) {
	    		if(rz.isZero(zeilenListe.getItem(i).getKalkulationBetrag().doubleValue())){
	    			preisWarnung=true;
	    		}
	    		if(zeilenListe.getItem(i).isBestandWarnung()) {
	    		    buchungsWarnung=true;
	    		}
    		}
    	}
    	//säure
		acidOther = rz.getDatabase().getAcid().convert(this.getGesamtAcid(),acidBasis,acidDest);
    }


    public void getGesamtKontraktion() {
    	double ueberLiter;
    	double ueberExtraktfrei;
    	wasserT = gesamtLiter - summeLiter;
    	ueberLiter = (summeExtraktfreiLiter + wasserT) * rz.getTafelFactory().Litergewicht(rz.getTafelFactory().Staerke(summeExtraktfreiLiter + wasserT,gesamtLA) );
    	ueberExtraktfrei = summeExtraktfreiKg + (wasserT * rz.getTafelFactory().Litergewicht(0));
    	kontraktion = Math.abs( (ueberLiter - ueberExtraktfrei) * (1/ rz.getTafelFactory().Litergewicht(0)));
    	wasserP = wasserT + kontraktion;
    }

    /** der Säuregehalt muss neu berechnet werden
     *
     * @param wantedAcid  gewünschter Säuregehalt in gr/liter
     * @param komponente  die Komponenten, mit der angepasst werden soll
     */
    public void  reCalcAcid(double wantedAcid,RechenZeile komponente) {


		try {
			final double summeAcid = this.getGesamtLiter() * wantedAcid;
			final double fehltGramm = summeAcid - (this.getGesamtLiter() * this.getGesamtAcid());
			final double f1 = fehltGramm/komponente.getAcid();
			final double f = (komponente.getLiter() + f1)/komponente.getLiter();
			komponente.setOriginalMenge(komponente.getOriginalMenge() * f);
			komponente.rechnen(getFaktor(), waehrung);
		} catch (final Exception e) {
		}
		getSumme();
    }


    /** der Extraktgehalt muss neu berechnet werden
     *
     * @param wantedExtrakt  gewünschter Extarktgehalt in gr/100ml
     * @param komponente  die Komponenten, mit der angepasst werden soll
     */
    public void  reCalcExtrakt(double wantedExtrakt,RechenZeile komponente) {
    	//gr/100ml
    	final EinheitsItem ei100ml = rz.getDatabase().getEinheiten().getEinheit("100ml");
    	final EinheitsItem eiGramm = rz.getDatabase().getEinheiten().getEinheit("gramm");
    	double gesamt =(((wantedExtrakt * (1/ei100ml.getFaktor())) * gesamtLiter) * eiGramm.getFaktor())-gesamtTrockenmasse;
    	gesamt = gesamt * (1/komponente.getExtrakt())*100;
    	final double inMengenEinheit = rz.getDatabase().getEinheiten().convert(gesamt, komponente.getStaerke(),komponente.getLitergewicht(),rz.getDatabase().getEinheiten().getEinheit("kg"), komponente.getEinheit());
    	final double f = (inMengenEinheit+komponente.getMenge())/komponente.getMenge();
    	komponente.setOriginalMenge(komponente.getOriginalMenge() * f);
    	komponente.rechnen(getFaktor(),waehrung);

    	getSumme();
    }

    /** die RechenzeilenListe erzeugen
     * @param aID die ID der Rezeptur
     */
    public void initItem(int aID,RezepturItem rei) {
        int i;
        RezepturItem r1= null;
	    euro = rz.getDatabase().getCurrency().dbGetCurrency(1,true);//Euro !
        sternZeile = -1;
        	if(rei!= null ) {
        		r1 = rei;
        	} else {
        		r1 = rz.getDatabase().getRezeptur().dbGetRezeptur(aID,false);
        	}
            if(r1 != null) {
		        if(r1.getVerweis() != 0) {
		            rezeptur = rz.getDatabase().getRezeptur().dbGetRezeptur(r1.getVerweis(),true);
		            rezeptur.setTitel(r1.getTitel());
		            rezeptur.setAdressListe(r1.getAdressListe());
		            rezeptur.setStichwortListe(r1.getStichwortListe());
		        } else {
		            rezeptur = r1;
		        }
		        staerke = rezeptur.getStaerke();
		        originalLitergewicht = rezeptur.getLitergewicht();
		        originalExtrakt = rezeptur.getExtrakt();
		        deklarationenOriginal=rezeptur.getDeklarationenAlle().copyList();
		        deklarationenAlle=rz.getDatabase().getDeklarationen().getDeklarationsListeAlle(rezeptur.getID());
		        originalAcid  = rezeptur.getAcid();
		        acidDest  = rz.getDatabase().getAcid().getDefaultAcid();
		        acidBasis = rz.getDatabase().getAcid().getAcid(1);

		        zeilenListe = new RechenZeilenListe(rz);
		        final String[] zeilen = rezeptur.getRaw().split("\n");
		        for(i = 0;i < zeilen.length;i++) {
		            zeilenListe.addItem(zeilen[i]);
		        }
		        if(!zeilenListe.isBerechnung()) {
		        	eigenRezeptur = true;
		            if(staerke != 0) {
		                zeilenListe.addItem("1 * " + rz.getDatabase().getEinheiten().getEinheit(String.valueOf(rz.getDatabase().getEinheiten().getGrundeinheit("3").getTyp())).getID() + " [[" + rezeptur.getID() + "]]");
		            } else {
		                switch (rezeptur.getBasiseinheit()) {
		                	case RzPro.EINHEIT_LITER :
		                	    zeilenListe.addItem("1 " + rz.getLocale().formatNumber(rezeptur.getBasismenge(),OptionFactory.NF_NORMAL) +
		                        " " + rz.getDatabase().getEinheiten().getEinheit(String.valueOf(rz.getDatabase().getEinheiten().getGrundeinheit("1").getTyp())).getID() + " [[" + rezeptur.getID() + "]]");
		                		break;
		                	case RzPro.EINHEIT_KG :
		                	    zeilenListe.addItem("1 " + rz.getLocale().formatNumber(rezeptur.getBasismenge(),OptionFactory.NF_NORMAL) +
		                        " " + rz.getDatabase().getEinheiten().getEinheit(String.valueOf(rz.getDatabase().getEinheiten().getGrundeinheit("2").getTyp())).getID()+ " [[" + rezeptur.getID() + "]]");
		                	break;
		                }
		            }
		        }
	        sternZeile = zeilenListe.getSternZeile();
	        if(sternZeile != -1) {
	            (zeilenListe.getItem(sternZeile)).setEinheit(rz.getDatabase().getEinheiten().getEinheit("la"));
	        }
	        if((sternZeile == -1) && zeilenListe.isBerechnung() ) {
	            zeilenListe.addItem("1 0 " + rz.getDatabase().getEinheiten().getGrundeinheit("1").getID()+ " [[" + DBRezeptur.REZEPTURWASSER + "]]");

	         }
	        zeilenListe.addItem("3 leer");
	        zeilenListe.addItem("4 summe");
        } else {
        	rezeptur=null;
        }
        spezifikationTextDrucken = true;
        duplex = false;
    }

    /*---------------------------------------------------------------
     * @author labor
     *
     * getters/setters
     * ---------------------------------------------------------------
     */

    public boolean isEigenRezeptur() {
    	return eigenRezeptur;
    }
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public EinheitsItem getEinheit() {
		return einheit;
	}
	public double getExtrakt() {
		return extrakt;
	}
	public boolean isExtraktfrei() {
		return extraktfrei;
	}
	public double getFaktor() {
		return faktor;
	}
	public void setFaktor(double faktor) {
		this.faktor = faktor;
	}
	public double getSummeKg() {
		return summeKg;
	}
	public double getSummeLA() {
		return summeLA;
	}
	public double getSummeLiter() {
		return summeLiter;
	}
	public void setSummeLiter(double summeLiter) {
		this.summeLiter = summeLiter;
	}
	public double getLitergewicht() {
		return litergewicht;
	}
	public double getMenge() {
		return menge;
	}
	public void setMenge(double menge) {
		this.menge = menge;
	}
	public RezepturItem getRezeptur() {
		return rezeptur;
	}
	public void setRezeptur(RezepturItem rezeptur) {
		this.rezeptur = rezeptur;
	}
	public double getStaerke() {
		return staerke;
	}
	public void setStaerke(double staerke) {
		this.staerke = staerke;
	}
	public int getSternZeile() {
		return sternZeile;
	}
	public void setSternZeile(int sternZeile) {
		this.sternZeile = sternZeile;
	}
    public RechenZeilenListe getZeilenListe() {
        return zeilenListe;
    }
    public void setZeilenliste(RechenZeilenListe zl) {
    	this.zeilenListe = zl;
    }
    public double getGesamtExtraktfreiKg() {
        return gesamtExtraktfreiKg;
    }
    public double getGesamtExtraktfreiLiter() {
        return gesamtExtraktfreiLiter;
    }
    public double getGesamtKg() {
        return gesamtKg;
    }
    public double getGesamtLiter() {
        return gesamtLiter;
    }
    public double getSummeExtraktfreiKg() {
        return summeExtraktfreiKg;
    }
    public double getSummeExtraktfreiLiter() {
        return summeExtraktfreiLiter;
    }
    public double getGesamtLA() {
        return gesamtLA;
    }

    public double getKontraktion() {
        return kontraktion;
    }
    public double getWasserP() {
        return wasserP;
    }
    public void setWasserP(double wasserP) {
        this.wasserP = wasserP;
    }
    public double getWasserT() {
        return wasserT;
    }

    public double getGesamtLitergewicht() {
        return gesamtLitergewicht;
    }


    public double getGesamtTrockenmasse() {
        return gesamtTrockenmasse;
    }

    public double getGesamtExtrakt() {
        return gesamtExtrakt;
    }

    public double getSummeTrockenMasse() {
        return summeTrockenMasse;
    }

    public double getExtraktMassenProzent() {
        return extraktMassenProzent;
    }

    public CurrencyItem getWaehrung() {
        return waehrung;
    }
    public void setWaehrung(CurrencyItem waehrung) {
        this.waehrung = waehrung;
    }

    public BigDecimal getSummeKalkulation() {
        return summeKalkulation;
    }


    public BigDecimal getKgMitSteuer() {
        return kgMitSteuer;
    }
    public BigDecimal getKgOhneSteuer() {
        return kgOhneSteuer;
    }
    public BigDecimal getLaMitSteuer() {
        return laMitSteuer;
    }
    public BigDecimal getLaOhneSteuer() {
        return laOhneSteuer;
    }
    public BigDecimal getLiterMitSteuer() {
        return literMitSteuer;
    }
    public BigDecimal getLiterOhneSteuer() {
        return literOhneSteuer;
    }
    public BigDecimal getSteuer() {
        return steuer;
    }
    public BigDecimal getSummeMitSteuer() {
        return summeMitSteuer;
    }
    public BigDecimal getSummeOhneSteuer() {
        return summeOhneSteuer;
    }
    public BigDecimal getVerschnittwasserPreis() {
        return verschnittwasserPreis;
    }

	public boolean isPreisWarnung() {
		return preisWarnung;
	}

	public double getOriginalLitergewicht() {
		return originalLitergewicht;
	}

	public void setOriginalLitergewicht(double originalLitergewicht) {
		this.originalLitergewicht = originalLitergewicht;
	}

	public double getOriginalExtrakt() {
		return originalExtrakt;
	}
	public void setOriginalExtrakt(double originalExtrakt) {
		this.originalExtrakt = originalExtrakt;
	}

	public double getOriginalAcid() {
		return originalAcid;
	}
	public void setOriginalAcid(double originalAcid) {
		this.originalAcid = originalAcid;
	}
	public CurrencyItem getEuro() {
		return euro;
	}

	/**
	 *
	 * @return Brennwert
	 */
	public double getSummeBrennwert() {
		return summeBrennwert;
	}

	/**
	 *
	 * @return Brennwert in kj/100ml
	 */
	public double getBrennwert() {
		return  summeBrennwert / (gesamtLiter * 10);
	}
	public double getBrennwertG() {
		return  summeBrennwert / (gesamtKg * 10);
	}
	
	public double getSummeBrennwertA() {
		return summeBrennwertA;
	}
	
	public double getSummeBrennwertAF() {
		return summeBrennwertAF;
	}
	
	public double getSummeAcid() {
		return summeAcid;
	}
	public double getGesamtAcid() {
		return gesamtAcid;
	}
    public boolean isBuchungsWarnung() {
        return buchungsWarnung;
    }
	public String getSteuerGrundpreis() {
		return steuerGrundpreis;
	}
	public String getWasserGrundpreis() {
		return wasserGrundpreis;
	}

	public double getAlkoholGramm() {
		double ret = 0.0;
		if(staerke != 0) {
			final double literPerKg = 1/ this.getGesamtLitergewicht();
			final double menge = literPerKg * (this.getStaerke()/100);
			ret = menge * rz.getTafelFactory().Litergewicht(100) * 1000;
		} else {
			ret = 0.0;
		}
		return ret;
	}
	
	public double getAlkoholGrammPerLiter() {
		double ret = 0.0;
		if(staerke != 0) {
			double grammAlkPerKg= this.getAlkoholGramm();
			ret = grammAlkPerKg * (this.getGesamtLitergewicht());
		} else {
			ret = 0.0;
		}
		return ret;
	}
	
	
	public double getAlkoholGrammExtraktfrei() {
		double ret = 0.0;
		if(staerke != 0) {
			ret = staerke * rz.getTafelFactory().rhoAlk;
		} else {
			ret = 0.0;
		}
		return ret;
	}
	
	
	public DeklarationsListe getDeklarationenOriginal() {
		return deklarationenOriginal;
	}
	public void setDeklarationenOriginal(DeklarationsListe deklarationen) {
		this.deklarationenOriginal = deklarationen;
	}
	public DeklarationsListe getDeklarationenAlle() {
		return deklarationenAlle;
	}
	public void setDeklarationenAlle(DeklarationsListe deklarationenAlle) {
		this.deklarationenAlle = deklarationenAlle;
	}
	public AcidItem getAcidDest() {
		return acidDest;
	}
	public void setAcidName(AcidItem acidName) {
		this.acidDest = acidName;
	}
	public double getAcidOther() {
		return acidOther;
	}
	public void setAcidOther(double acidOther) {
		this.acidOther = acidOther;
	}

	public AusstattungsItem getAusstattung() {return ausstattung;}

	public void setAusstattung(AusstattungsItem ai) {
		ausstattung = ai;
		if (ai != null) {
			ausstattung.rechnen(this.getGesamtLiter(),this.getWaehrung());
		}
	}
	public boolean isSpezifikationTextDrucken() {
		return spezifikationTextDrucken;
	}
	public void setSpezifikationTextDrucken(boolean spezifikationTextDrucken) {
		this.spezifikationTextDrucken = spezifikationTextDrucken;
	}
	
	public boolean isDuplex() {
		return duplex;
	}
	public void setDuplex(boolean duplex) {
		this.duplex=duplex;
	}
	
}
