/*
 *  Copyright (C)  Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.paletten;

public class PalettenItem {
	int						id;
	String					bezeichnung;
	double					inhalt;
	int						flaschen_per_karton;
	int						karton_per_palette;

	public PalettenItem(int id, String bezeichnung, double inhalt, int flaschen_per_karton, int karton_per_palette) {
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.inhalt = inhalt;
		this.flaschen_per_karton = flaschen_per_karton;
		this.karton_per_palette = karton_per_palette;
	}

	public PalettenItem() {
		this.id=0;
		this.bezeichnung="?";
		this.inhalt=1.0;
		this.flaschen_per_karton=6;
		this.karton_per_palette=1;
	}


	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public int getFlaschen_per_karton() {
		return flaschen_per_karton;
	}

	public void setFlaschen_per_karton(int flaschen_per_karton) {
		this.flaschen_per_karton = flaschen_per_karton;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public double getInhalt() {
		return inhalt;
	}

	public void setInhalt(double inhalt) {
		this.inhalt = inhalt;
	}

	public int getKarton_per_palette() {
		return karton_per_palette;
	}

	public void setKarton_per_palette(int karton_per_palette) {
		this.karton_per_palette = karton_per_palette;
	}

	@Override
	public String toString() {
		return bezeichnung;
	}

}
