package de.lunqual.rzpro.items.mischungen;

import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class TransaktionsItem {

	public static final int		TYP_NONE = 0;
	public static final int		TYP_TEILABSCHLUSS=1;
	
	RzPro				rz;
	int					id;
	int					typ;
	String				bemerkungen;
	int					mischung_source;
	int					mischung_dest;
	String				tank_source;
	String				tank_dest;
	Date				erstellt;
	String				user;
	TicketListe		tickets;
	int					currentMischung;
	

	
	public TransaktionsItem(RzPro rz, int typ,String bezeichnung,String tank_source,String tank_dest, int mischung_source,int mischung_dest,TicketListe tickets,int currentMischung) {
		this.rz = rz;
		this.id = 0;
		this.typ = typ;
		this.bemerkungen = bezeichnung;
		this.mischung_source = mischung_source;
		this.mischung_dest = mischung_dest;
		this.tank_source = tank_source;
		this.tank_dest = tank_dest;
		this.erstellt = rz.getDatabase().getServerTimestamp();
		this.user = rz.getDatabase().dbGetUser();
		this.tickets = tickets;
		this.currentMischung=currentMischung;
	}
	
	
	public TransaktionsItem(RzPro rz, int id, int typ,String bezeichnung,String tank,String tank_dest, int mischung_source,int mischung_dest,Date erstellt,String user,int currentMischung) {
		this.rz = rz;
		this.id = id;
		this.typ = typ;
		this.bemerkungen = bezeichnung;
		this.mischung_source = mischung_source;
		this.mischung_dest = mischung_dest;
		this.tank_source = tank;
		this.tank_dest = tank_dest;
		this.erstellt = erstellt;
		this.user = user;
		this.currentMischung=currentMischung;
		this.tickets = rz.getDatabase().getMischungen().getTickets(id,currentMischung);
	}

	
	public TicketListe getTickets() {
		return tickets;
		
	}
	
	public String getTank() {
		return tank_source;
	}

	public void setTank(String tank) {
		this.tank_source = tank;
	}

	public String getTank_dest() {
		return tank_dest;
	}

	public void setTank_dest(String tank_dest) {
		this.tank_dest = tank_dest;
	}

	public int getTyp() {
		return typ;
	}

	public void setTyp(int typ) {
		this.typ = typ;
	}

	public void setTickets(TicketListe tickets) {
		this.tickets = tickets;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getBemerkungen() {
		return bemerkungen;
	}

	public void setBemerkungen(String bemerkungen) {
		this.bemerkungen = bemerkungen;
	}


	public int getMischung_source() {
		return mischung_source;
	}

	public void setMischung_source(int mischung_source) {
		this.mischung_source = mischung_source;
	}

	public int getMischung_dest() {
		return mischung_dest;
	}

	public void setMischung_dest(int mischung_dest) {
		this.mischung_dest = mischung_dest;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	
}
