package de.lunqual.rzpro.items.mischungen;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.HashMap;
import java.util.Map;

import de.lunqual.rzpro.RzPro;

public class TicketListe extends ArrayList<TicketItem> {

	RzPro	rz;
	Comparator 				compNummer;
	Comparator				compAktion;
	Comparator				compTyp;
	Comparator				compBezeichnung;
	Comparator				compLA;
	Comparator				compAnteil;
	Comparator				compUser;
	Comparator				compStaerke;
	Collator						coll;
	
	boolean						reverseNummer = false;
	boolean						reverseTyp = false;
	boolean						reverseAktion = false;
	boolean						reverseBezeichnung = false;
	boolean						reverseLA = false;
	boolean						reverseAnteil = false;
	boolean						reverseUser = false;
	boolean						reverseStaerke = false;
	
	public static final int	MAX_VALUE_LISTE = 20;
	
	public TicketListe(RzPro rz) {
		super();
		this.rz  = rz;
		coll = Collator.getInstance(Locale.getDefault());
		compNummer = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				try {
					if(Integer.valueOf(b1.getNummer()).equals(Integer.valueOf(b2.getNummer()))) {
						r = 0;
					} else {
						if (Integer.valueOf(b1.getNummer()) >  Integer.valueOf(b2.getNummer())) {
							r = 1;
						} else {
							r = -1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		compAktion = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				try {
					if(b1.getTransaktion() ==  b2.getTransaktion()) {
						r = 0;
					} else {
						if (b1.getTransaktion() > b2.getTransaktion()) {
							r = 1;
						} else {
							r = -1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		
		compTyp = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				try {
					if(b1.getTyp() ==  b2.getTyp()) {
						r = 0;
					} else {
						if (b1.getTyp() > b2.getTyp()) {
							r = 1;
						} else {
							r = -1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		compBezeichnung = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				return coll.compare(b1.getBezeichnung(), b2.getBezeichnung());
			}
		};
		compLA = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				try {
					if(b1.getLa() ==  b2.getLa()) {
						r = 0;
					} else {
						if (b1.getLa() > b2.getLa()) {
							r = 1;
						} else {
							r = -1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		compAnteil = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				try {
					if(b1.getPercentage() ==  b2.getPercentage()) {
						r = 0;
					} else {
						if (b1.getPercentage() > b2.getPercentage()) {
							r = 1;
						} else {
							r = -1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		
		compUser = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				return coll.compare(b1.getErstellt_user(), b2.getErstellt_user());
			}
		};
		
		compStaerke = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final TicketItem b1 = (TicketItem) o1;
				final TicketItem b2 = (TicketItem) o2;
				try {
					if(b1.getStaerke() ==  b2.getStaerke()) {
						r = 0;
					} else {
						if (b1.getStaerke() > b2.getStaerke()) {
							r = 1;
						} else {
							r = -1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		
	}

	public void sortNummer() {
		if(reverseNummer) {
			Collections.sort(this,compNummer);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compNummer);
		}
		reverseNummer = !reverseNummer;
	}

	public void sortAktion() {
		if(reverseAktion) {
			Collections.sort(this,compAktion);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compAktion);
		}
		reverseAktion = !reverseAktion;
	}
	public void sortTyp() {
		if(reverseTyp) {
			Collections.sort(this,compTyp);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compTyp);
		}
		reverseTyp = !reverseTyp;
	}

	public void sortBezeichnung() {
		if(reverseBezeichnung) {
			Collections.sort(this,compBezeichnung);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compBezeichnung);
		}
		reverseBezeichnung = !reverseBezeichnung;
	}
	
	public void sortLA() {
		if(reverseLA) {
			Collections.sort(this,compLA);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compLA);
		}
		reverseLA = !reverseLA;
	}
	
	public void sortAnteil() {
		if(reverseAnteil) {
			Collections.sort(this,compAnteil);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compAnteil);
		}
		reverseAnteil = !reverseAnteil;
	}
	public void sortUser() {
		if(reverseUser) {
			Collections.sort(this,compUser);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compUser);
		}
		reverseUser = !reverseUser;
	}
	
	public void sortStaerke() {
		if(reverseStaerke) {
			Collections.sort(this,compStaerke);
			Collections.reverse(this);
		} else {
			Collections.sort(this,compStaerke);
		}
		reverseStaerke = !reverseStaerke;
	}

	public String toHTMLString() {
		String ret ="";
		int n = 0;
		int v = 0;
		for(TicketItem ti:this) {
			if(n <= rz.getOptionFactory().getOption("ticketliste.delete_html_max_value",MAX_VALUE_LISTE)) {
				ret += ti.getBezeichnung() + "<br>";	
				v++;
			}
			n++;
		}
		if(v < n) {
			ret +="<br>" + rz.getLocale().getString("ticketliste.delete_weitere").replaceAll("%v", String.valueOf(n-v));
		}
		return ret;
	}
	
	public String getWarenTicketsString() {
		String ret  = "";
		for(TicketItem ti:this) {
			if(ti.getTyp() == TicketItem.TYP_WARE) {
				ret += ti.getNummer() + ",";
			}
		}
		if(ret.endsWith(","))ret = ret.substring(0,ret.length()-1);
		return ret;
	}
	
	public void getMinus(TicketListe original) {
		for(TicketItem ti:this) {
			if(ti.getTyp() == TicketItem.TYP_WARE) {
				for(TicketItem ti1:original) {
					if(ti1.getTyp() == TicketItem.TYP_ENTNAHME && ti.getNummer().equals(ti1.getNummer())) {
						ti.addLa_minus(ti1.getLa());
					}
				}
			}
		}
	}
	
	public boolean containsUmpumpen() {
		for(TicketItem ti:this) {
			if(ti.getTyp() == TicketItem.TYP_UMPUMPEN) {
				return true;
			}
		}
		return false;
	}
	
	public TicketItem getAbschlussTicket() {
		for(TicketItem ti:this) {
			if(ti.getTyp() == TicketItem.TYP_ABSCHLUSS) {
				return ti;
			}
		}
		return null;
	}
	
	public String getTicketNummernString() {
		String ret = "";
		for(TicketItem ti:this) {
			ret += ti.getNummer()+",";
		}
		if(ret.endsWith(","))ret = ret.substring(0, ret.length()-1);
		return ret;
		
	}
	
	public TicketListe getMinusWarenTickets() {
		Date datum = new Date();
		TicketListe ret = new TicketListe(rz);
		HashMap<String,TicketItem> map = new HashMap<String,TicketItem>();
		for (TicketItem ti:this) {
			if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
				if(map.containsKey(ti.getNummer())) {
					// ticket schon in der Liste
					double la =	map.get(ti.getNummer()).getLa();
					map.get(ti.getNummer()).setLa(la+ti.getLa());
				} else {
					map.put(ti.getNummer(), ti.clones());
				}
			}
		}
		for (Map.Entry<String, TicketItem> entry : map.entrySet())
		{
			TicketItem ti  = entry.getValue();
			ti.setTyp(TicketItem.TYP_ENTNAHME);
			if(ti.getLa()>0)ti.setLa(-ti.getLa());
			ti.setGeaendert_user(rz.getDatabase().dbGetUser());
			ti.setGeaendert(datum);
			ret.add(ti);
		}
		return ret;
	}
	
	public void setEntsperrtStatus() {
		for(TicketItem ti:this) {
			if(ti.getTyp()==TicketItem.TYP_GESPERRT) {
				setEntsperrt(ti);
			}
		}
	}
	
	private void setEntsperrt(TicketItem ti) {
		ti.setEntsperrt(false);
		for(TicketItem ti1:this) {
			if(ti1.getTyp() == TicketItem.TYP_ENTSPERRT && ti1.getBezeichnung().contains(ti.getNummer())) {
				ti.setEntsperrt(true);
				break;
			}
		}
	}
	
	public double getSumme() {
		double ret = 0.0;
		for (TicketItem ti:this) {
			if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
				ret += ti.getLa();
			}
		}
		return ret;
	}
}
