package de.lunqual.rzpro.items.mischungen;

import javax.swing.Icon;

import de.lunqual.rzpro.RzPro;

public class TicketAuswahlItem {
	RzPro			rz;
	int				typ;
	int				mischung;
	String			mischungBezeichnung;
	String			nummer;
	String			bezeichnung;
	Icon			icon;
	
	public TicketAuswahlItem(RzPro rz,int mischung, String mischungBezeichnung,int typ, String nummer,	String bezeichnung) {
		super();
		this.rz = rz;
		this.mischung=mischung;
		this.mischungBezeichnung=mischungBezeichnung;
		this.typ = typ;
		this.nummer = nummer;
		this.bezeichnung = bezeichnung;
		this.icon = rz.getDatabase().getMischungen().getIcon(typ);
	}

	public TicketAuswahlItem clones() {
		return new  TicketAuswahlItem(rz, mischung,mischungBezeichnung,typ, nummer,	bezeichnung);
	}
	public RzPro getRz() {
		return rz;
	}

	public int getTyp() {
		return typ;
	}

	public String getNummer() {
		return nummer;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public Icon getIcon() {
		return icon;
	}
	
	public int getMischung() {
		return mischung;
	}

	public String toString() {
		return rz.getLocale().getString("ticketauswahlitem.mischung")
				.replaceAll("%t", nummer)
				.replaceAll("%s", bezeichnung)
				.replaceAll("%n", String.valueOf(mischung))
				.replaceAll("%b",mischungBezeichnung); 
	}
	
	public String getSaveString() {
		return rz.getLocale().getString("dbdm.ticketmuster").replaceAll("%t", nummer).replaceAll("%m", String.valueOf(mischung));
	}
}
