package de.lunqual.rzpro.items.mischungen;


import de.lunqual.rzpro.RzPro;

public class SortenItem {
	RzPro		rz;
	int			id;
	boolean		system;
	String		bezeichnung;
	String		regeln;
	SortenRegelListe 	liste;
	
	public SortenItem(RzPro rz,int id, boolean system, String bezeichnung,String regeln) {
		this.rz = rz;
		this.id = id;
		this.system = system;
		this.bezeichnung = bezeichnung;
		this.regeln = regeln;
		liste = rz.getDatabase().getMischungen().getSortenRegelListe(id);
		setupRegelListe();
	}

	private void setupRegelListe() {
		liste.setIDs(regeln);
		for(SortenRegelItem si:liste) {
			if(si.isSystem() || si.getSorte() == id) {
				si.setSelected(true);
			}
		}
	}
	
//	public SortenItem clone() {
//		return new SortenItem(rz,id,system,bezeichnung,regeln);
//	}
	public SortenRegelListe getListe(){
		return liste;
	}
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public boolean isSystem() {
		return system;
	}

	public void setSystem(boolean system) {
		this.system = system;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public String getRegeln() {
		return regeln;
	}

	public void setRegeln(String regeln) {
		this.regeln = regeln;
	}
	
	
	public String toString() {
		return bezeichnung;
	}
	
}
