package de.lunqual.rzpro.items.mischungen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Map.Entry;

import de.lunqual.rzpro.RzPro;

public class MischungsVItem {
	RzPro																						rz;
	HashMap<Integer,MischungsItem>								mischungen;
	SortedMap<Integer,MischungVEbenenItem>				ebenen; 
	MischungsItem																	mi;

	public MischungsVItem(RzPro rz,MischungsItem mi) {
		super();
		this.rz = rz;
		mischungen = new HashMap<Integer,MischungsItem>();
		ebenen = new TreeMap<Integer, MischungVEbenenItem>();
		this.mi = mi;
		addMischung(0,mi);
		normalisieren();
	}
	
	private void normalisieren() {
		int n = 0;
		SortedMap<Integer,MischungVEbenenItem> ebenen1 = new TreeMap<Integer, MischungVEbenenItem>();
		for (Entry<Integer,MischungVEbenenItem> entry : ebenen.entrySet()) {
			ebenen1.put(n, entry.getValue());
			n++;
		}
		ebenen = ebenen1;
	}
	
	private void addMischung(int ebene,MischungsItem mi) {
		if(!mischungen.containsKey(mi.getHeader().getId())) {
			mischungen.put(mi.getHeader().getId(), mi);
			if(!ebenen.containsKey(ebene)){
				ebenen.put(ebene, new MischungVEbenenItem(ebene));
			} 
			ebenen.get(ebene).addMischung(mi);
			ArrayList <Integer> predecessorListe = mi.getPredecessorListe();
			ArrayList<Integer> successorListe = mi.getSucessorListe();
			for(Integer i:predecessorListe) {
				addMischung(ebene -1,rz.getDatabase().getMischungen().getMischung(i));
			}
			for(Integer i:successorListe) {
				addMischung(ebene  +1,rz.getDatabase().getMischungen().getMischung(i));
			}
		}
	}
	
	public MischungsItem getMischung() {
		return mi;
	}
	
	public int getEbenenSize() {
		return ebenen.size();
	}
	
	public int getMaxCount() {
		int count = 0;
		for(int i=0;i < ebenen.size();i++) {
			if(getEbene(i).getMischungen().size() > count)count = getEbene(i).getMischungen().size();
		}
		return count;
	}
	
	public MischungVEbenenItem getEbene(int ebene) {
		return ebenen.get(ebene);
	}

	public ArrayList<MischungsItem> getMischungsListe(){
		ArrayList<MischungsItem> ret = new ArrayList<MischungsItem>();
		for(int i=0;i < ebenen.size();i++) {
			MischungVEbenenItem mvi = getEbene(i);
			if(mvi != null && mvi.getMischungen().size() > 0) {
				for(MischungsItem mi:mvi.getMischungen()) {
					ret.add(mi);
				}
			}
		}
		return ret;
	}
}
