package de.lunqual.rzpro.items.mischungen;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import de.lunqual.rzpro.RzPro;

public class MischungsItem {

	RzPro				rz;
	int					mischung;
	Transaktionsliste	transaktionen;
	MischungsHeaderItem header;
	SimpleDateFormat	df;
	
	public MischungsItem(RzPro rz,int mischung) {
		this.rz = rz;
		df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
		if(mischung == 0) {
			header = new MischungsHeaderItem(rz);
		}else {
			header = rz.getDatabase().getMischungen().getMischungHeader(mischung);			
		}
		transaktionen = rz.getDatabase().getMischungen().getTransaktionen(mischung);
		setPercentages();
	}

	public void reload() {
		if(mischung != 0) {
			transaktionen = rz.getDatabase().getMischungen().getTransaktionen(mischung);
			setPercentages();
		}
	}
	
	private void getTickets() {
		
	}

	private void setPercentages() {
		TicketListe liste = getAllTickets();
		double summe =0;
		for(TicketItem ti:liste) {
			if(ti.getTyp()==TicketItem.TYP_WARE || ti.getTyp()==TicketItem.TYP_ENTNAHME) {
				summe += ti.getLa();
			}
		}
		for(TicketItem ti:liste) {
			if(ti.getTyp()==TicketItem.TYP_WARE) {
				try {
					double menge = getTicketMenge(liste,ti.getNummer());
					if(!rz.isZero(summe)) {
						ti.setPercentage(menge*100/summe);
					} else {
						ti.setPercentage(0);
					}
				}catch(Exception e) { 
				}
			}
		}
		setNegativePercentage(liste);
		
	}
	
	private double getTicketMenge(TicketListe liste,String nummer) {
		double ret = 0.0;
		for(TicketItem ti:liste) {
			if(ti.getNummer().equals(nummer)) {
				ret += ti.getLa();
			}
		}
		return ret;

	}
	
	private void setNegativePercentage(TicketListe liste) {
		double summe = 0;
		for(TicketItem ti:liste) {
			if( ti.getTyp()==TicketItem.TYP_ENTNAHME) {
				summe += ti.getLa();
			}
		}
		summe= java.lang.Math.abs(summe);
		for(TicketItem ti:liste) {
			if(ti.getTyp()==TicketItem.TYP_ENTNAHME) {
					double menge = java.lang.Math.abs(ti.getLa());
					if(!rz.isZero(summe)) {
						ti.setNegativePercentage(menge*100/summe);
					} else {
						ti.setNegativePercentage(0.0);
					}
			}
		}
	}
	
	public double getNegativeTicket(TicketListe liste,TicketItem ticket) {
		double ret = 0.0;
//		for(TicketItem ti:liste) {
//			if( ti.getTyp()==TicketItem.TYP_ENTNAHME && ti.getNummer().equals(nummer)) {
//				ret = ti.getNegativePercentage();
//			}
//		}
		double summe = 0.0;
		for(TicketItem ti:liste) {
			if( ti.getTyp()==TicketItem.TYP_WARE) {
				summe += ti.getLa();
			}
		}
		if(!rz.isZero(summe)) {
			ret = ticket.getLa()*100/summe;
		} else {
			ret = 0.0;
		}
		return ret;
	}
	
	public MischungsItem clones() {
		MischungsItem ret = new MischungsItem(rz,0);
		ret.setHeader(header.clones());
		ret.clearTransaktionsliste();
		ret.getHeader().setId(0);
		return ret;
	}
	
	public String getErstelltToString() {
		return df.format(header.getErstellt());
	}
	public String getGeaendertToString() {
		return df.format(header.getGeaendert());
	}
	public String getAbgeschlossenToString() {
		return df.format(header.getAbgeschlossen());
	}
	public void clearTransaktionsliste() {
		transaktionen.clear();
	}
	
	public Transaktionsliste getTransaktionen() {
		return transaktionen;
	}
	
	public MischungsHeaderItem getHeader() {
		return header;
	}

	public TicketListe getWarenTickets() {
		TicketListe tl = new TicketListe(rz);
		for(TransaktionsItem tri:transaktionen) {
			for(TicketItem ti:tri.getTickets()) {
				if(ti.getTyp() == TicketItem.TYP_WARE) {
					if(!isInList(tl,ti.getNummer())) {
						tl.add(ti);
					}
				}
			}
		}
		tl.setEntsperrtStatus();
		return tl;
	}
	
	public boolean isInList(TicketListe tl,String nummer ) {
		boolean ret = false;
		for(TicketItem ti:tl) {
			if(ti.getNummer().trim().equals(nummer.trim())){
				ret =true;
				break;
			}
		}
		return ret;
	}
	
	public TicketListe getAllTickets() {
		TicketListe tl = new TicketListe(rz);
		for(TransaktionsItem tri:transaktionen) {
			for(TicketItem ti:tri.getTickets()) {
				tl.add(ti);
			}
		}
		tl.setEntsperrtStatus();
		return tl;
	}
	
	public boolean hasWarenTickets() {
		boolean ret = false;
		for(TicketItem ti:this.getAllTickets()) {
			if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
				ret = true;
				break;
			}
		}
		return ret;
	}
	
	/*
	 * umpumpTicketListe ist die Liste aller Text/Sperr/Entsperr/Freigabe usw.
	 * Tickets ohne die Waren/UmpumpTickets tickes;
	 */
	public TicketListe getUmpumpTicketListe(){
		Date now = rz.getDatabase().getServerTimestamp();
		TicketListe ret = new TicketListe(rz);
		TicketListe original = getAllTickets();
		HashMap<String,TicketItem> map = new HashMap<String,TicketItem>(); 
		for(TicketItem ti:original) {
			if(ti.getTyp() == TicketItem.TYP_ENTSPERRT ||
			   ti.getTyp() == TicketItem.TYP_FREIGABE ||
			   ti.getTyp() == TicketItem.TYP_FREIGABE_AUFHEBEN ||
			   ti.getTyp() == TicketItem.TYP_GESPERRT ||
			   ti.getTyp() == TicketItem.TYP_TEXT
			) {
				if(!map.containsKey(ti.getNummer())){
					TicketItem r = ti.clones();
					map.put(ti.getNummer(), ti);
					r.setGeaendert(now);
					r.setGeaendert_user(rz.getDatabase().dbGetUser());
					ret.add(r);
				}
			}
				
		}
		return ret;
	}
	/*
	 * Abschlussticketliste ist die liste der Warentickets
	 * mit den Restmengen
	 */
	public TicketListe getAbschlussTicketListe() {
		return getAllTickets().getMinusWarenTickets();
	}
	/**
	 * Freigabe-Status der Mischung
	 * @return true, wenn freigegeben
	 * freigegeben ist eine mischung wenn:
	 * 1. Die Zahl der Freigabetickets höher ist als die der Freigabe-Aufhebungen
	 * 2. Die Zahl der Sperren mindestens so gross ist wie die der Entsperrungen
	 * 3. mindestens eine Freigabe enthalten ist
	 */
	public MischungsFreigabeItem getFreigabeItem() {
		MischungsFreigabeItem ret = new MischungsFreigabeItem();
		TicketListe liste = new TicketListe(rz);
		for(TransaktionsItem tri:transaktionen) {
			for(TicketItem ti:tri.getTickets()) {
				liste.add(ti);
			}
		}
		for(TicketItem ti:liste) {
			switch(ti.getTyp()) {
				case TicketItem.TYP_GESPERRT:ret.addSperre();break;
				case TicketItem.TYP_ENTSPERRT:
					int n=1;
					for(TicketItem ti1:liste) {
						if(ti1 != ti && ti1.getTyp() == TicketItem.TYP_GESPERRT && ti.getBezeichnung().contains(ti1.getNummer())) {
							n++;
						}
					}
					ret.addEntsperren(n>1?n-1:n);
					break;
				case TicketItem.TYP_FREIGABE:ret.addFreigabe();break;
				case TicketItem.TYP_FREIGABE_AUFHEBEN:ret.addFreigaben_aufgehoben();break;
				case TicketItem.TYP_WARE:ret.addWarenticket();break;
			}
		}
		return ret;
	}
	
	public double getLA() {
		double la = 0;
		for(TicketItem ti:getAllTickets()) {
			if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
				la += ti.getLa();
			}
		}
		return rz.isZero(la)?0.0:la;
	}
	
	public double getProzentVol() {
		double ret = 0;
		double la =0;
		double liter = 0;
		for(TicketItem ti:getAllTickets()) {
			if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
				try {
					la += ti.getLa();
					liter += (ti.getLa()/ti.getStaerke()) * 100;
				}catch(Exception e) {}
			}
		}
		ret = liter != 0?(la*100)/liter:0;
		return ret;
	}
	public void setHeader(MischungsHeaderItem h) {
		this.header = h;
	}
	
	public ArrayList<Integer > getPredecessorListe() {
		ArrayList<Integer> ret = new ArrayList<Integer>();
		for(TransaktionsItem tri:this.getTransaktionen()) {
			if(tri.getMischung_source() != this.getHeader().getId() && tri.getMischung_dest() == this.getHeader().getId()) {
				ret.add(tri.getMischung_source());
			} 
		}
		return ret;
	}
	
	public ArrayList<Integer > getSucessorListe() {
		ArrayList<Integer> ret = new ArrayList<Integer>();
		for(TransaktionsItem tri:this.getTransaktionen()) {
			if(tri.getMischung_source() == this.getHeader().getId() && tri.getMischung_dest() != this.getHeader().getId()) {
				ret.add(tri.getMischung_dest());
			} 
		}
		return ret;
	}
	
	public boolean isPredecessor(MischungsItem mi) {
		ArrayList<Integer> liste = getPredecessorListe();
		for(int i:liste) {
			if(i == mi.getHeader().getId()) {
				return true;
			}
		}
		return false;
	}
	
	public String toString() {
		return String.valueOf(header.getId())+": " + header.getBezeichnung();
	}
}
