package de.lunqual.rzpro.items.mischungen;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

import de.lunqual.rzpro.RzPro;

public class MischungsHeaderListe extends ArrayList{
	
	RzPro 					rz;
	Collator 				coll;
	Comparator 				compID;
	Comparator				compBezeichnung;
	Comparator				compTank;
	Comparator				compErstellt;
	Comparator				compGeaendert;
	Comparator				compSorte;
	
	boolean					reverseID = true;
	boolean					reverseBezeichnung = true;
	boolean					reverseTank = true;
	boolean					reverseErstellt = true;
	boolean					reverseGeaendert = true;
	boolean					reverseSorte = true;
	
	public MischungsHeaderListe(RzPro rz) {
		super();
		this.rz = rz;
		coll = Collator.getInstance(Locale.getDefault());
		compID = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final MischungsHeaderItem b1 = (MischungsHeaderItem) o1;
				final MischungsHeaderItem b2 = (MischungsHeaderItem) o2;
				try {
					if(b1.getId() == b2.getId()) {
						r = 0;
					} else {
						if (b1.getId() > b2.getId()) {
							r = -1;
						} else {
							r = 1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		
		compBezeichnung = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final MischungsHeaderItem b1 = (MischungsHeaderItem) o1;
				final MischungsHeaderItem b2 = (MischungsHeaderItem) o2;
				return coll.compare(b1.getBezeichnung(), b2.getBezeichnung());
			}
		};
		
		compTank = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final MischungsHeaderItem b1 = (MischungsHeaderItem) o1;
				final MischungsHeaderItem b2 = (MischungsHeaderItem) o2;
				return coll.compare(b1.getTank(), b2.getTank());
			}
		};
		
		compErstellt = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final MischungsHeaderItem b1 = (MischungsHeaderItem) o1;
				final MischungsHeaderItem b2 = (MischungsHeaderItem) o2;
				return b1.getErstellt().compareTo(b2.getErstellt());
			}
		};
		
		compGeaendert = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final MischungsHeaderItem b1 = (MischungsHeaderItem) o1;
				final MischungsHeaderItem b2 = (MischungsHeaderItem) o2;
				return b1.getGeaendert().compareTo(b2.getGeaendert());
			}
		};
		
		
		compSorte = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final MischungsHeaderItem b1 = (MischungsHeaderItem) o1;
				final MischungsHeaderItem b2 = (MischungsHeaderItem) o2;
				return coll.compare(b1.getSorte().getBezeichnung(), b2.getSorte().getBezeichnung());
			}
		};
	}
	
	public void addItem(MischungsHeaderItem mi) {
		this.add(mi);
	}
	
	public MischungsHeaderItem getItem(int i) {
		return (MischungsHeaderItem)this.get(i);
	}
	

	public void sortID() {
		if (reverseID) {
			Collections.sort(this, compID);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compID);
		}
		reverseID=!reverseID;
	}
	
	public void sortBezeichnung() {
		if (reverseBezeichnung) {
			Collections.sort(this, compBezeichnung);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBezeichnung);
		}
		reverseBezeichnung=!reverseBezeichnung;
	}
	

	public void sortTank() {
		if (reverseTank) {
			Collections.sort(this, compTank);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compTank);
		}
		reverseTank=!reverseTank;
	}

	public void sortErstellt() {
		if (reverseErstellt) {
			Collections.sort(this, compErstellt);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compErstellt);
		}
		reverseErstellt=!reverseErstellt;
	}
	
	public void sortGeaendert() {
		if (reverseGeaendert) {
			Collections.sort(this, compGeaendert);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compGeaendert);
		}
		reverseGeaendert=!reverseGeaendert;
	}
	
	public void sortSorteForward() {
		Collections.sort(this, compSorte);
	}

	
	public void sortSorte() {
		if (reverseSorte) {
			Collections.sort(this, compSorte);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compSorte);
		}
		reverseSorte=!reverseSorte;
	}
}
