package de.lunqual.rzpro.items.mischungen;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.stichworte.StichwortListe;

public class MischungsHeaderItem {
	RzPro 									rz;
	int										id;
	boolean									active;
	int										rezeptur_id;
	String									bezeichnung;
	String									tank;
	String									losnummer;
	SortenItem								sorte;
	double									la;
	String									comment;
	Date									erstellt;
	String									erstellt_user;
	Date									geaendert;
	String									geaendert_user;
	Date									abgeschlossen;
	String									abgeschlossen_user;
	SimpleDateFormat						df;
	StichwortListe							adressen;
	int										lager;
	
	
	
	public MischungsHeaderItem(RzPro rz, int id, boolean active, int rezeptur_id, String bezeichnung, String tank, String losnummer,int sorte, String comment, double la,Date erstellt, String erstellt_user, Date geaendert, String geaendert_user, Date abgeschlossen, String abgeschlossen_user,StichwortListe adressen,int lager) {
		df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
		this.rz = rz;
		this.id = id;
		this.active = active;
		this.rezeptur_id = rezeptur_id;
		this.bezeichnung = bezeichnung;
		this.tank = tank;
		this.losnummer=losnummer;
		this.sorte = rz.getDatabase().getMischungen().getSorte(sorte);
		this.comment = comment;
		this.la = la;
		this.erstellt = erstellt;
		this.erstellt_user = erstellt_user;
		this.geaendert = geaendert;
		this.geaendert_user = geaendert_user;
		this.abgeschlossen = abgeschlossen;
		this.abgeschlossen_user = abgeschlossen_user;
		this.adressen = adressen;
		this.lager = lager;
	}
	
	public MischungsHeaderItem(RzPro rz) {
		df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
		this.rz = rz;
		this.id = 0;
		this.active = true;
		this.rezeptur_id = 0;
		this.bezeichnung = "";
		this.tank = "";
		this.la = 0;
		this.losnummer="";
		this.sorte = rz.getDatabase().getMischungen().getSorte(0);
		this.comment = "";
		this.erstellt = rz.getDatabase().getServerTimestamp();
		this.erstellt_user = rz.getDatabase().dbGetUser();
		this.geaendert =rz.getDatabase().getServerTimestamp();
		this.geaendert_user = rz.getDatabase().dbGetUser();
		this.abgeschlossen = rz.getDatabase().getServerTimestamp();;
		this.abgeschlossen_user = rz.getDatabase().dbGetUser();
		this.adressen = new StichwortListe();
		this.lager = 0;
	}
	
	public MischungsHeaderItem clones() {
		return new MischungsHeaderItem
				(rz,
				id,
				active,
				rezeptur_id,
				bezeichnung,
				tank,
				losnummer,
				sorte.getId(),
				comment,
				la,
				erstellt,
				erstellt_user,
				geaendert,
				geaendert_user,
				abgeschlossen,
				abgeschlossen_user ,
				adressen,
				lager);
	}

	
	public int getLager() {
		return lager;
	}

	public void setLager(int lager) {
		this.lager = lager;
	}

	public StichwortListe getAdressen() {
		return adressen;
	}

	public void setAdressen(StichwortListe adressen) {
		this.adressen = adressen;
	}

	public String getLosnummer() {
		return losnummer;
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public void setSorte(SortenItem sorte) {
		this.sorte = sorte;
	}

	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public boolean isActive() {
		return active;
	}
	public void setActive(boolean active) {
		this.active = active;
	}
	public int getRezeptur_id() {
		return rezeptur_id;
	}
	public void setRezeptur_id(int rezeptur_id) {
		this.rezeptur_id = rezeptur_id;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public String getTank() {
		return tank;
	}
	public void setTank(String tank) {
		this.tank = tank;
	}
	public SortenItem getSorte() {
		return sorte;
	}
	public void setSorte(int sorte) {
		this.sorte = rz.getDatabase().getMischungen().getSorte(sorte);
	}
	public String getBemerkungen() {
		return comment;
	}
	public void setBemerkungen(String comment) {
		this.comment = comment;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public String getErstellt_user() {
		return erstellt_user;
	}
	public void setErstellt_user(String erstellt_user) {
		this.erstellt_user = erstellt_user;
	}
	public Date getGeaendert() {
		return geaendert;
	}
	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}
	public String getGeaendert_user() {
		return geaendert_user;
	}
	public void setGeaendert_user(String geaendert_user) {
		this.geaendert_user = geaendert_user;
	}
	public Date getAbgeschlossen() {
		return abgeschlossen;
	}
	public void setAbgeschlossen(Date abgeschlossen) {
		this.abgeschlossen = abgeschlossen;
	}
	public String getAbgeschlossen_user() {
		return abgeschlossen_user;
	}
	public void setAbgeschlossen_user(String abgeschlossen_user) {
		this.abgeschlossen_user = abgeschlossen_user;
	}
	
	public String toString() {
		return String.valueOf(id)+ " : " + bezeichnung;
	}

	public double getLa() {
		return la;
	}

	public void setLa(double la) {
		this.la = la;
	}
	public String getErstelltToString() {
		return df.format(erstellt);
	}
	public String getGeaendertToString() {
		return df.format(geaendert);
	}
	public String getAbgeschlossenToString() {
		if(active) {
			return df.format(abgeschlossen);
		} else {
			return "";
		}
	}
	
	
}
