package de.lunqual.rzpro.items.mischungen;

import java.util.ArrayList;

public class MischungsAbfrageListe extends ArrayList<MischungsAbfrageItem> {

	int anzahl;
	int zeiger = 0;

	public MischungsAbfrageListe(int anzahl) {
		super();
		this.anzahl = anzahl;
	}

	@Override
	public boolean add(MischungsAbfrageItem e) {
		boolean ret = false;
		if(this.size() < anzahl) {
			ret = super.add(e);
		} else {
			this.remove(0);
			ret = super.add(e);
		}
		zeiger = this.size()-1;
		return ret;
	}
	
	public void reset() {
		this.clear();
		zeiger=0;
	}
	
	public MischungsAbfrageItem getCurrent() {
		MischungsAbfrageItem ret = null;
		if(zeiger >= 0 && zeiger <= this.size()-1) {
			ret = this.get(zeiger);
		} 
		return ret;
	}
	
	public int getCurrentPointer() {
		return zeiger;
	}
	
	public String getZeigerStr() {
		return String.valueOf(zeiger+1)+"/"+String.valueOf(this.size());
	}
	
	public boolean isEnde() {
		return zeiger == this.size()-1?true:false;
	}
	
	public boolean isAnfang() {
		return zeiger == 0?true:false;
	}
	
	public void moveForward() {
		zeiger++;
		checkZeiger();
	}
	
	public void moveBack() {
		--zeiger;
		checkZeiger();
	}
	
	public void moveAnfang() {
		zeiger=0;
	}
	
	public void moveEnde() {
		zeiger = this.size()-1;
		checkZeiger();
	}
	
	public void setCurrent(int z) {
		zeiger = z;
		checkZeiger();
	}
	
	private void checkZeiger() {
		if(zeiger < 0)zeiger = 0;
		if(zeiger >= this.size())zeiger = this.size()-1;
	}

	
	
}
