package de.lunqual.rzpro.items.mischungen;

import java.util.Calendar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.stichworte.StichwortListe;

public class MischungsAbfrageItem {
	
	public static final int	DATE_NONE 		= 0;
	public static final int	DATE_ERSTELLT	= 1;
	public static final int	DATE_GEAENDERT	= 2;
	
	RzPro			rz;
	int 			id;
	int 			dateMode;
	int 			vonJahr;
	int				vonMonat;
	int				vonTag;
	int 			bisJahr;
	int				bisMonat;
	int				bisTag;	
	String			mischungNummer;
	String			mischungBezeichnung;
	String			tank;
	String			ticketNummer;
	boolean			active;
	String			losnummer;
	int				rezeptur;
	String			aktionen;
	StichwortListe	adressen;
	

	public MischungsAbfrageItem(RzPro rz, int dateMode, int vonJahr, int vonMonat, int vonTag, int bisJahr, int bisMonat, int bisTag, String mischungNummer, String mischungBezeichnung, String tank, String ticketNummer,boolean active,String losnummer,int rezeptur,String aktionen,StichwortListe adressen) {
		this.rz = rz;
		this.dateMode = dateMode;
		this.vonJahr = vonJahr;
		this.vonMonat = vonMonat;
		this.vonTag = vonTag;
		this.bisJahr = bisJahr;
		this.bisMonat = bisMonat;
		this.bisTag = bisTag;
		this.mischungNummer = mischungNummer;
		this.mischungBezeichnung = mischungBezeichnung;
		this.tank = tank;
		this.ticketNummer = ticketNummer;
		this.active=active;
		this.losnummer=losnummer;
		this.rezeptur=rezeptur;
		this.aktionen=aktionen;
		this.adressen = adressen;
	}

	public MischungsAbfrageItem(RzPro rz,int mischung) {
		Calendar now = Calendar.getInstance();
		this.rz = rz;
		this.dateMode = MischungsAbfrageItem.DATE_NONE;
		this.vonJahr = now.get(Calendar.YEAR);
		this.vonMonat = now.get(Calendar.MONTH);
		this.vonTag = now.get(Calendar.DAY_OF_MONTH);
   		this.bisJahr = now.get(Calendar.YEAR);
		this.bisMonat =now.get(Calendar.MONTH);
		this.bisTag = now.get(Calendar.DAY_OF_MONTH);
		this.mischungNummer = String.valueOf(mischung);
		this.mischungBezeichnung = "";
		this.tank = "";
		this.ticketNummer = "";
		this.active=true;
		this.losnummer="";
		this.rezeptur=0;
		this.aktionen = "";
		this.adressen=new StichwortListe();
	}
	
	public MischungsAbfrageItem(RzPro rz,String mischungen) {
		Calendar now = Calendar.getInstance();
		this.rz = rz;
		this.dateMode = MischungsAbfrageItem.DATE_NONE;
		this.vonJahr = now.get(Calendar.YEAR);
		this.vonMonat = now.get(Calendar.MONTH);
		this.vonTag = now.get(Calendar.DAY_OF_MONTH);
   		this.bisJahr = now.get(Calendar.YEAR);
		this.bisMonat =now.get(Calendar.MONTH);
		this.bisTag = now.get(Calendar.DAY_OF_MONTH);
		this.mischungNummer = mischungen;
		this.mischungBezeichnung = "";
		this.tank = "";
		this.ticketNummer = "";
		this.active=false;
		this.losnummer="";
		this.rezeptur=0;
		this.aktionen = "";
		this.adressen=new StichwortListe();
	}
	
//	public MischungsAbfrageItem(RzPro rz) {
//		Calendar now = Calendar.getInstance();
//		this.rz = rz;
//		this.dateMode = rz.getOptionFactory().getOption("mischung.abfrage.mode",MischungsAbfrageItem.DATE_NONE);
//		this.vonJahr = rz.getOptionFactory().getOption("mischung.abfrage.von_jahr",now.get(Calendar.YEAR));
//		this.vonMonat = rz.getOptionFactory().getOption("mischung.abfrage.von_monat",now.get(Calendar.MONTH));
//		this.vonTag = rz.getOptionFactory().getOption("mischung.abfrage.von_tag",now.get(Calendar.DAY_OF_MONTH));
//   		this.bisJahr = rz.getOptionFactory().getOption("mischung.abfrage.bis_jahr",now.get(Calendar.YEAR));
//		this.bisMonat = rz.getOptionFactory().getOption("mischung.abfrage.bis_monat",now.get(Calendar.MONTH));
//		this.bisTag = rz.getOptionFactory().getOption("mischung.abfrage.bis_tag",now.get(Calendar.DAY_OF_MONTH));
//		this.mischungNummer = rz.getOptionFactory().getOption("mischung.abfrage.mischungsnummer");
//		this.mischungBezeichnung = rz.getOptionFactory().getOption("mischung.abfrage.mischungsbezeichnung");
//		this.tank = rz.getOptionFactory().getOption("mischung.abfrage.tank");
//		this.ticketNummer = rz.getOptionFactory().getOption("mischung.abfrage.ticketnummer");
//		this.active = rz.getOptionFactory().getOption("mischung.abfrage.active",1)==1?true:false;
//		this.losnummer = rz.getOptionFactory().getOption("mischung.abfrage.losnummer");
//		this.rezeptur=0;
//	}
	
//	public MischungsAbfrageItem clone() {
//		return new MischungsAbfrageItem(
//				rz,
//				dateMode,
//				vonJahr,vonMonat,vonTag,
//				bisJahr,bisMonat,bisTag,
//				mischungNummer,
//				mischungBezeichnung,
//				tank,
//				ticketNummer,
//				active,
//				losnummer,
//				rezeptur,
//				aktionen,
//				adressen
//				);
//	}
	
	
	public StichwortListe getAdressen() {
		return adressen;
	}

	public void setAdressen(StichwortListe adressen) {
		this.adressen = adressen;
	}

	public String getAktionen() {
		return aktionen;
	}

	public void setAktionen(String aktionen) {
		this.aktionen = aktionen;
	}

	public int getRezeptur() {
		return rezeptur;
	}

	public void setRezeptur(int rezeptur) {
		this.rezeptur = rezeptur;
	}

	public String getLosnummer() {
		return losnummer;
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getDateMode() {
		return dateMode;
	}

	public void setDateMode(int dateMode) {
		this.dateMode = dateMode;
	}

	
	public int getVonJahr() {
		return vonJahr;
	}

	public void setVonJahr(int vonJahr) {
		this.vonJahr = vonJahr;
	}

	public int getVonMonat() {
		return vonMonat;
	}

	public void setVonMonat(int vonMonat) {
		this.vonMonat = vonMonat;
	}

	public int getVonTag() {
		return vonTag;
	}

	public void setVonTag(int vonTag) {
		this.vonTag = vonTag;
	}

	public int getBisJahr() {
		return bisJahr;
	}

	public void setBisJahr(int bisJahr) {
		this.bisJahr = bisJahr;
	}

	public int getBisMonat() {
		return bisMonat;
	}

	public void setBisMonat(int bisMonat) {
		this.bisMonat = bisMonat;
	}

	public int getBisTag() {
		return bisTag;
	}

	public void setBisTag(int bisTag) {
		this.bisTag = bisTag;
	}

	public String getMischungNummer() {
		return saveValue(mischungNummer);
	}

	public void setMischungNummer(String mischungNummer) {
		this.mischungNummer = mischungNummer;
	}

	public String getMischungBezeichnung() {
		return saveValue(mischungBezeichnung);
	}

	public void setMischungBezeichnung(String mischungBezeichnung) {
		this.mischungBezeichnung = mischungBezeichnung;
	}

	public String getTank() {
		return saveValue(tank);
	}

	public void setTank(String tank) {
		this.tank = tank;
	}

	public String getTicketNummer() {
		return saveValue(ticketNummer);
	}

	public void setTicketNummer(String ticketNummer) {
		this.ticketNummer = ticketNummer;
	}
	
	private String saveValue(String in) {
		return in.replaceAll("\\[+\\]+\\(+\\)+\\'+\"+", "");
				
	}
	
	
}
