package de.lunqual.rzpro.items.mischungen;

import java.text.SimpleDateFormat;
import java.util.HashMap;

import de.lunqual.rzpro.RzPro;

public class MischungChartItem {

	RzPro rz;
	double			value;
	HashMap<String,String>  bMap;
	HashMap<String,String> lMap;
	TicketItem	ti;
	String			txtMischung;
	
	public MischungChartItem(RzPro rz,TicketItem ti,double value,String txtMischung) {
		this.rz = rz;
		this.ti = ti;
		this.txtMischung = txtMischung;
		bMap = new HashMap<String,String> ();
		lMap = new HashMap<String,String> ();
		if(ti != null) {
			bMap.put(ti.getBezeichnung(),ti.getBezeichnung());
			lMap.put(ti.getLosnummer_original(),ti.getLosnummer_original());
		} else {
			bMap.put(rz.getLocale().getString("mischungChartPanel.limit_text"),rz.getLocale().getString("mischungChartPanel.limit_text"));
			lMap.put("","");
		}
		this.value  = value;
	}

	public String getBezeichnung() {
		String ret = "";
		for ( String key : bMap.keySet() ) {
			ret += key + " ";
		}
		return ret.trim().equals("")?"":ret;
	}

	public void addValue(double value,String losnummer,String bezeichnung) {
		this.value +=value;
		if(!bMap.containsKey(bezeichnung)) {
			bMap.put(bezeichnung,bezeichnung);
		}
		if(!lMap.containsKey(losnummer)) {
			lMap.put(losnummer,losnummer);
		}
	}

	
	public String getLosnummer() {
		String ret = "";
		for ( String key : lMap.keySet() ) {
			ret += key + " ";
		}
		return ret.trim().equals("")?"":ret;
	}

	public String getErstellt() {
		SimpleDateFormat df=new SimpleDateFormat("(EE dd.MM.yyyy)");
		 return ti ==null?"":df.format(ti.getErstellt());
	}

    public String getTxtMischung() {
		return txtMischung;
	}

	public TicketItem getTi() {
    	return ti;
    }
	public double getValue() {
		return value;
	}

	
}
