/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.message;

import javax.swing.JFrame;

import de.lunqual.rzpro.fenster.JRzFrame;

/**
 *
 * @author  lunqual
 */
public class MessageItem {

	// Messages
	/** keine Message */
	public static final int	MSG_NULL									= 0;
	/** wies heisst, fatal error, wird derzeit aber nicht verwendet */
	public static final int	MSG_FATAL_ERROR								= 1;
	/** das anmelden war erfolgreich */
	public static final int	MSG_LOGIN_OK								= 2;
	/** anmelden wurde abgebrochen, die Anwendung wird jetzt beendet */
	public static final int	MSG_LOGIN_CANCEL							= 3;
	/** das Programm soll beendet werden (vom Auswahlfenster gesendet */
	public static final int	MSG_QUIT									= 4;
	/**
	 * Eine Abfrage wird hinzugefügt
	 * 
	 * @param userData
	 *            ist ein AbfrageItem Die Unterscheidung in Notiz/Rezeptur kamma
	 *            vielleicht mal brauchen
	 */
	public static final int	MSG_ADD_QUERY_NOTIZ							= 5;
	/**
	 * Eine Abfrage wird hinzugefügt
	 * 
	 * @param userData
	 *            ist ein AbfrageItem Die Unterscheidung in Notiz/Rezeptur kamma
	 *            vielleicht mal brauchen
	 */
	public static final int	MSG_ADD_QUERY_REZEPT						= 6;
	/**
	 * hilfe aufrufen
	 * 
	 * @param userData
	 *            ist ein String-Object mit dem dateinamen (ohne pfad) der
	 *            zugehörigen Hilfedatei
	 */
	public static final int	MSG_HILFE									= 7;
	/**
	 * an das Adressenfenster gerichtete Nachricht, bestimmte Adressen
	 * anzuzeigen
	 * 
	 * @param userData
	 *            ist ein String mit dem Filterausdruck der Filter kann "" sein,
	 *            (so wird das Fenster von der Auswahl aus aufgerufen, oder
	 *            einen beliebigen Ausdruck enthalten, dann wird der
	 *            Adressfilter damit gesetzt (in der Auswahl ist das der
	 *            Menüpunkt "Firmengruppe"
	 */
	public static final int	MSG_SHOW_ADRESSE							= 8;
	/**
	 * wird von den Actions eines Fensters gesendet
	 * 
	 * @param userCode
	 *            enthält den ActionCode
	 */
	public static final int	MSG_ACTIONPERFORMED							= 9;
	/**
	 * ein Fenster soll aus der Fensterliste verschwinden
	 * 
	 * @param userCode
	 *            ist der Zeiger aufs JRzFrame ein Fenster _muss_ auf diese
	 *            Weise entsorgt werden, da ein einfaches dispose() einen toten
	 *            Zeiger in der Fensterliste hinterlassen würde !
	 */
	public static final int	MSG_DISPOSE_FRAME							= 10;
	/** derezit nicht verwendet */
	public static final int	MSG_SET_EXTENDED_DATA						= 11;
	/**
	 * es wurde eine Auswahl im Adressauswahlfenster getroffen
	 * 
	 * @param userCode
	 *            enthält eine @link StichwortListe
	 * @param origin
	 *            enthält das JrzFrame, von dem der ursprüngliche Request stammt
	 * @see @link MSG_ADRESSLISTE_REQUEST Wenn der Ursrprung nicht mehr
	 *      existiert, wird die Message an das Auswahlfenster weitergeleitet !
	 */
	public static final int	MSG_ADRESSLISTE_REPLY						= 12;
	/**
	 * Das Adressauswahlfenster anzeigen.
	 * 
	 * @param userCode
	 *            enthält ein @link AbfrageItem
	 * @param origin
	 *            enthält das Frame, von dem der Request ausgeht
	 * @see MSG_ADRESSLISTE_REPLY
	 */
	public static final int	MSG_ADRESSLISTE_REQUEST						= 13;
	/**
	 * es wurde eine Auswahl im Stichwortauswahlfenster getroffen
	 * 
	 * @param userCode
	 *            enthält eine @link StichwortListe
	 * @param origin
	 *            enthält das JrzFrame, von dem der ursprüngliche Request stammt
	 * @see @link MSG_STICHWORTLISTE_REQUEST Wenn der Ursrprung nicht mehr
	 *      existiert, wird die Message an das Auswahlfenster weitergeleitet !
	 */
	public static final int	MSG_STICHWORTLISTE_REPLY					= 14;
	/**
	 * Das Stichwortauswahlfenster anzeigen.
	 * 
	 * @param userCode
	 *            enthält ein @link AbfrageItem
	 * @param origin
	 *            enthält das Frame, von dem der Request ausgeht
	 * @see MSG_ADRESSLISTE_REPLY
	 */
	public static final int	MSG_STICHWORTLISTE_REQUEST					= 15;
	/**
	 * das Adresseingabefenster aufrufen
	 * 
	 * @param userCode
	 *            enthält die Datenbank-ID der zu editierenden Adresse. Wenn
	 *            userCode 0 ist, wird eine Neue Adresse erstellt
	 */
	public static final int	MSG_EDIT_ADRESSE							= 16;
	/**
	 * Eine Adresse wurde erstellt oder geändert
	 * 
	 * @param userData
	 *            enthält den String mit dem Namen der Firma
	 * @param userCode
	 *            enthält die Datenbank-ID
	 */
	public static final int	MSG_EDIT_ADRESSE_REPLY						= 17;
	/**
	 * eine Rezeptur erstellen oder ändern
	 * 
	 * @param userCode
	 *            enthält ein ErgebnisItem
	 */
	public static final int	MSG_EDIT_REZEPTUR							= 18;
	/**
	 * eine Notiz erstellen oder ändern
	 * 
	 * @param userCode
	 *            enthält ein ErgebnisItem
	 */
	public static final int	MSG_EDIT_NOTIZ								= 19;
	/**
	 * das Währugsfenster öffnen und eine Währung auswählen
	 * 
	 * @param userCode
	 *            der Code der Währung
	 */
	public static final int	MSG_SHOW_WAEHRUNG							= 20;
	/**
	 * das Lagerfenster öffnen und ein Lager auswählen
	 * 
	 * @param userCode
	 *            der Code des Lagers
	 */
	public static final int	MSG_SHOW_LAGER								= 21;
	/**
	 * das Rechenfenster öffnen und eine REzeptur zum Berechnen übergeben
	 * 
	 * @param userData
	 *            ErgebnisItem
	 */
	public static final int	MSG_RECHNEN									= 22;
	/**
	 * das Einstellungsfenster öffnen und ein Tab anzeigen
	 * 
	 * @param userCode
	 *            Tab zum anzeigen
	 */
	public static final int	MSG_SHOW_EINSTELLUNGEN						= 23;
	/**
	 * eine neue Währung eingeben oder eine bestehende Währung abändern
	 * 
	 * @param userCode
	 *            id der Währung
	 */
	public static final int	MSG_EDIT_CURRENCY							= 24;
	/**
	 * eine Währung wurde erstellt oder eingegeben
	 * 
	 * @param userCode
	 *            id der Währung
	 */
	public static final int	MSG_EDIT_CURRENCY_REPLY						= 25;
	/**
	 * ein neues Lager eingeben oder eine bestehendes Lager abändern
	 * 
	 * @param userCode
	 *            id des Lagers
	 */
	public static final int	MSG_EDIT_LAGER								= 26;
	/**
	 * ein Lager wurde erstellt oder eingegeben
	 * 
	 * @param userCode
	 *            id des Lagers
	 */
	public static final int	MSG_EDIT_LAGER_REPLY						= 27;
	/**
	 * Die Anzeige im Auwahlfenster muss refresht werden, wenn die benötigte
	 * Rezeptur in der Anzeige steht;
	 * 
	 * @param userCode
	 *            die geänderte Rezeptur
	 */
	public static final int	MSG_REFRESH_AUSGABE							= 28;
	/**
	 * Das STärkefenster öffnen
	 * 
	 * @param userData
	 *            ergebnisItem
	 * @param userCode
	 *            1 = aufstärken, 0 = herabsetzen
	 */
	public static final int	MSG_STAERKE									= 29;
	/**
	 * Das Behälterfenster öffnen
	 * 
	 * @param userCode
	 *            Behälternummer anzeigen
	 */
	public static final int	MSG_SHOW_CONTAINER							= 30;
	/**
	 * einen neuen Behälter eingeben oder ändern
	 * 
	 * @param userCode
	 *            Behälter-ID
	 */
	public static final int	MSG_EDIT_CONTAINER_REQUEST					= 31;
	/**
	 * Behälter wurde geändert oder eingegeben
	 * 
	 * @param userCode
	 *            die ID des Behälters
	 */
	public static final int	MSG_EDIT_CONTAINER_REPLY					= 32;
	/**
	 * Lieferschein erstellen/bearbeiten
	 * 
	 * @param userCode
	 *            Lieferscheinnummer
	 * @param userData
	 *            adresse als Integer
	 */
	public static final int	MSG_EDIT_LIEFERSCHEIN_REQUEST				= 33;

	/**
	 * Lieferschein erstellen/bearbeiten
	 * 
	 * @param userCode
	 *            Lieferscheinnummer
	 * @param userData
	 *            string adressfilter
	 */
	public static final int	MSG_LIEFERSCHEINE							= 34;

	/**
	 * eine Adresse aus der Adressliste auswählen
	 * 
	 * @param userData
	 *            namensmuster
	 */
	public static final int	MSG_SELECT_ADRESSE_REQUEST					= 35;

	/**
	 * eine Adresse aus der Adressliste wurde ausgewählt
	 * 
	 * @param userCode
	 *            adresscode
	 */
	public static final int	MSG_SELECT_ADRESSE_REPLY					= 36;

	/**
	 * das Etikettendruckfenster öffnen
	 * 
	 * @param userData
	 *            ErgebnisItem oder null
	 */
	public static final int	MSG_SHOW_ETIKETTEN							= 37;

	/**
	 * Etikettendruck aus dem Lieferscheinfenster heraus
	 * 
	 * @param msgData
	 *            LieferscheinItem
	 */
	public static final int	MSG_LIEFERSCHEIN_ETIKETTEN					= 38;

	/**
	 * Alkoholtafelfenster öffnen
	 * 
	 * @param msgData
	 *            tafelItem
	 */
	public static final int	MSG_SHOW_TAFEL								= 39;

	/**
	 * einen Warenzugang verbuchen
	 * 
	 * @param userCode
	 *            id der Rezeptur;
	 */
	public static final int	MSG_SHOW_ZUGANG								= 40;

	/**
	 * Eine Abfrage wird hinzugefügt
	 * 
	 * @param userData
	 *            ist ein AbfrageItem
	 */
	public static final int	MSG_ADD_QUERY_ZUGANG						= 41;

	/**
	 * einen Warenzugang verbuchen
	 * 
	 * @param userCode
	 *            id der Rezeptur;
	 */
	public static final int	MSG_SHOW_ABGANG								= 42;

	/**
	 * Eine Abfrage wird hinzugefügt
	 * 
	 * @param userData
	 *            ist ein AbfrageItem
	 */
	public static final int	MSG_ADD_QUERY_ABGANG						= 43;

	/**
	 * Statistikfenster anzeigen
	 * 
	 * @param userCode
	 *            USER_FILTER oder NO_FILTER im statistikfenster definiert
	 * @param userData
	 *            ergebnisItem oder ergebnisListe;
	 * 
	 */
	public static final int	MSG_SHOW_STATISTIK							= 44;

	/**
	 * Herstellfenster anzeigen
	 * 
	 * @param userData
	 *            String mit losnummern
	 * 
	 *            Die Unterscheidung in Notiz/Rezeptur kamma vielleicht mal
	 *            brauchen
	 */
	public static final int	MSG_SHOW_HERSTELLUNG						= 45;

	/**
	 * Herstellung bearbeiten
	 * 
	 * @param userData
	 *            HerstellungsItem
	 * 
	 */
	public static final int	MSG_EDIT_HERSTELLUNG						= 46;

	/**
	 * eine Herstellung wurde bearbeitet... diese Nachricht erzwingt ein neues
	 * laden der Herstellungsliste im Herstellfenster und versucht, die
	 * bearbeitete Herstellung anzuzeigen
	 * 
	 * @param userCode
	 *            id der Herstellung;
	 */
	public static final int	MSG_EDIT_HERSTELLUNG_REPLY					= 47;

	/**
	 * im Zutatendialog wurde eine Auswahl getroffen
	 * 
	 * @param userData
	 *            ZutatenSuchItem
	 */
	public static final int	MSG_ZUTATEN_DIALOG_REPLY					= 48;

	/**
	 * im Einheitendialog wurde eine Auswahl getroffen
	 * 
	 * @param userData
	 *            EinheitsItem
	 */
	public static final int	MSG_EINHEITEN_DIALOG_REPLY					= 49;

	/**
	 * Verlaufsfenster anzeigen
	 * 
	 * @param userData
	 *            String mit dem Losnummern-Muster
	 */
	public static final int	MSG_SHOW_HISTORY							= 50;

	/**
	 * About-Fenster anzeigen
	 */
	public static final int	MSG_SHOW_ABOUT								= 51;

	/**
	 * Statistikfenster mit der Auswahl BESTAND anzeigen
	 * 
	 * @param userCode
	 *            USER_FILTER oder NO_FILTER im statistikfenster definiert
	 * @param userData
	 *            ergebnisItem oder ergebnisListe;
	 * 
	 */
	public static final int	MSG_SHOW_STATISTIK_BESTAND					= 52;

	/**
	 * Logging-Fenster öffnen
	 */
	public static final int	MSG_SHOW_LOG								= 53;
	/**
	 * Log hat sich geändert
	 */
	public static final int	MSG_LOG_CHANGE								= 54;
	/**
	 * Die Anzeige im Auwahlfenster muss refresht werden, wenn die benötigte
	 * Rezeptur in der Anzeige steht; Ausserdem soll das Fenster in den
	 * Vordergrund geholt werden
	 * 
	 * @param userCode
	 *            die geänderte Rezeptur
	 */
	public static final int	MSG_REFRESH_TOFRONT							= 55;

	/**
	 * Ausbeutefenster anzeigen
	 */
	public static final int	MSG_SHOW_AUSBEUTE							= 56;

	/**
	 * Das Stichworte-Eingabefenster öffnen
	 * 
	 * @param userCode
	 *            Datenbank-Key des zu bearbeitenden Stichworts
	 */
	public static final int	MSG_SHOW_STICHWORT_EINGABE					= 57;
	/**
	 * Ein Stichwort wurde bearbeitet
	 * 
	 * @param userCode
	 *            der Datenbank-Key des bearbeiteten Stichworts
	 */
	public static final int	MSG_EDIT_STICHWORT_REPLY					= 58;

	/**
	 * Das Ausbeutesatz-Eingabefenster öffnen
	 * 
	 * @param userCode
	 *            Datenbank-Key des zu bearbeitenden Ausbeutesatzes
	 */
	public static final int	MSG_SHOW_AUSBEUTE_EINGABE					= 59;
	/**
	 * Ein Ausbeutesatz wurde bearbeitet
	 * 
	 * @param userCode
	 *            der Datenbank-Key des bearbeiteten Stichworts
	 */
	public static final int	MSG_EDIT_AUSBEUTE_REPLY						= 60;
	/**
	 * Fenstertitel neu anzeigen
	 */
	public static final int	MSG_REFRESH_CAPTION							= 61;
	/**
	 * Statistik-Grafikfenster anzeigen (Herstellungen)
	 * 
	 * @param UserData
	 *            = StatistikItem
	 */
	public static final int	MSG_SHOW_ST_HERSTELLUNGEN					= 62;
	/**
	 * Die liste Abhängiger Rezepturen berechnen
	 * 
	 * @param userDate
	 *            = IDItem
	 */
	public static final int	MSG_DEPENDENCY_CALC							= 63;
	/**
	 * PalettenListenFenster
	 * 
	 * @param userDate
	 *            = IDItem
	 */
	public static final int	MSG_SHOW_PALETTENLISTE						= 64;
	/**
	 * Paletteneintrag bearbeiten UserCode = id der Palette
	 */
	public static final int	MSG_EDIT_PALETTE_REQUEST					= 65;

	/**
	 * Paletteneintrag bearbeitet UserCode = id
	 */
	public static final int	MSG_EDIT_PALETTE_REPLY						= 66;
	/**
	 * Palettenrechner aufrufen
	 */
	public static final int	MSG_SHOW_PALETTENRECHNER					= 67;

	/**
	 * Palettenrechner gibt Wert zurück UserData = (Double) Liter
	 */
	public static final int	MSG_PALETTENRECHNER_REPLY					= 68;
	/**
	 * Reply an den Palettenrechner
	 */
	public static final int	MSG_ALTERED_PALETTE							= 69;
	/**
	 * Erweiterte Abfrage
	 */
	public static final int	MSG_ABFRAGE_ERWEITERT						= 70;
	public static final int	MSG_ABFRAGE_ERWEITERT_REPLY					= 71;
	/**
	 * Inventurlistenfenster
	 */
	public static final int	MSG_SHOW_INVENTURLISTE						= 72;
	/**
	 * Inventur-Eingabe userData = InventurItem
	 */
	public static final int	MSG_SHOW_INVENTUREINGABE					= 73;
	/**
	 * Inventurlistenfenster refresh userData = InventurItem
	 */
	public static final int	MSG_INVENTUR_REFRESH						= 74;
	/**
	 * Inventurfenster anzeigen
	 */
	public static final int	MSG_SHOW_INVENTUR							= 75;
	/**
	 * Acidlistenfenster anzeigen
	 */
	public static final int	MSG_SHOW_ACIDLISTE							= 76;
	/**
	 * AcidEingabefenster anzeigen msgCode = AcidItem-ID
	 */
	public static final int	MSG_SHOW_ACIDEINGABE						= 77;
	/**
	 * AcidEingabe-Reply MsgCode = AcidITem-.ID
	 */
	public static final int	MSG_ACIDEINGABE_REPLY						= 78;
	/**
	 * Säurerechner anzeigen msgData = AcidAnzeigeItem msgCode == 0 : nur
	 * SChliessen-Button anzeigen msgCode != 0 : auch Zurückgeben-Button
	 * anzeigen
	 */
	public static final int	MSG_SHOW_ACIDRECHNER						= 79;
	/**
	 * DEr Säurerechner gibt einen WErt zurück msgData = (Double)value
	 */
	public static final int	MSG_ACIDRECHNER_REPLY						= 80;
	/**
	 * Deklarationslistenfenster anzeigen
	 */
	public static final int	MSG_SHOW_DEKLARATIONSLISTE					= 81;
	/**
	 * Deklarations-eingabefenster anzeigen
	 */
	public static final int	MSG_SHOW_DEKLARATION_EINGABE				= 82;

	/**
	 * eine Deklaration wurde eingegeben msgCode = id der eingegebenen
	 * Deklaration
	 */
	public static final int	MSG_EDIT_DEKLARATION_REPLY					= 83;
	/**
	 * DeklarationsAuswahlfenster anzeigen MsgData = String zur Auswahl
	 */
	public static final int	MSG_SHOW_DEKLARATION_AUSWAHL				= 84;
	/**
	 * eine Deklarationliste wurde erstellt
	 */
	public static final int	MSG_DEKLARATION_AUSWAHL_REPLY				= 85;

	/**
	 * Im Herstellbuch wurde eine LAgerliste ausgewählt msgData = LAgerliste
	 */
	public static final int	MSG_LAGERLISTEN_DIALOG_REPLY				= 86;

	/**
	 * Ausstattungsfenster öffnen UserCode ist ein ErgebnisItem
	 */
	public static final int	MSG_SHOW_AUSSTATTUNG						= 87;
	/**
	 * Ausstattung bearbeiten UserCode ist ein ErgebnisItem
	 */
	public static final int	MSG_EDIT_AUSSTATTUNG						= 88;
	/**
	 * Datenblatt anzeigen UserCode ist eine Rezeptur-id
	 */
	public static final int	MSG_SHOW_DATENBLATT							= 89;
	/**
	 * Bestellungsfenster anzeigen userCode ist die Rezeptur-ID
	 */
	public static final int	MSG_SHOW_BESTELLUNGSFENSTER					= 90;
	/**
	 * Bestellungslistenfenster anzeigen
	 */
	public static final int	MSG_SHOW_BESTELLUNGSLISTENFENSTER			= 91;
	/**
	 * eine Bestellung bearbeiten userCode ist die ID der Bestellung
	 */
	public static final int	MSG_SHOW_BESTELLUNGSFENSTER_EDIT			= 92;
	/**
	 * Bestellungsliste auffrischen
	 */
	public static final int	MSG_REFRESH_BESTELLUNGSLISTE				= 93;
	/**
	 * laborwertlistenfenster
	 */
	public static final int	MSG_SHOW_LABORWERTLISTENFENSTER				= 94;
	public static final int	MSG_SHOW_LABORWERTLISTE_EINGABE				= 95;
	public static final int	MSG_LABORWERTLISTE_EINGABE_REPLY			= 96;
	/**
	 * Laborwertberechnung öffnen msgDate ist ein RechenItem
	 */
	public static final int	MSG_SHOW_LABORWERTBERECHNUNG				= 97;

	/**
	 * StatistikRezeptur msgData==StatistikRezepturListe
	 */
	public static final int	MSG_SHOW_STATISTIK_REZEPTUR					= 98;

	/**
	 * Probenfenster öffnen msgCode = 0 oder die ID einer Probe
	 */
	public static final int	MSG_SHOW_PROBENFENSTER						= 99;
	public static final int	MSG_SHOW_PROBENFENSTER_ADRESSE				= 100;

	/**
	 * Probeneingabe hat mehrere Möglichkeiten der MsgCode enhtält verschiedene
	 * IDs (oder 0)
	 */
	public static final int	MSG_SHOW_PROBENEINGABE_REZEPTUR				= 101;
	public static final int	MSG_SHOW_PROBENEINGABE_PROBE				= 102;
	public static final int	MSG_SHOW_PROBENEINGABE_HERSTELLUNG			= 103;

	/**
	 * Zutatenverzeichnis - Einstellungen
	 * 
	 */
	public static final int	MSG_SHOW_ZUTATENVERZEICHNIS_EINSTELLUNGEN	= 104;

	// MsgData ist ein zutatenverzeichnisitem oder null
	public static final int	MSG_SHOW_ZUTATENVERZEICHNIS_EINGABE			= 105;

	// MsgDataist ein zutatenverzeichnisitem
	public static final int	MSG_ZUTATENVERZEICHNIS_EINGABE_REPLY		= 106;

	public static final int	MSG_STICHWORT_DIALOG_REPLY					= 107;

	/**
	 * Zutatenverzeichnis msgDate ist eine Zutatenverzeichnisliste
	 */
	public static final int	MSG_SHOW_ZUTATENVERZEICHNIS					= 108;

	/**
	 * Zugangs /abgangsfenster
	 */
	public static final int	MSG_SHOW_VERBRAUCH_SINGLE					= 109;
	public static final int	MSG_SHOW_VERBRAUCH_LISTE					= 110;

	public static final int	MSG_AUSWAHL_SAVE_HISTORY					= 111;

	public static final int	MSG_SHOW_STATISTIK_FOLGE					= 112;

	public static final int	MSG_SHOW_GEWICHT							= 113;

	public static final int	MSG_EDIT_REZEPTUR_GRUPPE					= 114;

	public static final int	MSG_EDIT_NOTIZ_GRUPPE						= 115;

	public static final int	MSG_SHOW_LOSNUMMERVORLAGE_FLASCHEN			= 116;

	public static final int	MSG_SHOW_LOSNUMMERVORLAGE_DECKEL			= 117;

	public static final int	MSG_REPLY_LOSNMMERVORLAGE_DECKEL			= 118;

	public static final int	MSG_REPLY_LOSNMMERVORLAGE_FLASCHEN			= 119;

	public static final int	MSG_SHOW_LOSNUMMERVORLAGE_FILTER			= 120;

	public static final int	MSG_REPLY_BUCHUNGSDIALOG					= 121;

	public static final int	MSG_SHOW_LOSNUMMERVORLAGE_SINGLE			= 122;

	public static final int	MSG_SHOW_PROBENEINGABE_ABGANG				= 123;

	public static final int	MSG_SHOW_PROBENEINGABE_LIEFERSCHEIN			= 124;

	public static final int	MSG_SHOW_KALENDER							= 125;

	public static final int	MSG_PROPAGATE_PROBEN						= 126;

	public static final int	MSG_PROBEN_EDIT_REPLY						= 127;

	public static final int	MSG_SHOW_KALENDER_DATUM						= 128;

	public static final int	MSG_SHOW_AUFTRAG							= 129;

	public static final int	MSG_SHOW_CHANGES							= 130;

	public static final int	MSG_SHOW_CHANGES_NOTIZ						= 131;

	public static final int	MSG_SHOW_CHANGES_AUSSTATTUNG				= 132;

	public static final int	MSG_SHOW_CHANGES_LISTE						= 133;

	public static final int	MSG_REFRESH_LABORWERTE						= 134;

	public static final int	MSG_SHOW_MHD								= 135;

	public static final int	MSG_ADD_ETIKETTENLISTE						= 136;

	public static final int	MSG_ADD_MHD_ABFRAGE							= 137;

	public static final int	MSG_SHOW_TEMPERATURZONEN					= 138;

	public static final int	MSG_SHOW_AUFTRAGSLISTE						= 139;

	public static final int	MSG_EDIT_AUFTRAG							= 140;

	public static final int	MSG_EDIT_AUFTRAG_REPLY						= 141;

	public static final int	MSG_SHOW_TERMIN								= 142;

	public static final int	MSG_EDIT_TERMIN								= 143;

	public static final int	MSG_SHOW_AUFTRAGSLISTE_ANFRAGEN				= 144;

	public static final int	MSG_SHOW_AUFTRAG_DATUM						= 145;

	public static final int	MSG_SHOW_ANFRAGE_DATUM						= 146;

	public static final int	MSG_SHOW_DMLISTE							= 147;

	public static final int	MSG_LOSNUMMER_DIALOG_REPLY					= 148;

	public static final int	MSG_SHOW_TANKLISTE							= 149;

	public static final int	MSG_SHOW_ORTEINGABE							= 150;

	public static final int	MSG_ORTEINGABE_REPLY						= 151;

	public static final int	MSG_SHOW_TANKEINGABE						= 152;

	public static final int	MSG_TANKEINGABE_REPLY						= 153;

	public static final int	MSG_TANKLISTE_REPLY							= 154;

	public static final int	MSG_SHOW_TANKAUSWAHL						= 155;

	public static final int	MSG_EINGABEDIALOG_REPLY						= 156;

	public static final int	MSG_SHOW_KONFORM							= 157;
	
	public static final int	MSG_SHOW_SORTEN_EINGABE						= 158;
	
	public static final int MSG_EDIT_SORTE_REPLY						= 159;
	
	public static final int	MSG_SHOW_MISCHUNG_EINGABE_TANK				= 160;
	
	public static final int	MSG_SHOW_MISCHUNGSLISTENFENSTER				= 161;
	
	public static final int	MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG			= 162;
	
	public static final int	MSG_SHOW_ZUTATENVERZEICHNIS_REZEPTUR		= 163;
	
	public static final int	ZUTATENVERZEICHNIS_REZEPTUR_REPLY			= 164;
	
	public static final int	MSG_REFRESH_MISCHUNGEN						= 165;

	public static final int	MSG_SHOW_BEWERTUNG_KATEGORIE_EINGABE		= 166;
	
	public static final int	MSG_EDIT_BEWERTUNG_KATEGORIE_REPLY			= 167;
	
	public static final int	MSG_SHOW_BEWERTUNGSEINGABE					= 168;
	
	public static final int	MSG_SHOW_BEWERTUNGSANZEIGE					= 169;
	
	public static final int	MSG_SHOW_BEWERTUNGS_LISTENFENSTER			= 170;
	
	public static final int	MSG_SHOW_MISCHUNGSFENSTER					= 171;

	public static final int	MSG_SHOW_TICKETEINGABE						= 172;
	
	public static final int	MSG_SHOW_TICKETEINGABE_EDIT					= 173;
	
	public static final int MSG_REFRESH_AUSGABE_EDIT_TICKET				= 174;
	
	public static final int	MSG_MISCHUNGSLISTE_REPLY					= 175;
	
	public static final int	MSG_SHOW_MISCHUNGSFENSTER_TICKETS			= 176;
	
	public static final int	MSG_SHOW_TICKETEINGABE_DEFAULT				= 177;
	
	public static final int	MSG_SHOW_TICKETEINGABE_EDIT_DEFAULT			= 178;
	
	public static final int	MSG_SHOW_TANKAUSWAHL_MISCHUNG				= 179;
	
	public static final int	MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGSLISTE	= 180;
	
	public static final int	MSG_SHOW_PROBENEINGABE_TICKET				= 181;
	
	public static final int	MSG_SHOW_STAMMBAUM							= 182;
		
	public static final int	MSG_TICKET_DIALOG_REPLY						= 183;

	public static final int	MSG_SHOW_VERGLEICH_1						= 184;
	
	public static final int	MSG_SHOW_VERGLEICH_2						= 185;
	
	public static final int MSG_CLEAR_VERGLEICH							= 186;
	
	public static final int	MSG_GET_STICHWORTE							= 187;
	
	public static final int	MSG_GET_STICHWORTE_REPLY					= 188;
	
	public static final int	MSG_SHOW_PROBENEINGABE_VERLAUF				= 189;

	public static final int	MSG_SHOW_PROBENFENSTER_PROBENNUMMER			= 190;
	
	public static final int MSG_SHOW_BEDARFSFENSTER						= 199;
	
	public static final int	MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGEN		= 200;
	
	public static final int MSG_SHOW_TRACE								= 201;
	
	public static final int MSG_SHOW_LOSNUMMERLISTE_ID					= 202;
	
	public static final int	MSG_SHOW_LOSNUMMERLISTE_DATUM				= 203;
	
	public static final int	MSG_SHOW_DRUCKFORMULARE						= 204;
	
	public static final int	MSG_SHOW_HISTORY_BUCHUNGSNUMMER				= 205;
	
	public static final int	MSG_REFRESH_MHDLISTE						= 206;
	
	
	public static final int MSG_SHOW_MISCHUNG_CHART = 207;
	public static final int MSG_SHOW_DOKUMENT_LISTE = 208;
	public static final int MSG_SHOW_DOKUMENT_EINGABE = 209;
	public static final int MSG_DOKUMENT_EINGABE_REPLY = 210;
	public static final int MSG_SHOW_DOKUMENT_LISTE_ALLE= 211;
	public static final int MSG_SHOW_DOKUMENT_ADRESSE= 212;
	public static final int MSG_SHOW_DOKUMENT_LISTE_FILTER= 213;
	
	public static final int	MSG_SHOW_REZEPTUR_CONTENT = 214;
	public static final int	MSG_SHOW_REZEPTUR_CONTENT_RI = 215;
	public static final int	MSG_SHOW_RECHNEN_EDIT =		216;
	public static final int	MSG_SHOW_RECHNEN_EDIT_REPLY =		217;
	
	public static final int	MSG_SHOW_KONTRAKTE =				218;
	public static final int	MSG_EDIT_KONTRAKT =					219;
	public static final int	MSG_EDIT_KONTRAKT_REPLY =			220;	
	public static final int	MSG_SHOW_KONTRAKTE_ID =				221;

	public static final int	MSG_SHOW_KONTRAKTE_ADRESSE =		222;
	
	public static final int	MSG_CHANGESFILTER_DIALOG_REPLY	= 	223;
	
	
	//MsgDate
	int        msgCode;
    int		userCode;
    Object   userData;
    JFrame origin;

    /** Creates a new instance of MessageItem
     * @param int co MesageCode
     * @param userCode unter-code
     * @param userData aObject ggfs. ein Object
     * @param JRzFrame origin aurufendes Frame
     */
    public MessageItem(int msgCode,int userCode,Object userData,JFrame origin) {
        this.msgCode = msgCode;
        this.userCode = userCode;
        this.userData = userData;
        this.origin = origin;
    }

    public int getMsgCode(){return msgCode;}
    public int getCode() {return userCode;}
    public void setMsgCode(int msgCode) {this.msgCode = msgCode;}
    public void setCode(int code) {this.userCode = code;}
    public void setData(Object userData) {this.userData = userData;}
    public Object getData(){return userData;}
    public JRzFrame getOrigin() {return (JRzFrame)origin;}
    public void setOrigin(JFrame origin) {this.origin=origin;}
}
