/*
 * Created on 02.01.2005
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.items.log;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.log.LogFactory;

/**
 * @author lunqual
 *
 */
public class LoggingListe extends ArrayList {

	int		maxCount;
	RzPro	rz;

	public LoggingListe(RzPro r,int maxCount) {
		super();
		rz = r;
		setMaxCount(maxCount);
	}

	/**
	 * maxCount setzen
	 * @param maxCount
	 */
	public void setMaxCount(int count) {
		this.maxCount=count;
	}
	/**
	 * Ein LogginItem hinzufügen;
	 * @param li
	 */
	public void addItem(LoggingItem li) {
		if(this.size() > maxCount) {
			this.remove(0);
		}
		this.add(li);
	}

	public LoggingItem getItem(int i) {
		return (LoggingItem)this.get(i);
	}
	/**
	 * Die Liste speichern
	 */
	public void saveLog(String path) {
		if(this.size() > 0) {
			try {
				final PrintWriter out = new PrintWriter(new FileWriter(path));
				for(int i = 0;i < this.size();i++) {
					final LoggingItem li = this.getItem(i);
					out.println(li.getTimestamp().toString() + "\t" + li.getLevelString() + "\t" + li.getOrigin() + "\t" + li.getMessage());
				}
				out.flush();
		    	out.close();
			} catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_ERROR,"loggingListe",e.getLocalizedMessage()+":" + path);
			}
		}
	}
}
