/*
 * Created on 20.09.2004
 *
 */
package de.lunqual.rzpro.items.lieferschein;

import java.math.BigDecimal;
import java.rmi.server.UID;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.database.DBLieferschein;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 */
public class LieferscheinZeile {

    public static final int			ZEILE_CONTAINER = 0;
    public static final int			ZEILE_SUMME		= 1;
    public static final int			ZEILE_KOPF = 2;
    public static final int			ZEILE_LEER=3;

    int										typ;
    int										lieferscheinID;
    int										id;
    String									bezeichnung;
    String									containerS;
    int										container;
    int										losnummer_reihe;
    String									losnummer;
    double								brutto;
    double								tara;
    double								netto;
    double								liter;
    double								kg;
    double								la;
    RezepturItem						rezeptur;
    double								litergewicht;
    double								staerke;
    UID										uid;
    String									comment;
    int										buchungId;
    double								openLiter;
    boolean								probeErforderlich;
    String									proben;
    Date										erstellt;
    String								ean;

    RzPro									rz;
    public LieferscheinZeile(RzPro rz) {
        this.rz=rz;
    }
    public LieferscheinZeile(RzPro rz,UID uid,int lieferscheinID,int id,String bezeichnung,RezepturItem rezeptur,int container,String containerS,
            int losnummer_reihe,String losnummer,double staerke,double litergewicht,
            double brutto,double tara,double netto,double liter,double kg, double la,String comment,String ean,Date erstellt) {
        this.rz = rz;
        this.uid = uid;
        this.lieferscheinID=lieferscheinID;
        this.id=id;
        this.bezeichnung=bezeichnung == null ? "" : bezeichnung;
        this.rezeptur=rezeptur;
        this.container=container;
        this.containerS=containerS == null ? "":containerS ;
        this.losnummer_reihe = losnummer_reihe;
        this.losnummer=losnummer == null ? "" : losnummer;
        this.staerke=staerke;
        this.litergewicht=litergewicht;
        this.brutto=brutto;
        this.tara=tara;
        this.netto=netto;
        this.liter=liter;
        this.kg=kg;
        this.la=la;
        this.comment=comment;
        this.typ=ZEILE_CONTAINER;
        this.ean = ean;
        this.erstellt=erstellt;
    }

    public LieferscheinZeile copyItem() {
        final LieferscheinZeile zl = new LieferscheinZeile(rz,uid,lieferscheinID,id,bezeichnung,rezeptur,container,
                containerS,losnummer_reihe,losnummer,staerke,litergewicht,brutto,tara,netto,liter,kg,la,comment,ean,erstellt);
        zl.setTyp(typ);
        return zl;
    }

    public void copyToItem(LieferscheinZeile zDest) {
        zDest.setRz(this.rz);
        zDest.setId(this.getId());
        zDest.setUid(this.getUid());
        zDest.setBezeichnung(this.getBezeichnung());
        zDest.setBrutto(this.getBrutto());
        zDest.setContainer(this.getContainer());
        zDest.setContainerS(this.getContainerS());
        zDest.setId(this.getId());
        zDest.setKg(this.getKg());
        zDest.setLa(this.getLa());
        zDest.setLieferscheinID(this.getLieferscheinID());
        zDest.setLiter(this.getLiter());
        zDest.setLitergewicht(this.getLitergewicht());
        zDest.setLosnummerReihe(this.getLosnummerReihe());
        zDest.setLosnummer(this.getLosnummer());
        zDest.setNetto(this.getNetto());
        zDest.setRezeptur(this.getRezeptur());
        zDest.setTara(this.getTara());
        zDest.setTyp(this.getTyp());
        zDest.setComment(this.getComment());
        zDest.setEan(this.getEan());
        zDest.setErstellt(this.getErstellt());
    }

    public void clearZeile() {
        setBrutto(0);
        setContainer(0);
        setContainerS("");
        setKg(0);
        setLa(0);
        setLiter(0);
        setLosnummer("");
        setNetto(0);
        setTara(0);
        setComment("");
        setEan("");
    }
    
    public void etikettenDruck(boolean abfuelltag) {
    	final EtikettenListe ei = new EtikettenListe();
    	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));
		if(this.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
			final EtikettenItem eti = new EtikettenItem(rz);
			eti.setZeile(0,this.getBezeichnung() + " (" +
				rz.getLocale().formatNumber(this.getStaerke(),OptionFactory.NF_STAERKE) + " " +
				rz.getLocale().getString("string_prozentvol") + ")");
			eti.setZeile(1,rz.getLocale().getString("etiketten.string_nummer") + this.getContainerS() + " " +
					rz.getLocale().getString("etiketten.string_losnummer") + this.getLosnummer(erstellt,abfuelltag));
			eti.setZeile(2,rz.getLocale().getString("string_brutto") + " " + rz.getLocale().formatNumber(this.getBrutto(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg") + ", " +
					 rz.getLocale().getString("string_tara") + " " + rz.getLocale().formatNumber(this.getTara(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg"));
			eti.setZeile(3,rz.getLocale().getString("string_netto") + " " + rz.getLocale().formatNumber(this.getNetto(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg"));
			eti.setZeile(4,rz.getLocale().formatNumber(this.getLiter(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_liter") +", " +
				 rz.getLocale().formatNumber(this.getLa(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_la"));
			eti.setLosnummer(this.getLosnummer(erstellt,abfuelltag));
			eti.setImage(ei.getBogen().getImage());
			eti.setEan(this.getEan());
			ei.addItem(eti);
		}
    	if(ei.size() != 0) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,ei,null));
    	}
    }

    
    public String getEan() {
		return ean;
	}
	public void setEan(String ean) {
		this.ean = ean;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	public String getBezeichnung() {
        return bezeichnung;
    }
    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }
    public double getBrutto() {
        return brutto;
    }
    public void setBrutto(double brutto) {
        this.brutto = brutto;
    }
    public int getContainer() {
        return container;
    }
    public void setContainer(int container) {
        this.container = container;
    }
    public String getContainerS() {
        return containerS;
    }
    public void setContainerS(String containerS) {
        this.containerS = containerS;
    }
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }
    public double getKg() {
        return kg;
    }
    public void setKg(double kg) {
        this.kg = new BigDecimal(kg).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    public double getLa() {
        return la;
    }
    public void setLa(double la) {
        this.la = new BigDecimal(la).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    public int getLieferscheinID() {
        return lieferscheinID;
    }
    public void setLieferscheinID(int lieferscheinID) {
        this.lieferscheinID = lieferscheinID;
    }
    public double getLiter() {
        return liter;
    }
    public void setLiter(double liter) {
        this.liter = new BigDecimal(liter).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP).doubleValue();
    }
    public double getNetto() {
        return netto;
    }
    public void setNetto(double netto) {
        this.netto = netto;
    }
    public RezepturItem getRezeptur() {
        return rezeptur;
    }
    public void setRezeptur(RezepturItem rezeptur) {
        this.rezeptur = rezeptur;
    }
    public double getTara() {
        return tara;
    }
    public void setTara(double tara) {
        this.tara = tara;
    }

    public int getLosnummerReihe() {
        return losnummer_reihe;
    }
    public void setLosnummerReihe(int losnummer_reihe) {
        this.losnummer_reihe = losnummer_reihe;
    }

    public String getLosnummerReiheString() {
    	if (losnummer_reihe==DBBuchung.REIHE_FIFO) {
    		return rz.getLocale().getString("lieferschein.table_reihe_fifo");
    	} else {
    		return rz.getLocale().getString("lieferschein.table_reihe_lifo");
    	}
    }
    public String getLosnummer() {
        return losnummer;
    }

    public String getLosnummer(Date d,boolean abfuelltag) {
    	String ret="";
    	Calendar c =Calendar.getInstance();
    	c.setTime(d);
    	if(abfuelltag) {
    		String l[]=losnummer.split(" ");
    		for(int i=0;i<l.length;i++) {
    			ret+= rz.getDatabase().getLieferschein().getLosnummerVorschlag(
    					rz.getDatabase().getLieferschein().getEtikettenChars(DBLieferschein.ETIKETTEN_MUSTER_REMOVE), 
    					rz.getDatabase().getLieferschein().getEtikettenChars(DBLieferschein.ETIKETTEN_MUSTER_MUSTER), 
    					l[i], d) + " ";
    		}
    	}
    	return ret.trim().equals("")?losnummer:ret.trim();
    }
    
    
    public void setLosnummer(String losnummer) {
        this.losnummer = losnummer;
    }

    public double getLitergewicht() {
        return litergewicht;
    }
    public void setLitergewicht(double litergewicht) {
        this.litergewicht = litergewicht;
    }


    public double getStaerke() {
        return staerke;
    }
    public void setStaerke(double staerke) {
        this.staerke = staerke;
    }

    public int getTyp() {
        return typ;
    }
    public void setTyp(int typ) {
        this.typ = typ;
    }

    public UID getUid() {
        return uid;
    }
    public void setUid(UID uid) {
        this.uid = uid;
    }

    public RzPro getRz() {
        return rz;
    }
    public void setRz(RzPro rz) {
        this.rz = rz;
    }
    
    public double getOpenLiter() {
    	if(this.typ != ZEILE_SUMME) {
    	return (losnummer != null &&losnummer.equals(""))?this.liter:0.0;
    	} else {
    		return openLiter;
    	}
    }

    public void setOpenLiter(double value) {
    	openLiter=value;
    }
}
