/*
 * Created on 20.09.2004
 */
package de.lunqual.rzpro.items.lieferschein;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 */
public class LieferscheinItem {


    RzPro					rz;
    int						id;
    String					nummer;
    int						adresse;
    String					adresse_string;
    AdressItem			ai;
    Date						erstellt;
    Date						geaendert;
    String					user_1;
    String					user_2;
    AuftragsListe			auftragsListe;
    String					comment;

    public LieferscheinItem(RzPro rz,int id,String nummer,int adresse,String adresse_string,Date erstellt,Date geaendert,String user_1,String user_2,String comment) {
        this.rz=rz;
        this.id=id;
        this.ai = adresse == 0 ? null : rz.getDatabase().getAdressen().dbGetAdresse(adresse,true);
        this.nummer=nummer;
        this.adresse = adresse;
        this.adresse_string=adresse_string;
        this.erstellt=erstellt;
        this.geaendert=geaendert;
        this.user_1 = user_1;
        this.user_2 = user_2;
        this.comment=comment;
        auftragsListe = new AuftragsListe(rz);
    }

    public void etikettenDruck(boolean abfuelltag) {
    	final EtikettenListe ei = new EtikettenListe();
    	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));
    	for(int i = 0;i < this.getAuftragsListe().size();i++) {
    		final LieferscheinAuftrag la = this.getAuftragsListe().getItem(i);
    		for(int j = 0;j < la.getZeilenListe().size();j++) {
    			final LieferscheinZeile zl = la.getZeilenListe().getItem(j);
    			if((zl != null) && (zl.getTyp() == LieferscheinZeile.ZEILE_CONTAINER)) {
    				final EtikettenItem eti = new EtikettenItem(rz);
    				eti.setZeile(0,zl.getBezeichnung() + " (" +
    					rz.getLocale().formatNumber(zl.getStaerke(),OptionFactory.NF_STAERKE) + " " +
						rz.getLocale().getString("string_prozentvol") + ")");
    				eti.setZeile(1,rz.getLocale().getString("etiketten.string_nummer") + zl.getContainerS() + " " +
    						rz.getLocale().getString("etiketten.string_losnummer") + zl.getLosnummer(erstellt,abfuelltag));
    				eti.setZeile(2,rz.getLocale().getString("string_brutto") + " " + rz.getLocale().formatNumber(zl.getBrutto(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg") + ", " +
    						 rz.getLocale().getString("string_tara") + " " + rz.getLocale().formatNumber(zl.getTara(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg"));
    				eti.setZeile(3,rz.getLocale().getString("string_netto") + " " + rz.getLocale().formatNumber(zl.getNetto(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg"));
    				eti.setZeile(4,rz.getLocale().formatNumber(zl.getLiter(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_liter") +", " +
   						 rz.getLocale().formatNumber(zl.getLa(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_la"));
    				eti.setLosnummer(zl.getLosnummer(erstellt,abfuelltag));
    				eti.setImage(ei.getBogen().getImage());
    				eti.setEan(zl.getEan());
    				eti.setRezepturID(zl.getRezeptur().getID());
    				ei.addItem(eti);
    			}
    		}
    	}
    	if(ei.size() != 0) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,ei,null));
    	}
    }

    public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public int getAdresse() {
        return adresse;
    }
    public void setAdresse(int adresse) {
        this.adresse = adresse;
    }
    public Date getErstellt() {
        return erstellt;
    }
    public void setErstellt(Date erstellt) {
        this.erstellt = erstellt;
    }
    public Date getGeaendert() {
        return geaendert;
    }
    public void setGeaendert(Date geaendert) {
        this.geaendert = geaendert;
    }
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }
    public String getNummer() {
        return nummer;
    }
    public void setNummer(String nummer) {
        this.nummer = nummer;
    }
    public String getUser_1() {
        return user_1;
    }
    public void setUser_1(String user_1) {
        this.user_1 = user_1;
    }
    public String getUser_2() {
        return user_2;
    }
    public void setUser_2(String user_2) {
        this.user_2 = user_2;
    }

    public AuftragsListe getAuftragsListe() {
        return auftragsListe;
    }
    public void setAuftragsListe(AuftragsListe auftragsListe) {
        this.auftragsListe = auftragsListe;
    }

    public AdressItem getAi() {
        return ai;
    }
    public void setAi(AdressItem ai) {
        this.ai = ai;
        if(ai != null) {
            this.adresse_string = ai.getFirma();
        }
    }

    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }

    public String getAdresse_string() {
        if(this.ai != null) {
            return ai.getFirma();
        } else {
            return adresse_string;
        }
    }
    public void setAdresse_string(String adresse_string) {
        this.adresse_string = adresse_string;
    }

    /**
     * @return false, wenn irgendein Auftrag eine Bestandswarnung hat, true wenn
     * alle Bestände ausreichen
     */
    public boolean getBestandsWarnung() {
    	for(int i = 0;i < this.auftragsListe.size();i++) {
    		if(auftragsListe.getItem(i).isBestandWarnung()) {
    			return true;
    		}
    	}
    	return false;
    }
}
