/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.lager;


import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;

/**
 *
 * @author  lunqual
 */
public class LagerListe extends ArrayList {

	RzPro 			rz;

    /** Creates a new instance of LagerListe */
    public LagerListe(RzPro rz) {
        super();
        this.rz = rz;
    }

    public void addItem(LagerItem li){
        add(li);
    }

    public LagerItem getItem(int i){
        return (LagerItem)get(i);
    }

    public LagerItem getItemByID(int aID){
        int i;
        for (i=0;i < this.size();i++){
            final LagerItem li = this.getItem(i);
            if (li.getID() == aID) {
				return li;
			}
        }
        return null;
    }

    /*
     * test , ob alle Lager angewählt oder alle Lager nicht angewählt sind
     * @param check  wenn true wird geprüft ob alles gecheckt ist,
     *                          wenn false wird geprüft ob alles un-gecheckt ist
     *
     * @return  true, wenn alle Lager == check sind, false wenn nicht
     */
    public boolean getChecked(boolean check) {
    	int count = 0;
    	if(!this.isEmpty()) {
    		for(int i =0;i < this.size();i++) {
    			if(this.getItem(i).isChecked()==check) {
					count++;
				}
    		}
    	}
    	return (count == this.size()?true:false);
    }

    /**
     * HTML-String mit Farben der ausgewählten Lager zurückgeben
     */
    @Override
	public String toString() {
    	String ret="";
    	if(getChecked(true)) {
    		ret = rz.getLocale().getString("lager.liste_alle");
    	} else if(getChecked(false)) {
    		ret = rz.getLocale().getString("lager.liste_keine");
    	}  else {
    		ret +="<html>";
    		for(int i = 0;i < this.size();i++) {
    			final LagerItem li = this.getItem(i);
    			if(li.isChecked()) {
    				ret += "<span style=\"background-color:#" + li.getHg() + ";#color:#" + li.getVg() + "\">" + li.getName() + "</span>&nbsp;";
    			}
    		}
    		ret += "</html>";
    	}
    	return ret;

    }

    /**
     * PlainString der ausgewählten Lager zurückgeben
     */
    public String toPlainString() {
    	String ret="";
    	if(getChecked(true)) {
    		ret = rz.getLocale().getString("lager.liste_alle");
    	} else if(getChecked(false)) {
    		ret = rz.getLocale().getString("lager.liste_keine");
    	}  else {
    		for(int i = 0;i < this.size();i++) {
    			final LagerItem li = this.getItem(i);
    			if(li.isChecked()) {
    				ret +=li.getName() + ", ";
    			}
    		}
    		if(ret.endsWith(", ")) {
				ret = ret.substring(0,ret.length() -", ".length());
			}
    	}
    	return ret;
    }


    /**
     * alles oder nichts checken
     * @param check : Das wird für alle Lager gesetzt
     */
    public void setCheckForAll(boolean check) {
    	for(int i = 0;i < this.size();i++) {
    		this.getItem(i).setChecked(check);
    	}
    }

    /**
     * Diese Liste kopieren
     */
    public LagerListe copyList() {
    	final LagerListe ls = new LagerListe(rz);
    	for(int i = 0;i < this.size();i++) {
    		final LagerItem li = this.getItem(i);
    		ls.addItem(new LagerItem(
    				li.getID(),
    				li.getName(),
    				li.getErsatztext(),
    				li.getComment(),
    				li.getListe(),
    				li.getHg(),
    				li.getVg(),
    				li.isChecked(),
    				li.getErstellt(),
    				li.getGeaendert(),
    				li.getUser1(),
    				li.getUser2()
    		));
    	}
    	return ls;
    }

}
