/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.lager;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

/**
 *
 * @author  lunqual
 */
public class LagerItem  {

    int                 		id;
    String              		name;
    String              		comment;
    String 					ersatztext;
    int                 		liste;
    Date                		erstellt;
    Date                		geaendert;
    String					hg;
    String					vg;
    Color						c_hg;
    Color						c_vg;
    String              			user_1;
    String              			user_2;
    SimpleDateFormat    df;
    boolean					checked;

    /** Creates a new instance of LagerItem */
    public LagerItem() {
        df = new SimpleDateFormat(RzPro.DATEFORMAT_NORMAL);
        id = 0;
        name = "";
        comment = "";
        liste = 0;
        erstellt = new Date();
        geaendert = new Date();
        user_1 = "";
        user_2 = "";
        setHg("ffffff");
        setVg("000000");
        checked = false;
    }

    public LagerItem(int aID,String aName,String aErsatztext,String aComment,int aListe,String hg,String vg,boolean checked,Date aErstellt,Date aGeaendert,String aUser1,String aUser2){
        df = new SimpleDateFormat(RzPro.DATEFORMAT_NORMAL);
        id = aID;
        name = aName;
        this.ersatztext = aErsatztext;
        comment = aComment;
        liste = aListe;
        setHg(hg);
        setVg(vg);
        this.vg=vg;
        erstellt = aErstellt;
        geaendert = aGeaendert;
        user_1 = aUser1;
        user_2 = aUser2;
        this.checked = checked;
    }

    public int getID(){return id;}
    public int getListe(){return liste;}
    public String getName(){return name;}
    public String getGeaendertToString(){return df.format(geaendert);}
    public String getErstelltToString(){return df.format(erstellt);}
    public Date getErstellt(){return erstellt;}
    public Date getGeaendert(){return geaendert;}
    public String getUser1(){return user_1;}
    public String getUser2(){return user_2;}
    @Override
	public String toString(){return name;}
    public String getComment(){return comment;}
    public String getErsatztext() {return ersatztext;}

    public void setID(int aID){id=aID;}
    public void setListe(int aListe){liste = aListe;}
    public void setName(String aName){name = aName;}
    public void setComment(String aComment){comment = aComment;}
    public void setErstellt(Date aErstellt){erstellt = aErstellt;}
    public void setGeaendert(Date aGeaendert){geaendert = aGeaendert;}
    public void setUser1(String aUser){user_1 = aUser;}
    public void setUser2(String aUser){user_2 = aUser;}
    public void setErsatztext(String ersatztext) {this.ersatztext=ersatztext;}

	public String getHg() {
		return hg;
	}

	public void setHg(String hg) {
		this.hg = hg;
		c_hg = getRGBColorString(hg) ;
	}

	public String getVg() {
		return vg;
	}

	public void setVg(String vg) {
		this.vg = vg;
		c_vg = getRGBColorString(vg) ;
	}

	public Color getC_hg() {
		return c_hg;
	}

	public Color getC_vg() {
		return c_vg;
	}

	/**
	 * gibt eine Farbe aus einem String zurück
	 * @param key
	 * @return
	 */
	public Color getRGBColorString(String c) {
		int r =0;
		int g = 0;
		int b=0;
		if(c.equals("")) {
			c = "000000";
		}
		try {
			r = Integer.decode("#" + c.substring(0,2)).intValue();
			g = Integer.decode("#" + c.substring(2,4)).intValue();
			b= Integer.decode("#" + c.substring(4,6)).intValue();
		}
		catch(final Exception e) {
			r=0;g=0;b=0;
		}
		return new Color(r,g,b);
	}

	public boolean isChecked() {
		return checked;
	}

	public void setChecked(boolean checked) {
		this.checked = checked;
	}

}
