/*
 * Created on 26.10.2004
 *
 */
package de.lunqual.rzpro.items.lager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;


/**
 * @author labor
 *
 */
public class LagerDruckListe extends ArrayList{

    Comparator 		compInt;
    int					mode;
    Date					von;
    Date					bis;
    String				bezeichnung;
    String 				losnummer;
    int					druck;

    public LagerDruckListe() {
        super();
        compInt = new Comparator(){
            public int compare(Object o1,Object o2){
                return (((LagerListenItem)o1).getLager().getListe() - ((LagerListenItem)o2).getLager().getListe()  );
            }
        };
    }


    public boolean hasListe(int liste) {
        if(this.size() != 0) {
	        for(int i = 0;i < this.size();i++) {
	            if(this.getItem(i).getLager().getListe() == liste) {
	                return true;
	            }
	        }
        }
        return false;
    }

    public void addItemToListe(int liste,int nummer) {
        if(this.size() != 0) {
            for(int i = 0;i < this.size();i++) {
                if(this.getItem(i).getLager().getListe()==liste) {
                    this.getItem(i).getListe().add(Integer.valueOf(nummer));
                    return;
                }
            }
        }
    }

    public void addItem(LagerListenItem li) {
        this.add(li);
        Collections.sort(this,compInt);
    }

    public LagerListenItem getItem(int i) {
        return (LagerListenItem)this.get(i);
    }

    public String getBezeichnung() {
        return bezeichnung;
    }
    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }
    public Date getBis() {
        return bis;
    }
    public void setBis(Date bis) {
        this.bis = bis;
    }
    public String getLosnummer() {
        return losnummer;
    }
    public void setLosnummer(String losnummer) {
        this.losnummer = losnummer;
    }
    public Date getVon() {
        return von;
    }
    public void setVon(Date von) {
        this.von = von;
    }

    public int getMode() {
        return mode;
    }
    public void setMode(int mode) {
        this.mode = mode;
    }

}
