package de.lunqual.rzpro.items.kontrakt;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBKontrakte;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.options.OptionFactory;

public class kontraktItem {
	RzPro				rz;
	int					id;
	String 				nameString;
	int 					typ;
	String				adresseTextString;
	int					adresse_id;
	int					rezeptur;
	double				menge;
	int					einheit;
	String				bemmerkungenString;
	Date				startDate;
	Date				endDate;
	Date				erstelltDate;
	Date				geaendertDate;
	String				erstelltUserString;
	String				geaendertUserString;
	boolean				aktiv;
	EinheitsItem		einheitsItem;
	AdressItem			adressItem;
    SimpleDateFormat 	df;

	
	public kontraktItem(RzPro rz,int id,int typ,Boolean aktiv, String nameString, String adresseTextString,
			int adresse_id, int rezeptur, double menge, int einheit,
			String bemmerkungenString, Date startDate, Date endDate,
			Date erstelltDate, Date geaendertDate, String erstelltUserString,
			String geaendertUserString) {
		this.rz = rz;
		this.id = id;
		this.typ = typ;
		this.aktiv = aktiv;
		this.nameString = nameString;
		this.adresseTextString = adresseTextString;
		this.adresse_id = adresse_id;
		this.rezeptur = rezeptur;
		this.menge = menge;
		this.einheit = einheit;
		this.bemmerkungenString = bemmerkungenString;
		this.startDate = startDate;
		this.endDate = endDate;
		this.erstelltDate = erstelltDate;
		this.geaendertDate = geaendertDate;
		this.erstelltUserString = erstelltUserString;
		this.geaendertUserString = geaendertUserString;
		this.einheitsItem = rz.getDatabase().getEinheiten().getGrundeinheit(einheit);
		this.adressItem = rz.getDatabase().getAdressen().dbGetAdresse(adresse_id,true);
		df = new SimpleDateFormat("d. MMMM yyyy");
	}

	public kontraktItem(RzPro rz) {
		this.rz = rz;
		this.id = 0;
		this.typ = DBKontrakte.KONTRAKT_EINKAUF;
		this.aktiv = true;
		this.nameString = "";
		this.adresseTextString = "";
		this.adresse_id = 0;
		this.rezeptur = 0;
		this.menge = 0.0;
		this.einheit = 1;
		this.bemmerkungenString = "";
		Date date = rz.getDatabase().getServerTimestamp(); 
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		this.startDate = cal.getTime();
		
		this.endDate = date;
		this.erstelltDate = date;
		this.geaendertDate = date;
		this.erstelltUserString = rz.getDatabase().dbGetUser();
		this.geaendertUserString = rz.getDatabase().dbGetUser();
		this.einheitsItem = rz.getDatabase().getEinheiten().getEinheit(1);
		this.adressItem = null;
		df = new SimpleDateFormat("d. MMMM yyyy");
	}
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return nameString;
	}

	public void setNameString(String nameString) {
		this.nameString = nameString;
	}

	public String getAdresseText() {
		return adresseTextString;
	}

	public void setAdresseText(String adresseTextString) {
		this.adresseTextString = adresseTextString;
	}

	public int getAdresse_id() {
		return adresse_id;
	}

	public void setAdresse_id(int adresse_id) {
		this.adresse_id = adresse_id;
	}

	public int getRezeptur() {
		return rezeptur;
	}

	public void setRezeptur(int rezeptur) {
		this.rezeptur = rezeptur;
	}

	public double getMenge() {
		return menge;
	}

	public void setMenge(double menge) {
		this.menge = menge;
	}

	public int getEinheit() {
		return einheit;
	}

	public void setEinheit(int einheit) {
		this.einheit = einheit;
	}

	public String getBemerkungen() {
		return bemmerkungenString;
	}

	public void setBemerkungen(String bemmerkungenString) {
		this.bemmerkungenString = bemmerkungenString;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getErstelltDate() {
		return erstelltDate;
	}

	public void setErstelltDate(Date erstelltDate) {
		this.erstelltDate = erstelltDate;
	}

	public Date getGeaendertDate() {
		return geaendertDate;
	}

	public void setGeaendertDate(Date geaendertDate) {
		this.geaendertDate = geaendertDate;
	}

	public String getErstelltUserString() {
		return erstelltUserString;
	}

	public void setErstelltUserString(String erstelltUserString) {
		this.erstelltUserString = erstelltUserString;
	}

	public String getGeaendertUserString() {
		return geaendertUserString;
	}

	public void setGeaendertUserString(String geaendertUserString) {
		this.geaendertUserString = geaendertUserString;
	}

	public boolean isAktiv() {
		Date now = rz.getDatabase().getServerTimestamp();
		if(startDate.before(now) && endDate.after(now)) {
			return true;
		} else {
			return false;
		}
	}

	public void setAktiv(boolean aktiv) {
		this.aktiv = aktiv;
	}

	public EinheitsItem getEinheitsItem() {
		return einheitsItem;
	}
	
	public AdressItem getAdressItem()
	{
		return adressItem;
	}
	
	public String toString() {
		return nameString;
	}
	
	public String getStartDateToString() {
		return df.format(startDate);
	}
	
	public String getEndDateToString() {
		return df.format(endDate);
	}
	
	public String getErstelltToString() {
		return df.format(erstelltDate);
	}
	
	public String getGeaendertToString() {
		return df.format(geaendertDate);
	}
	
	public double getAbgerufen() {
		return rz.getDatabase().getKontrakte().getAbgerufen(this);
	}
	
	public String getTypString() {
		return typ==DBKontrakte.KONTRAKT_EINKAUF ? rz.getLocale().getString("kontrakte.typ_einkauf") : rz.getLocale().getString("kontrakte.typ_verkauf");
	}
	
	public int getTyp() {
		return typ;
	}

	public void setTyp(int typ) {
		this.typ = typ;
	}

	public String getKontraktAusgabeString() {
		return  (typ==DBKontrakte.KONTRAKT_EINKAUF ? rz.getLocale().getString("kontrakte.typ_einkauf") : rz.getLocale().getString("kontrakte.typ_verkauf")) +"  " +  rz.getLocale().formatNumber(menge,OptionFactory.NF_ONE) + " " + rz.getDatabase().getEinheiten().getGrundeinheit(einheit).getName() + 
			" Laufzeit :" + getStartDateToString() + " - " + getEndDateToString() + 
			" (Abgerufen :" + rz.getLocale().formatNumber(getAbgerufen(),OptionFactory.NF_ONE) + " " +rz.getDatabase().getEinheiten().getGrundeinheit(einheit).getName()+ ")";
	}
}
