package de.lunqual.rzpro.items.kalender;

import java.util.ArrayList;
import java.util.HashSet;

import de.lunqual.rzpro.RzPro;

public class TerminListe extends ArrayList{
	RzPro 			rz;
	HashSet			terminSet;
	long			faellig;
	long			today;
	
	public TerminListe(RzPro rz,long today) {
		this.rz = rz;
		terminSet = new HashSet();
		this.today = today;
	}
	
	public TerminItem getItem(int i) {
		return (TerminItem)this.get(i);
	}
	
	public void removeItem(int i) {
		terminSet.remove(Long.valueOf(getItem(i).getFaellig().getTimeInMillis()));
		this.remove(i);
	}
	
	public void addItem(TerminItem ti) {
		terminSet.add(Long.valueOf(ti.getFaellig().getTimeInMillis()));
		this.add(ti);
	}
	
	public boolean hasTermin(long tag) {
		return terminSet.contains(Long.valueOf(tag));
	}
	
	public String getListToString() {
		String ret="";
		for(int i=0;i < this.size();i++) {
			ret += this.getItem(i).bezeichnung + ",";
		}
		if(ret.endsWith(","))
			ret = ret.substring(0, ret.length()-1);
		return ret;
	}
	
	public String getListToHTMLString() {
		String ret="";
		for(int i=0;i < this.size();i++) {
			TerminItem ti = this.getItem(i);
			ret += "<span color=#"+ti.getVg()+" bgcolor=#"+ti.getHg() + ">";
			ret += ti.getBezeichnung() + "</span>&nbsp;,";
		}
		if(ret.endsWith(","))
			ret = ret.substring(0, ret.length()-1);
		return ret;
	}
	
	public TerminListe getTermine(long faellig) {
		TerminListe ret=new TerminListe(rz,today);
		for(int i=0;i<this.size();i++) {
			if(this.getItem(i).getFaellig().getTimeInMillis() == faellig) {
				ret.addItem(this.getItem(i));
			}
		}
		return ret;
	}
}
