package de.lunqual.rzpro.items.kalender;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class TerminItem {
	
    private static final String				DATUM_FORMAT="EEEE, dd. MMMM yyyy HH:mm";
    
	RzPro 				rz;
	int					id;
	String				bezeichnung;
	String 				comment;
	String				vg;
	String 				hg;
	Date				erstellt;
	String				erstellt_user;
	Date				geaendert;
	String				geaendert_user;
	Date				erledigt_datum;
	String				erledigt_user;
	boolean				erledigt;
	Calendar			faellig;
	SimpleDateFormat 	df;
	
	public TerminItem(RzPro rz,long faellig) {
		df = new SimpleDateFormat(DATUM_FORMAT);
		this.id = 0;
		this.faellig = Calendar.getInstance();
		this.faellig.setTimeInMillis(faellig);
		rz.roundDatum(this.faellig);
		this.rz=rz;
		this.rz = rz;
		this.bezeichnung = "";
		this.comment = "";
		this.vg = "";
		this.hg = "5dddff";
		this.erstellt = rz.getDatabase().getServerTimestamp();
		this.erstellt_user = rz.getDatabase().dbGetUser();
		this.geaendert = rz.getDatabase().getServerTimestamp();
		this.geaendert_user = rz.getDatabase().dbGetUser();
		this.erledigt_datum=rz.getDatabase().getServerTimestamp();
		this.erledigt_user="";
		this.erledigt=false;
	}
	
	public TerminItem(RzPro rz,int id, String bezeichnung, String comment, String vg,
			String hg, Date erstellt, String erstellt_user, Date geaendert,
			String geaendert_user, long faellig,boolean erledigt,Date erledigt_datum,String erledigt_user) {
		df = new SimpleDateFormat(DATUM_FORMAT);
		this.rz = rz;
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.comment = comment;
		this.vg = vg;
		this.hg = hg;
		this.erstellt = erstellt;
		this.erstellt_user = erstellt_user;
		this.geaendert = geaendert;
		this.geaendert_user = geaendert_user;
		this.faellig = Calendar.getInstance();
		this.faellig.setTimeInMillis(faellig);
		this.erledigt=erledigt;
		this.erledigt_datum=erledigt_datum;
		this.erledigt_user=erledigt_user;
	}
	
	
	
	public Date getErledigt_datum() {
		return erledigt_datum;
	}

	public void setErledigt_datum(Date erledigt_datum) {
		this.erledigt_datum = erledigt_datum;
	}

	public String getErledigt_user() {
		return erledigt_user;
	}

	public void setErledigt_user(String erledigt_user) {
		this.erledigt_user = erledigt_user;
	}

	public boolean isErledigt() {
		return erledigt;
	}

	public void setErledigt(boolean erledigt) {
		this.erledigt = erledigt;
	}

	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public String getComment() {
		return comment;
	}
	public void setComment(String comment) {
		this.comment = comment;
	}
	public String getVg() {
		return vg;
	}
	public void setVg(String vg) {
		this.vg = vg;
	}
	public String getHg() {
		return hg;
	}
	public void setHg(String hg) {
		this.hg = hg;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public String getErstellt_user() {
		return erstellt_user;
	}
	public void setErstellt_user(String erstellt_user) {
		this.erstellt_user = erstellt_user;
	}
	public Date getGeaendert() {
		return geaendert;
	}
	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}
	public String getGeaendert_user() {
		return geaendert_user;
	}
	public void setGeaendert_user(String geaendert_user) {
		this.geaendert_user = geaendert_user;
	}
	public Calendar getFaellig() {
		return faellig;
	}
	public void setFaellig(Calendar faellig) {
		this.faellig = faellig;
	}
	
	public void setFaellig(long datum) {
		this.faellig.setTimeInMillis(datum);
		rz.roundDatum(this.faellig);
	}
	public boolean isEigen() {
		return rz.getDatabase().dbGetUser().equals(erstellt_user);
	}
	
	public String getErstelltToString() {
		return df.format(getErstellt());
	}
	public String getGeaendertToString() {
		return df.format(geaendert);
	}
	public String getFaelligToString() {
		return df.format(faellig.getTime());
	}
	public String getErledigtToString() {
		return df.format(getErledigt_datum());
	}
}
