/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.inventur;

import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class InventurZeilenItem {


	public static final int		TYP_LITER = 0;
	public static final int		TYP_GEWICHT = 1;
	public static final int		TYP_LEER = 2;
	public static final int		TYP_INVALID = 3;

	public static final int		ZEILE_EXTRAKTFREI = 0;
	public static final int		ZEILE_EXTRAKT=1;

	RzPro					rz;
	int					id;
	int					typ;
	int					uebernommen;
	int					inventur;
	int					raum;
	String				raumText;
	String				tanknummer;
	int 					tanknummer_num;
	String				inhalt;
	double				staerke;
	int					extrakt;
	int					dbkey;
	double				liter;
	double				liter20;
	double				tanktemperatur;
	double				la;
	double				brutto;
	double				tara;
	double				litergewicht;
	double				netto;
	double				tafel2;
	double				tafel3;
	Date				erstellt;
	String				user_1;
	int					lager;
	String				strLager;
	String				steuer_artikel;
	int					sorte;
	String				strSorte;
	int					steuerlager;
	String				strSteuerlager;

	public InventurZeilenItem(RzPro rz,int inventur) {
		this.rz = rz;
		this.id=0;
		this.inventur = inventur;
		this.typ = TYP_INVALID;
		this.extrakt = ZEILE_EXTRAKTFREI;
		this.erstellt = new Date();
		this.lager = 1;
		this.steuer_artikel="";
		this.sorte=1;
		this.strSorte="";
		this.steuerlager=1;
		this.strSteuerlager="";
	}

	public InventurZeilenItem(RzPro rz,
			int id,
			int typ,
			int uebernommen,
			int inventur,
			int raum,
			String raumText,
			String tanknummer,
			String bezeichnung,
			double staerke,
			int extrakt,
			int dbkey,
			double liter,
			double liter20,
			double tanktemperatur,
			double la,
			double brutto,
			double tara,
			double litergewicht,
			double netto,
			double tafel2,
			double tafel3,
			Date erstellt,
			String user_1,
			int lager,
			String strLager,
			String steuer_artikel,
			int sorte,
			String strSorte,
			int steuerlager,
			String strSteuerlager
			
			) {
		super();
		this.rz = rz;
		this.id = id;
		this.typ = typ;
		this.uebernommen = uebernommen;
		this.inventur = inventur;
		this.raum = raum;
		this.raumText=raumText;
		this.tanknummer = tanknummer;
		this.inhalt = bezeichnung;
		this.staerke = staerke;
		this.extrakt=extrakt;
		this.dbkey = dbkey;
		this.liter = liter;
		this.liter20=liter20;
		this.tanktemperatur = tanktemperatur;
		this.la = la;
		this.brutto = brutto;
		this.tara = tara;
		this.litergewicht = litergewicht;
		this.netto = netto;
		this.tafel2 = tafel2;
		this.tafel3 = tafel3;
		this.erstellt = erstellt;
		this.user_1 = user_1;
		this.lager = lager;
		this.strLager = strLager;
		this.steuer_artikel=steuer_artikel;
		this.sorte=sorte;
		this.strSorte=strSorte;
		this.steuerlager=steuerlager;
		this.strSteuerlager=strSteuerlager;
		
		this.tanknummer_num = getTanknummerNumeric(this.tanknummer);
	}

	private int getTanknummerNumeric(String nummer) {
		int ret = 0;
		String n="";
		for(int i = 0;i < nummer.length();i++) {
			if((nummer.charAt(i) >='0') && (nummer.charAt(i) <='9')) {
				n += nummer.charAt(i);
			}
		}
		try {
			ret = Integer.valueOf(n).intValue();
		} catch (final Exception e) {
			ret = 0;
		}
		return ret;
	}
	
	
	
	public int getLager() {
		return lager;
	}

	public void setLager(int lager) {
		this.lager = lager;
	}

	public String getStrLager() {
		return strLager;
	}

	public void setStrLager(String strLager) {
		this.strLager = strLager;
	}

	public String getSteuer_artikel() {
		return steuer_artikel;
	}

	public void setSteuer_artikel(String steuer_artikel) {
		this.steuer_artikel = steuer_artikel;
	}

	public int getSorte() {
		return sorte;
	}

	public void setSorte(int sorte) {
		this.sorte = sorte;
	}

	public String getStrSorte() {
		return strSorte;
	}

	public void setStrSorte(String strSorte) {
		this.strSorte = strSorte;
	}

	public int getSteuerlager() {
		return steuerlager;
	}

	public void setSteuerlager(int steuerlager) {
		this.steuerlager = steuerlager;
	}

	public String getStrSteuerlager() {
		return strSteuerlager;
	}

	public void setStrSteuerlager(String strSteuerlager) {
		this.strSteuerlager = strSteuerlager;
	}

	public String getInhalt() {
		return inhalt;
	}
	public void setInhalt(String bezeichnung) {
		this.inhalt = bezeichnung;
	}
	public double getBrutto() {
		return brutto;
	}
	public void setBrutto(double brutto) {
		this.brutto = brutto;
	}
	public int getDbkey() {
		return dbkey;
	}
	public void setDbkey(int dbkey) {
		this.dbkey = dbkey;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public int getInventur() {
		return inventur;
	}
	public void setInventur(int inventur) {
		this.inventur = inventur;
	}
	public double getLa() {
		return la;
	}
	public void setLa(double la) {
		this.la = la;
	}
	public double getLiter() {
		return liter;
	}
	public void setLiter(double liter) {
		this.liter = liter;
	}
	public double getLiter20() {
		return liter20;
	}
	public void setLiter20(double liter20) {
		this.liter20 = liter20;
	}
	public double getLitergewicht() {
		return litergewicht;
	}
	public void setLitergewicht(double litergewicht) {
		this.litergewicht = litergewicht;
	}
	public double getNetto() {
		return netto;
	}
	public void setNetto(double netto) {
		this.netto = netto;
	}
	public int getRaum() {
		return raum;
	}
	public void setRaum(int raum) {
		this.raum = raum;
	}
	public double getStaerke() {
		return staerke;
	}
	public void setStaerke(double staerke) {
		this.staerke = staerke;
	}
	public double getTafel2() {
		return tafel2;
	}
	public void setTafel2(double tafel2) {
		this.tafel2 = tafel2;
	}
	public double getTafel3() {
		return tafel3;
	}
	public void setTafel3(double tafel3) {
		this.tafel3 = tafel3;
	}
	public String getTanknummer() {
		return tanknummer;
	}
	public void setTanknummer(String tanknummer) {
		this.tanknummer = tanknummer;
		this.tanknummer_num = getTanknummerNumeric(this.tanknummer);
	}
	public double getTanktemperatur() {
		return tanktemperatur;
	}
	public void setTanktemperatur(double tanktemperatur) {
		this.tanktemperatur = tanktemperatur;
	}
	public double getTara() {
		return tara;
	}
	public void setTara(double tara) {
		this.tara = tara;
	}
	public int getTyp() {
		return typ;
	}
	public void setTyp(int typ) {
		this.typ = typ;
	}
	public int getUebernommen() {
		return uebernommen;
	}
	public void setUebernommen(int uebernommen) {
		this.uebernommen = uebernommen;
	}
	public String getUser_1() {
		return user_1;
	}
	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}

	public int getExtrakt() {
		return extrakt;
	}

	public void setExtrakt(int extrakt) {
		this.extrakt = extrakt;
	}

	@Override
	public String toString() {
		return inhalt;
	}


	public String getRaumText() {
		return raumText;
	}

	public void setRaumText(String raumText) {
		this.raumText = raumText;
	}

	public int getTankNummerNum() {
		return this.tanknummer_num;
	}

	public void copyFrom(InventurZeilenItem zi) {
		this.id = zi.getId();
		this.typ = zi.getTyp();
		this.uebernommen = zi.getUebernommen();
		this.inventur = zi.getInventur();
		this.raum = zi.getRaum();
		this.raumText = zi.getRaumText();
		this.tanknummer = zi.getTanknummer();
		this.tanknummer_num = zi.getTankNummerNum();
		this.inhalt = zi.getInhalt();
		this.staerke = zi.getStaerke();
		this.extrakt=zi.getExtrakt();
		this.dbkey = zi.getDbkey();
		this.liter = zi.getLiter();
		this.liter20=zi.getLiter20();
		this.tanktemperatur = zi.getTanktemperatur();
		this.la = zi.getLa();
		this.brutto = zi.getBrutto();
		this.tara = zi.getTara();
		this.litergewicht = zi.getLitergewicht();
		this.netto = zi.getNetto();
		this.tafel2 = zi.getTafel2();
		this.tafel3 = zi.getTafel3();
		this.erstellt = zi.getErstellt();
		this.user_1 = zi.getUser_1();
		this.lager = zi.getLager();
		this.steuer_artikel = zi.getSteuer_artikel();
		this.sorte = zi.getSorte();
		this.steuerlager = zi.getSteuerlager();
		this.strLager = zi.getStrLager();
		this.strSorte = zi.getStrSorte();
		this.strSteuerlager = zi.getStrSteuerlager();
	}
}
