/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.inventur;

import java.text.SimpleDateFormat;
import java.util.Date;


import de.lunqual.rzpro.RzPro;


public class InventurItem {

	RzPro				rz;
	int					id;
	String				bezeichnung;
	String 				bemerkungen;
	Raumliste			raumliste;
	double				liter;
	double				kg;
	double				la;
	Date					erstellt;
	Date					geaendert;
	String				user_1;
	String 				user_2;

	public InventurItem(RzPro rz, int id,String bezeichnung, String bemerkungen, Raumliste raumliste, Date erstellt, Date geaendert, String user_1, String user_2) {
		this.raumliste = raumliste;
		this.rz = rz;
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.bemerkungen = bemerkungen;
		this.liter = 0.0;
		this.kg = 0.0;
		this.la = 0.0;
		this.erstellt = erstellt;
		this.geaendert = geaendert;
		this.user_1 = user_1;
		this.user_2 = user_2;
	}
	public String getBemerkungen() {
		return bemerkungen;
	}
	public void setBemerkungen(String bemerkungen) {
		this.bemerkungen = bemerkungen;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public Date getGeaendert() {
		return geaendert;
	}
	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public double getKg() {
		return kg;
	}
	public void setKg(double kg) {
		this.kg = kg;
	}
	public double getLa() {
		return la;
	}
	public void setLa(double la) {
		this.la = la;
	}
	public double getLiter() {
		return liter;
	}
	public void setLiter(double liter) {
		this.liter = liter;
	}
	public Raumliste getRaumliste() {
		return raumliste;
	}


	public void setRaumliste(Raumliste raumliste) {
		this.raumliste = raumliste;
	}

	public RzPro getRz() {
		return rz;
	}
	public void setRz(RzPro rz) {
		this.rz = rz;
	}
	public String getUser_1() {
		return user_1;
	}
	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}
	public String getUser_2() {
		return user_2;
	}
	public void setUser_2(String user_2) {
		this.user_2 = user_2;
	}


    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }

    @Override
	public String toString() {
    	return bezeichnung;
    }

}
