package de.lunqual.rzpro.items.inventur;

import java.util.HashMap;

import de.lunqual.rzpro.RzPro;

public class InventurDetail {

	RzPro	rz;
	
	HashMap<String,inventurDetailItem>	bezeichnungMap;
	HashMap<String,inventurDetailItem>	sortenMap;
	HashMap<String,inventurDetailItem>	artikelMap;
	HashMap<Integer,inventurDetailItem>	steuerlagerMap;
	HashMap<Integer,inventurDetailItem>	lagerMap;
	HashMap<String,inventurDetailItem>	raumMap;
	
	public InventurDetail(RzPro rz,InventurZeilenliste zl) {
		this.rz = rz;
		bezeichnungMap = new HashMap<String,inventurDetailItem>();
		sortenMap = new HashMap<String,inventurDetailItem>();
		artikelMap = new HashMap<String,inventurDetailItem>();
		steuerlagerMap = new HashMap<Integer,inventurDetailItem>();
		lagerMap = new HashMap<Integer,inventurDetailItem>();
		raumMap = new HashMap<String,inventurDetailItem>();
		rechnen(zl);
	}
	
	public void rechnen(InventurZeilenliste zl) {
		for(int i = 0; i< zl.size();i++) {
			InventurZeilenItem iz = zl.getItem(i);
			addZeile(iz);
		}
	}
	
	public void addZeile(InventurZeilenItem iz) {
		inventurDetailItem id;
		if( bezeichnungMap.containsKey(iz.getInhalt())){
			id = bezeichnungMap.get(iz.getInhalt());
			if(id != null) {
				addDetail(iz,id);
			}
		}else {
			id = new inventurDetailItem();
			if(id != null) {
				addDetail(iz,id);
				bezeichnungMap.put(iz.getInhalt(), id);
			}
		}
		if( sortenMap.containsKey(iz.getStrSorte())){
			id = sortenMap.get(iz.getStrSorte());
			if(id != null) {
				addDetail(iz,id);
			}
		}else {
			id = new inventurDetailItem();
			if(id != null) {
				addDetail(iz,id);
				sortenMap.put(iz.getStrSorte(), id);
			}
		}
		
		if( artikelMap.containsKey(iz.getSteuer_artikel())){
			id = artikelMap.get(iz.getSteuer_artikel());
			if(id != null) {
				addDetail(iz,id);
			}
		}else {
			id = new inventurDetailItem();
			if(id != null) {
				addDetail(iz,id);
				artikelMap.put(iz.getSteuer_artikel(), id);
			}
		}
		
		if( steuerlagerMap.containsKey(iz.getSteuerlager())){
			id = steuerlagerMap.get(iz.getSteuerlager());
			if(id != null) {
				addDetail(iz,id);
			}
		}else {
			id = new inventurDetailItem();
			if(id != null) {
				addDetail(iz,id);
				steuerlagerMap.put(iz.getSteuerlager(), id);
			}
		}
		
		if( lagerMap.containsKey(iz.getLager())){
			id = lagerMap.get(iz.getLager());
			if(id != null) {
				addDetail(iz,id);
			}
		}else {
			id = new inventurDetailItem();
			if(id != null) {
				addDetail(iz,id);
				lagerMap.put(iz.getLager(), id);
			}
		}		
		if( raumMap.containsKey(iz.getRaumText())){
			id = raumMap.get(iz.getRaumText());
			if(id != null) {
				addDetail(iz,id);
			}
		}else {
			id = new inventurDetailItem();
			if(id != null) {
				addDetail(iz,id);
				raumMap.put(iz.getRaumText(), id);
			}
		}
		
	}
	
	private void addDetail(InventurZeilenItem iz,inventurDetailItem id) {
		id.addCount();
		id.addLiter(iz.getLiter20());
		id.addLa(iz.getLa());
	}
	public inventurDetailItem getBezeichnung(String s) {
		return bezeichnungMap.get(s);
	}
	public inventurDetailItem getSorte(String s) {
		return sortenMap.get(s);
	}
	
	public inventurDetailItem getArtikel(String s) {
		return artikelMap.get(s);
	}
	
	public inventurDetailItem getSteuerlager(int i) {
		return steuerlagerMap.get(i);
	}
	public inventurDetailItem getLager(int i) {
		return lagerMap.get(i);
	}
	public inventurDetailItem getRaum(String s) {
		return raumMap.get(s);
	}
}
