/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.hilfe;


import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;


/**
 *
 * @author  lunqual
 */
public class HilfeFileListe extends ArrayList {

    Collator        		coll;
    Comparator      compString;

    /** Creates a new instance of HilfeFileListe */
    public HilfeFileListe() {
        super();
        coll = Collator.getInstance(Locale.getDefault());
        compString = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((HilfeFileItem)o1).getDescription();
                final String s2 = ((HilfeFileItem)o2).getDescription();
              	return coll.compare(s1,s2);
            }
        };
    }

    public void sort() {
    	Collections.sort(this,compString);
    }
    public void addItem(HilfeFileItem hi){
        this.add(hi);
    }

    public HilfeFileItem getItem(int i){
        return (HilfeFileItem)this.get(i);
    }
}
