package de.lunqual.rzpro.items.formulare;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;


public class FormularTypListe extends ArrayList<FormularTypItem> {

	Collator coll;
	Comparator compAlpha;
	
	public FormularTypListe() {
		super();
		coll = Collator.getInstance(Locale.getDefault());
		compAlpha = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final FormularTypItem b1 = (FormularTypItem) o1;
				final FormularTypItem b2 = (FormularTypItem) o2;
				return coll.compare(b1.getTitel(), b2.getTitel());
			}
		};	
	}

	public void addItem(FormularTypItem fti) {
		this.add(fti);
	}
	
	public void sort() {
		Collections.sort(this, compAlpha);
	}
	
	
}
