/*
 *  Copyright (C) Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.etiketten;

import java.util.ArrayList;

public class EtikettenListe extends ArrayList {

	EtikettenBogenItem			bogen;
	int									startEtikett;

	public EtikettenListe() {
		super();
		startEtikett = 1;
	}

	public void setStartEtikett(int start) {
		this.startEtikett = start;
	}

	public int getStartEtikett() {
		return startEtikett;
	}

	public void setBogen(EtikettenBogenItem bogen) {
		this.bogen = bogen;
	}

	public EtikettenBogenItem getBogen() {
		return bogen;
	}

	public void addItem(EtikettenItem etikett) {
		this.add(etikett);
	}

	public EtikettenItem getItem(int n) {
		return (EtikettenItem)this.get(n);
	}

	public boolean getEven(EtikettenItem ei) {
		boolean ret = false;
		for(int i = 0 ; i < this.size();i++) {
			if(ei == this.getItem(i)) {
				if((i % 2) ==0) {
					ret = true;
				} else {
					ret = false;
				}
				break;
			}
		}
		return ret;
	}
	public void addListe(EtikettenListe l) {
		if(!l.isEmpty()) {
			for(int i=0;i<l.size();i++){
				this.addItem(l.getItem(i));
			}
		}
	}
}
