/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.ergebnis;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

/**
 * 
 * @author lunqual
 */
public class ErgebnisListe extends ArrayList {

	Collator coll;
	Comparator compAlpha;
	Comparator compDate;
	Comparator compStichworte;
	Comparator compFuellstand;
	Comparator compKonform;
	Comparator compTyp;
	
	boolean reverseAlpha=true;
	boolean reverseDatum=true;
	boolean reverseStichworte=true;
	boolean reverseFuellstand=true;
	boolean reverseKonform = true;
	boolean reverseTyp = true;
	
	Date 		nullDatum;
	/** Creates a new instance of AbfrageListe */
	public ErgebnisListe() {
		super();
    	nullDatum = new Date();
    	nullDatum.setTime(0);
    	
		coll = Collator.getInstance(Locale.getDefault());
		compAlpha = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ErgebnisItem b1 = (ErgebnisItem) o1;
				final ErgebnisItem b2 = (ErgebnisItem) o2;
				// alphabetische Ordnung
				return coll.compare(b1.getBezeichnung(), b2.getBezeichnung());
			}
		};
		compTyp = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ErgebnisItem b1 = (ErgebnisItem) o1;
				final ErgebnisItem b2 = (ErgebnisItem) o2;
				return b1.getTyp() >b2.getTyp() ?1:-1;
			}
		};
		compDate = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ErgebnisItem b1 = (ErgebnisItem) o1;
				final ErgebnisItem b2 = (ErgebnisItem) o2;
				return b1.getDate().compareTo(b2.getDate());
			}
		};
		compKonform = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ErgebnisItem b1 = (ErgebnisItem) o1;
				final ErgebnisItem b2 = (ErgebnisItem) o2;
				Date b1d = b1.getKonformDatum() == null?nullDatum:b1.getKonformDatum();
				Date b2d = b2.getKonformDatum() == null?nullDatum:b2.getKonformDatum();
				return b1d.compareTo(b2d);
			}
		};
		
		compStichworte = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ErgebnisItem b1 = (ErgebnisItem) o1;
				final ErgebnisItem b2 = (ErgebnisItem) o2;
				return coll.compare(b1.getStichwortString(),
						b2.getStichwortString());
			}
		};
		compFuellstand = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ErgebnisItem b1 = (ErgebnisItem) o1;
				final ErgebnisItem b2 = (ErgebnisItem) o2;
				int r =0;
				try {
					if(b1.getPercent() == b2.getPercent()) {
						r = 0;
					} else {
						if (b1.getPercent() > b2.getPercent()) {
							r = -1;
						} else {
							r = 1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
	}

	/*---------------------------------------------------------
	 * die Liste sortieren
	 *---------------------------------------------------------
	 */

	public void sortTyp() {
		if (reverseTyp) {
			Collections.sort(this, compTyp);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compTyp);
		}
		reverseTyp=!reverseTyp;
	}
	public void sortAlpha() {
		if (reverseAlpha) {
			Collections.sort(this, compAlpha);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compAlpha);
		}
		reverseAlpha=!reverseAlpha;
	}

	public void sortDate() {
		if (reverseDatum) {
			Collections.sort(this, compDate);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compDate);
		}
		reverseDatum=!reverseDatum;
	}


	public void sortKonform() {
		if (reverseKonform) {
			Collections.sort(this, compKonform);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compKonform);
		}
		reverseKonform=!reverseKonform;
	}
	public void sortStichworte() {
		if (reverseStichworte) {
			Collections.sort(this, compStichworte);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compStichworte);
		}
		reverseStichworte=!reverseStichworte;
	}

	public void sortFuellstand() {
		if (reverseFuellstand) {
			Collections.sort(this, compFuellstand);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compFuellstand);
		}
		reverseFuellstand=!reverseFuellstand;
	}
	
	
	public void addItem(final ErgebnisItem ei) {
		this.add(ei);
	}

	public ErgebnisItem getItem(final int i) {
		try {
			return (ErgebnisItem) this.get(i);
		} catch (final Exception e) {
			return null;
		}
	}
}
