/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.ergebnis;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class ErgebnisItem {


	RzPro		 	rz;
    int             	id;
    int             	typ;
    Date          	datum;
    String        	name;
    SimpleDateFormat df;
    String			stichworte;
    String	 		adressen;
    double			liter;
    double			litergewicht;
    double			acid;
    Date				specialDate;
    double      	bestand;
    double			vorschlagsbestand;
    double			meldebestand;
    String			c_red;
    String			c_green;
    String			c_yellow;
    String			c_gray;
    String			fillchar;
    int				einheit_value;
    int				fillwidth;
    int				red_value;
    int				yellow_value;
    boolean	bestellung;
    EinheitsItem		bestandseinheit;
    StichwortListe stl;
    double staerke;
    String			artikelnummer;
    String			spezifikation;
    int				tempVon;
    int				tempBis;
    boolean			auftrag;
    boolean			inarbeit;
    boolean			konform;
    Date				konformDatum;
    String				konformComment;
    Date				nullDatum;
    Date				abgang;
    Date				zugang;
    
    /** Creates a new instance of ErgebnisItem */
    public ErgebnisItem(RzPro r,int aID,int aTyp,String aName,double litergewicht,double acid,Date aDatum,String aStichworte,String aAdressen,
    		double vorschlagsbestand,double bestand,double meldebestand,boolean bestellung,int bestandseinheit,
    		double staerke,String artikelnummer,String spezifikation,int tempVon,int tempBis,boolean auftrag,boolean inarbeit) {
    	nullDatum = new Date();
    	nullDatum.setTime(0);
    	rz = r;
        id = aID;
        typ = aTyp;
        name = aName;
        datum = aDatum;
        stichworte = aStichworte;
        adressen = aAdressen;
        liter = 0.0;
        this.litergewicht = litergewicht;
        this.acid=acid;
        this.vorschlagsbestand=vorschlagsbestand;
        this.bestand=bestand;
        this.meldebestand=meldebestand;
        this.bestellung=bestellung;
        df = new SimpleDateFormat("dd.MM.yyyy");
        setStichwortliste(stichworte);
    	if(bestandseinheit != 0) {
    		this.bestandseinheit=rz.getDatabase().getEinheiten().getGrundEinheit(bestandseinheit);
    	}else {
    		this.bestandseinheit=null;
    	}
    	this.staerke=staerke;
    	this.artikelnummer=artikelnummer;
    	this.spezifikation=spezifikation;
    	this.tempBis=tempBis;
    	this.tempVon=tempVon;
    	this.auftrag=auftrag;
    	this.inarbeit=inarbeit;
    	this.konform = false;
    	this.konformComment = "";
    	this.konformDatum = nullDatum;
    	this.abgang=null;
    	this.zugang = null;
    	getOptions();
    }

    public ErgebnisItem(RzPro r,int aID,int aTyp,String aName,double litergewicht,double acid,Date aDatum,String aStichworte,String aAdressen,
    		double vorschlagsbestand,double bestand,double meldebestand,boolean bestellung,int bestandseinheit,
    		double staerke,String artikelnummer,String spezifikation,int tempVon,int tempBis,boolean auftrag,boolean inarbeit,
    		boolean konform,Date konformDatum,String konformComment  		) {
	    	nullDatum = new Date();
	    	nullDatum.setTime(0);
	    	rz = r;
	        id = aID;
	        typ = aTyp;
	        name = aName;
	        datum = aDatum;
	        stichworte = aStichworte;
	        adressen = aAdressen;
	        liter = 0.0;
	        this.litergewicht = litergewicht;
	        this.acid=acid;
	        this.vorschlagsbestand=vorschlagsbestand;
	        this.bestand=bestand;
	        this.meldebestand=meldebestand;
	        this.bestellung=bestellung;
	        df = new SimpleDateFormat("dd.MM.yyyy");
	        setStichwortliste(stichworte);
	    	if(bestandseinheit != 0) {
	    		this.bestandseinheit=rz.getDatabase().getEinheiten().getGrundEinheit(bestandseinheit);
	    	}else {
	    		this.bestandseinheit=null;
	    	}
	    	this.staerke=staerke;
	    	this.artikelnummer=artikelnummer;
	    	this.spezifikation=spezifikation;
	    	this.tempBis=tempBis;
	    	this.tempVon=tempVon;
	    	this.auftrag=auftrag;
	    	this.inarbeit=inarbeit;
	    	this.konform = konform;
	    	this.konformComment = konformComment;
	    	this.konformDatum = konformDatum != null?konformDatum:nullDatum;
	    	this.abgang=null;
	    	this.zugang=null;
	    	getOptions();
    }
    
    
    public Date getAbgang() {
		return abgang;
	}

	public void setAbgang(Date abgang) {
		this.abgang = abgang;
	}
	
	public Date getZugang() {
		return zugang;
	}

	public void setZugang(Date zugang) {
		this.zugang = zugang;
	}

	public void setKonform(boolean konform) {
		this.konform = konform;
	}

	public void setKonformDatum(Date konformDatum) {
		this.konformDatum = konformDatum;
	}

	public void setKonformComment(String konformComment) {
		this.konformComment = konformComment;
	}

	public boolean isKonform() {
		return konform;
	}



	public Date getKonformDatum() {
		return konform?konformDatum:null;
	}



	public String getKonformComment() {
		return konform?konformComment:"";
	}



	public boolean isInarbeit() {
		return inarbeit;
	}

    public void setInarbeit(boolean inarbeit) {
    	this.inarbeit=inarbeit;
    }


	public boolean isAuftrag() {
		return auftrag;
	}

    public void setAuftrag(boolean auftrag) {
    	this.auftrag = auftrag;
    }


	public int getTemperaturDurchschnitt() {
    	return (tempVon+tempBis)/2;
    }
    
    public int getTempVon() {
		return tempVon;
	}



	public int getTempBis() {
		return tempBis;
	}



	public void setStichwortliste(int id) {
    	String stichworte = rz.getDatabase().getRezeptur().getStichworte(id);
    	this.stichworte = stichworte;
    	setStichwortliste(stichworte);
    }
    
    private void setStichwortliste(String stichworte) {
        if(stichworte != null && !stichworte.equals("")) {
        	stl=rz.getDatabase().getSTW().dbGetStichwortListe(stichworte);
        }else {
        	stl=new StichwortListe();
        }
    	
    }
    
    private void getOptions() {
    	c_red=rz.getOptionFactory().getOption("auswahl.color_bestand_red");
    	c_green=rz.getOptionFactory().getOption("auswahl.color_bestand_green");
    	c_yellow=rz.getOptionFactory().getOption("auswahl.color_bestand_yellow");
    	c_gray=rz.getOptionFactory().getOption("auswahl.color_bestand_gray");
    	einheit_value=rz.getOptionFactory().getOption("auswahl.bestand_einheit",OptionFactory.AUSWAHL_BESTAND_EINHEIT);
    	fillwidth=rz.getOptionFactory().getOption("auswahl.bestand_fillwidth",OptionFactory.AUSWAHL_BESTAND_FILLWIDTH);
    	red_value=rz.getOptionFactory().getOption("auswahl.color_bestand_red_value",OptionFactory.COLOR_BESTAND_RED_VALUE);
    	yellow_value=rz.getOptionFactory().getOption("auswahl.color_bestand_yellow_value",OptionFactory.COLOR_BESTAND_YELLOW_VALUE);
    	fillchar=rz.getOptionFactory().getOption("auswahl.bestand_fillchar");    	
    }
    /**
     * erzeugt ein ErgebnisItem aus einer Rezeptur-ID
     * @param id   id der Rezeptur
     */
    public ErgebnisItem(RzPro r,int id) {
    	rz=r;
    	this.id=id;
        typ = RzPro.TYP_ID_REZEPT;
        final RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(id,true);
        if((ri != null) && (id != 0)) {
        	name = ri.getTitel();
        	datum = ri.getGeaendert();
            litergewicht = ri.getLitergewicht();
            acid=ri.getAcid();
        } else {
        	name = "";
        	datum = new Date();
            litergewicht = rz.getTafelFactory().Litergewicht(0.0);
            acid=0.0;
        }
    	stichworte = "";
    	adressen = "";
        liter = 0.0;
        df = new SimpleDateFormat("dd.MM.yyyy");
    }
    
    
    
    /**
	 * @return the spezifikation
	 */
	public String getSpezifikation() {
		return spezifikation;
	}

	public void setBestellung(boolean bestellung) {
    	this.bestellung=bestellung;
    }
    public boolean isBestellung() {
    	return bestellung;
    }
    public void setID(int aID) {id=aID;}
    public int getID(){return id;}
    public int getTyp() {return typ;}
    public String getStichworte() {return stichworte;}
    public String getAdressen() {return adressen;}
    public String getName() {return name;}

    public void setBezeichnung(String b) {
    	name = b;
    }
    public String getBezeichnung() {
    	return name;
    }
    
    public Date getDate() {
    	return datum;
    }
    
    public String getDatum() {
    	return  df.format(datum);
    }
    
    public String getStichwortString() {
    	return "<html>" +(stl==null?"":stl.toHTMLBarString())+ "</html>";
    }
    
    public String getFuellstand() {
    	return  "<html>" + getFillGauge() + "</html>";
    }
    
	public String toString(){
		return "<html>" + name  +" (" + df.format(datum) + ")" + rz.getDatabase().getSTW().getHTMLBarString(stichworte)  + getFillGauge()+ "</html>";
    }
    public void setLiter(double liter) {
        this.liter = liter;
    }
    public double getLiter() {
        return liter;
    }

	public double getLitergewicht() {
		return litergewicht;
	}

	public void setLitergewicht(double litergewicht) {
		this.litergewicht = litergewicht;
	}

	public double getAcid() {
		return acid;
	}

	public void setAcid(double acid) {
		this.acid = acid;
	}

	public Date getSpecialDate() {
		return specialDate;
	}
	
	public void setSpecialDate(Date d) {
		specialDate=d;
	}
	
	
	public double getPercent() {
		double percent=0.0;
	        if(typ == RzPro.TYP_ID_REZEPT && !rz.isZero(bestand) && !rz.isZero(vorschlagsbestand)) {
	        	percent = (bestand*100)/vorschlagsbestand;
	        }
		return percent >100?100:percent;
	}
	
	public double getBestand() {
		return ( bestandseinheit != null?rz.getDatabase().getEinheiten().toLiter(bestand, staerke, litergewicht,bestandseinheit) :0);
	}
	public double getBestandRaw() {
		return bestand;
	}
	
	public double getMeldebestand() {
		return (bestandseinheit != null?rz.getDatabase().getEinheiten().toLiter(meldebestand, staerke, litergewicht,bestandseinheit) :0);
	}
	public double getMeldebestandRaw() {
		return meldebestand;
	}
	
	
	public void setBestand(double bestand) {
		this.bestand=bestand;
	}

	public double getVorschlagsBestand() {
		return ( bestandseinheit != null?rz.getDatabase().getEinheiten().toLiter(vorschlagsbestand, staerke, litergewicht,bestandseinheit) :0);
	}
	public double getVorschlagsBestandRaw() {
		return vorschlagsbestand;
	}
	
	public double getDifferenz() {
		double differenz=0.0;
		if(bestandseinheit != null) {
			if(vorschlagsbestand >0 && (bestand < meldebestand)) {
				differenz = rz.getDatabase().getEinheiten().toLiter(vorschlagsbestand - bestand, staerke, litergewicht,bestandseinheit) ;
				if (differenz <=0.0) {
					differenz = 0.0;
				}
			}
		}
		return differenz;
	}
	
	public void setVorschlagsBestand(double bestand) {
		this.vorschlagsbestand=bestand;
	}
	
	
	private String getFillGauge() {
		String ret ="";
		String fg="";
		double percent=getPercent();
		fg=c_green;
		if(!rz.isZero(percent)) {
			if(percent <=red_value) {
				fg=c_red; 
			}else if(rz.isZero(meldebestand)) {
				if(percent <= yellow_value) {
					fg=c_yellow;
				}
				}else {
					if(meldebestand >= bestand) {
						fg=c_yellow;
					}
			}
			int foreground=(int)(fillwidth * (percent/100));
			if(foreground <1) {
				foreground=1;
			}
			int background=fillwidth - foreground;
			int i;
			ret+="<font color=\"" + fg +"\" bgcolor="  + fg+ ">";
			for(i=0;i<foreground;i++) {
				ret+=fillchar;
			}
			ret+="</font>";
			ret+="<font color=\"" + c_gray +"\" bgcolor="  +c_gray+ ">";
			for(i=0;i<background;i++) {
				ret+=fillchar;
			}
			ret +="</font>";
		}else {
			if(!rz.isZero(bestand) && rz.isZero(percent)) {
				//mehrere Balken
				int einheit = (int)(bestand/einheit_value);
				if((einheit >fillwidth/2)) {
					einheit = (fillwidth/2);
				}else {
					if(einheit == 0) {
						einheit=1;
					}
				}
				for(int i=0;i<einheit;i++) {
					ret+="<font bgcolor=\"" + c_gray+ "\">&nbsp;</font>&nbsp" ;
				}
			}
		}

		return  "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"   + ret;
	}
	public String getStichwortListe() {
		if(stl != null) {
			return "<html><center><b>" + name + "<br><br></b>"+stl.toHTMLString()+"</center></html>";
		} else {
			return null;
		}
	}

	public EinheitsItem getBestandseinheit() {
		return bestandseinheit;
	}

	public void setBestandseinheit(EinheitsItem bestandseinheit) {
		this.bestandseinheit = bestandseinheit;
	}

	public String getArtikelnummer() {
		return artikelnummer;
	}

	
	
	}
