/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.deklarationen;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;

import de.lunqual.rzpro.RzPro;

public class DeklarationsListe extends ArrayList implements Serializable{

	RzPro								rz;
    private final Collator        		coll;
    private final Comparator      	compInt;
    private final Comparator      	compString;

	public DeklarationsListe(RzPro rz) {
		super();
		this.rz= rz;
        coll = Collator.getInstance(Locale.getDefault());
        compInt = new Comparator(){
            public int compare(Object o1,Object o2){
                return (((DeklarationsItem)o1).getId() - ((DeklarationsItem)o2).getId()  );
            }
        };
        compString = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((DeklarationsItem)o1).getName();
                final String s2 = ((DeklarationsItem)o2).getName();
                return coll.compare(s1,s2);
            }
        };
	}

    /*---------------------------------------------------------
     * testen ob ein Item vorhanden ist
     *---------------------------------------------------------
     */
    public boolean isInList(int aKey){
        for(int i = 0; i < this.size();i++){
            if (aKey == this.getItem(i).getId()) {
				return true;
			}
        }
        return false;
    }

	public void addItem(DeklarationsItem di) {
		if(di != null) {
			this.add(di);
			sortItemsAlpha();
		}
	}

    private int getItemIndex(int aKey){
        for(int i = 0;i < this.size();i++){
            if (((DeklarationsItem)get(i)).getId() == aKey ){
                return i;
            }
        }
        return -1;
    }

    /*---------------------------------------------------------
     * ein Item entfernen
     *---------------------------------------------------------
     */
    public void removeItem(DeklarationsItem di){
        final int i = getItemIndex(di.getId());
        if (i != -1){
            this.remove(i);
            sortItemsAlpha();
        }
    }

	public DeklarationsItem getItem(int i) {
		return (DeklarationsItem)this.get(i);
	}

    /*---------------------------------------------------------
     * die Liste aufsteigend nach ID sortieren
     *---------------------------------------------------------
     */
    public void sortItems(){
        Collections.sort(this,compInt);
    }

    /*---------------------------------------------------------
     * die Liste aufsteigend nach Namen sortieren
     *---------------------------------------------------------
     */
    public void sortItemsAlpha(){
        Collections.sort(this,compString);
    }

    /*---------------------------------------------------------
     * liste kopieren
     *---------------------------------------------------------
     */
    public DeklarationsListe copyList(){
        final DeklarationsListe ret = new DeklarationsListe(rz);
        for(int i = 0;i < this.size();i++) {
			ret.addItem(this.getItem(i).copyItem());
		}
        return ret;
    }

    /**
     * toVerboseString() liefert alle Stichworte in einem String, durch
     * Kommata getrennt
     */
    public String toVerboseString(){
        sortItemsAlpha();
        String ret = "";
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += ((DeklarationsItem)get(i)).getName() + ", ";
            }
        }
        return ret.replaceAll(",.$","");
    }

    /**
     * toString() liefert den String, der in die Datenbank geschrieben wird
     * z.B. "<1><29><132>"
     */
    @Override
	public String toString(){
        String ret = "";
        sortItems();
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "<" + ((DeklarationsItem)get(i)).getId() + ">";
            }
        }
        sortItemsAlpha();
        return ret;
    }

    /**
     * toSQLAndString() liefert den suchstring für eine UND-Verknüpfung der
     * Stichworte,
     * z.B. "<1>.*<29>.*<132>"
     */
    public String toSQLAndString(){
        String ret = "";
        sortItems();
        if (this.size() == 0){
            return "";
        }
        else {
            for(int i = 0;i < this.size();i++){
                ret += "<" + this.getItem(i).getId() + ">.*";
            }
        }
        sortItemsAlpha();
        return ret.replaceAll("\\.\\*$","");
    }

    /**
     * Eine Liste erweitern
     */
    public void mergeListe(String liste) {
    	if(!liste.equals("")) {
            liste = liste.replaceAll("[<|>]"," ").replaceAll("%","");
            final StringTokenizer stt = new StringTokenizer(liste);
            while (stt.hasMoreTokens()){
                    final int k = Integer.parseInt( stt.nextToken());
                    if(!isInList(k)) {
                    	this.addItem(rz.getDatabase().getDeklarationen().getDeklaration(k));
                }
            }
    	}
    }
    /**
     * Alle Deklarationen selbst als Fliesstext ausgeben
     */
    public String toVerboseDeklarationenString() {
    	String ret = "";
    	for(int i=0;i <this.size();i++) {
    		ret += this.getItem(i).getDeklaration() + "\n";
    	}
    	if(ret.endsWith("\n")) {
			ret = ret.substring(0,ret.length() - "\n".length());
		}
    	return ret;
    }
}
