/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.currency;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
/**
 *
 * @author  lunqual
 */
public class CurrencyItem implements Serializable {

    int         id;
    String      name;
    String      shortName;
    double      rate;
    Date        datum;
    String      user_1;
    SimpleDateFormat df;
    /** Creates a new instance of currencyItem */
    public CurrencyItem() {
        id=0;
        name = "";
        shortName = "";
        rate = 0;
        df = new SimpleDateFormat(RzPro.DATEFORMAT_NORMAL);
        datum = new Date();
        user_1 ="";
    }

    public CurrencyItem(int aID, String aName, String aShortName, double aRate,Date aDatum,String aUser){
        id = aID;
        name = aName;
        shortName = aShortName;
        rate = aRate;
        datum = aDatum;
        user_1 = aUser;
        df = new SimpleDateFormat("dd.MM.yyyy H:mm:ss");
    }

    public int getID(){return id;}
    public String getName(){return name;}
    public String getShortName(){return shortName;}
    public double getRate(){return rate;}
    public Date getDatum(){return datum;}
    public String getGeaendertToString(){return df.format(datum);}
    public String getUser1(){return user_1;}
    @Override
	public String toString(){return shortName + " (" + name + ") ";}
    public void setID(int aID){id=aID;}
    public void setName(String aName){name = aName;}
    public void setShortName(String aName){shortName = aName;}
    public void setRate(double aRate){rate = aRate;}
    public void setDatum(Date aDatum){datum = aDatum;}
    public void setUser(String aUser){user_1 = aUser;}
}

