package de.lunqual.rzpro.items.buchung;

import java.text.SimpleDateFormat;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;

public class commentLosnummerListe extends ArrayList {
	
	RzPro rz;
	SimpleDateFormat df=new SimpleDateFormat("MMMM / yyyy");
	
	public commentLosnummerListe(RzPro rz) {
		super();
		this.rz=rz;
		
	}
	
	public void addItem(commentLosnummerItem cli) {
		this.add(cli);
	}
	
	public commentLosnummerItem getItem(int i) {
		return (commentLosnummerItem)this.get(i);
	}
	
	public String getCommentListeHTML() {
		String ret="";
		for(int i=0;i<this.size();i++) {
			commentLosnummerItem cli = this.getItem(i);
			ret += "<a href=\"DD:" + cli.getDatumRaw().getTime() + "\">"+cli.getDatum()+"</a>";
			ret +=  " : " + cli.getComment() + "&nbsp;<i>("; 
			ret += "<a href=\"vrlf:" +cli.getLosnummer() + "\">"  +cli.getLosnummer() + "</a>&nbsp;:&nbsp;" + cli.getLiter()+ ")</i>";
			
			ret += "&nbsp;" + "<a href=\"mhd:" + String.valueOf(cli.getId())+"\">" + rz.getLocale().getString("commentlosnummer.mhd-link") ;
			ret+=rz.getDatabase().getBuchungen().getMhdStringHtml(cli.getMhdLong());
			ret+="</a>";
			ret += "<a href=\"etm:" + String.valueOf(cli.getId())+"\">" ;
			ret += "<img src=\"" + getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.img_etiketten.png").toString() + "\" border=\"0\">";
			ret += 	"</a><br>";
			
			if(rz.getDatabase().getDM().isConnected() && rz.getOptionFactory().getOption("ausgabe.auswahl_dichte_anzeigen",0) == 1)  {
				if(cli.getDmliste() != null && !cli.getDmliste().isEmpty()) {
	    			ret += rz.getDatabase().getDM().getDMListeHtml(cli.getDmliste(),true);
	        	}
			}
			if(cli.getMischung()!=0) {
				ret += rz.getLocale().getString("commentlosnummeritem.mischung")+ "<a href=\"MM:"+String.valueOf(cli.getMischung())+"\">" + "&nbsp;"+String.valueOf(cli.getMischung())+"&nbsp;</a><br>";
			}
			
		}
		return ret;
	}
	public String getTankString() {
		String ret="";
		for(int i=0;i<this.size();i++) {
			commentLosnummerItem cli = this.getItem(i);
			ret += cli.getTank();
		}
		return ret;
	}
	
	
}
