package de.lunqual.rzpro.items.buchung;

import java.util.ArrayList;
import java.util.Date;
import java.text.SimpleDateFormat;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.dm.DMItem;

public class commentLosnummerItem {
	RzPro		rz;
	Date		datum;
	String losnummer;
	String comment;
	String start;
	String ende;
	String liter;
	String tank;
	int	  id;
	long	mhd;
	String  bezeichnung;
	SimpleDateFormat df;
	int		mischung;
	ArrayList<DMItem> dmliste; 
	
	public commentLosnummerItem(RzPro rz,int id,String bezeichnung,Date datum,String losnummer, String comment,String liter,String tank,String start,String ende,int mischung) {
		this.rz=rz;
		this.datum=datum;
		this.losnummer = losnummer;
		this.comment = comment;
		this.start=start;
		this.ende=ende;
		this.liter=liter;
		this.tank=tank;
		this.id=id;
		this.bezeichnung=bezeichnung;
		this.mischung=mischung;
		mhd = 0;
		df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
		if(this.losnummer != null && !this.losnummer.equals("")) {
			this.dmliste = rz.getDatabase().getDM().getMessung(this.losnummer);
		}
	}

	public commentLosnummerItem(RzPro rz,int id,String bezeichnung,Date datum,String losnummer, String comment,String liter,String tank,String start,String ende,long mhd,int mischung) {
		this.rz=rz;
		this.datum=datum;
		this.losnummer = losnummer;
		this.comment = comment;
		this.start=start;
		this.ende=ende;
		this.liter=liter;
		this.tank=tank;
		this.mhd=mhd;
		this.id=id;
		this.bezeichnung=bezeichnung;
		this.mischung = mischung;
		df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
		if(this.losnummer != null && !this.losnummer.equals("")) {
			this.dmliste = rz.getDatabase().getDM().getMessung(this.losnummer);
		}
	}
	
	public int getMischung() {
		return mischung;
	}

	public String getLosnummer() {
		return losnummer;
	}
	
	public int getId() {
		return id;
	}

	public boolean isMhd() {
		return mhd==0?false:true;
	}

	public Date getMhd() {
		Date d = null;
		if(mhd != 0) {
			d=new Date();
			d.setTime(mhd);
		}
		return d;
	}
	
	public long getMhdLong() {
		return mhd;
	}
	
	private String extractComment() {
    	String out ="";
    	if(comment.indexOf(start) != -1) {
    		int st = comment.indexOf(start)+ start.length();
    		int len = comment.substring(st).indexOf(ende);
    		if(len != -1) {
    			out=  comment.substring(st,st+len).replaceAll(";"," ").replaceAll(":"," ").replaceAll(","," ").replaceAll("\\s"," ") + ",";
    		}
    	}
    	if(out.endsWith(","))out=out.substring(0,out.length()-1);
    	String out1="";
    	String[] x = out.split(" ");
    	for(String t:x) {
    		if(!t.trim().equals("")) {
	    		if(rz.getDatabase().getTank().tankExists(t.trim())){
	    			out1+="<a href=\"ttt:"+t+"\">"+t+"</a>&nbsp;";
	    		} else {
	    			out1+=t + "&nbsp;";
	    		}
    		}
    	}
    	return "(&nbsp;<a href=\"tco:" +
    		String.valueOf(id) + "\">"  +rz.getLocale().getString("comment.tank") + "</a>&nbsp;" + 
    		"&nbsp;" + out1+")";
    }
    	
	public String getTank() {
		String out ="";
    	if(comment.indexOf(start) != -1) {
    		int st = comment.indexOf(start)+ start.length();
    		int len = comment.substring(st).indexOf(ende);
    		if(len != -1) {
    			out=  comment.substring(st,st+len).replaceAll(";"," ").replaceAll(":"," ").replaceAll(","," ").replaceAll("\\s"," ") + ",";
    		}
    	}
    	if(out.endsWith(","))out=out.substring(0,out.length()-1);
    	String out1="";
    	String[] x = out.split(" ");
    	for(String t:x) {
    		if(!t.trim().equals("")) {
	   			out1+=t + "  ";
    		}
    	}
    	return out1;
	}
	
	public String getComment() {
		return extractComment();
	}
	public String getDatum() {
		return df.format(datum);
		}
	
	public Date getDatumRaw() {
		return datum;
	}
	
	public String getLiter() {
		return liter;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public ArrayList<DMItem> getDmliste() {
		return dmliste;
	}

	public void setDmliste(ArrayList<DMItem> dmliste) {
		this.dmliste = dmliste;
	}


	
}
